<?php
/**
 * @version
 */

/**
 * This is abstract class for 3 action classes that are Install, Update and Uninstall.
 */
class Legacy_AbstractModuleInstallAction extends Legacy_Action
{
	/**
	 * XoopsModule instance specified.
	 */
	var $mModuleObject = null;
	var $mLog = null;
	
	var $mActionForm = null;
	
	function prepare(&$controller, &$xoopsUser)
	{
		$this->_setupActionForm();
	}
	
	function _setupActionForm()
	{
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$dirname = trim($_GET['dirname']);

		$installer =& $this->_getInstaller($dirname);

		$this->mModuleObject =& $installer->loadModuleObject($dirname);

		if (!is_object($this->mModuleObject)) {
			$this->mLogLog =& $installer->getLog();
			return LEGACY_FRAME_VIEW_ERROR;
		}

		$this->mActionForm->load($this->mModuleObject);
		
		$this->mModuleObject->loadAdminMenu();
		$this->mModuleObject->loadInfo($dirname);
		
		return LEGACY_FRAME_VIEW_INDEX;
	}

	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		$installer =& $this->_getInstaller($this->mActionForm->get('dirname'));
		$this->mModuleObject =& $installer->loadModuleObject($this->mActionForm->get('dirname'));
		
		if ($installer->hasAgree()) {
			$this->_loadAgreement();
		}

		if ($this->mActionForm->hasError()) {
			return LEGACY_FRAME_VIEW_INPUT;
		}
		
		if (!is_object($this->mModuleObject)) {
			return LEGACY_FRAME_VIEW_ERROR;
		}

		$installer->setForceMode($this->mActionForm->get('force'));
		$installer->execute($this->mActionForm->get('dirname'));

		$this->mLog =& $installer->getLog();
		
		return LEGACY_FRAME_VIEW_SUCCESS;
	}

	/**
	 * Return a procedure for this process.
	 */
	function &_getInstaller($dirname)
	{
	}
	
	function _loadAgreement()
	{
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("install_wizard_error.html");
		$renderer->setAttribute('log', $this->mLog);
	}
}

?>