<?php
// $Id$
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                  Copyright (c) 2005 XOOPS Cube.org                        //
//                     <http://www.xoopscube.org/>                           //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

require_once XOOPS_MODULE_PATH."/user/forms/UserSimpleActionForm.class.php";

/**
This class is ported from bxBase.
I must change this to Dynamic ActionForm.
*/
class LostpassForm extends UserModActionForm
{
	var $mEmailAddress=null;

	function startup(&$master)
	{
		if($_SERVER['REQUEST_METHOD']=="POST") {
			$this->fetch($master);
			$this->validate($master);
			return $this->hasError() ? UCONTROLLER_ACTIONFORM_ERROR : UCONTROLLER_ACTIONFORM_SUCCESS;
		}
		else {
			$this->load($master);
			return UCONTROLLER_ACTIONFORM_INIT;
		}
	}

	function fetch(&$master)
	{
		$this->mEmailAddress=isset($_REQUEST['email']) ? trim($_REQUEST['email']) : null;
	}

	function validate (&$master)
	{
		if(!$this->mEmailAddress) {
			$this->addErrorMessage("Email not input");
		}
		else {
			$myts =& MyTextSanitizer::getInstance();
			$memberHandler =& xoops_gethandler('member');
			$user=&$memberHandler->getUsersByEmail($this->mEmailAddress);
			if(!$user)
				$this->addErrorMessage("Can't fetch user");
		}
	}
	
	function load(&$master)
	{
	}
	
	function hasError()
	{
		return count($this->errors_) ? true : false;
	}
}
?>