<?php

require_once XOOPS_ROOT_PATH."/modules/user/class/RankObject.class.php";
require_once XOOPS_ROOT_PATH."/modules/user/admin/forms/RankEditForm.class.php";

class UserRankEditAction extends UserAction
{
	var $mRank=null;
	var $mRankHandler=null;
	var $mActionForm=null;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_proccessActionForm();
		$this->_proccessObject($controller);

		$this->mActionForm->load($this->mRank);

		return USER_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller,&$xoopsUser)
	{
		$this->_proccessActionForm();
		$this->_proccessObject($controller);

		//
		// If image is no, the data has to continue to keep his value.
		//
		$this->mActionForm->load($this->mRank);

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if($this->mActionForm->hasError())
			return USER_FRAME_VIEW_INPUT;
			
		$this->mActionForm->update($this->mRank);

		return $this->mRankHandler->insert($this->mRank) ? USER_FRAME_VIEW_SUCCESS
		                                                    : USER_FRAME_VIEW_ERROR;
	}

	function _proccessObject(&$controller)
	{
		$rank_id=isset($_REQUEST['rank_id']) ? intval($_REQUEST['rank_id']) : 0;
		$this->mRankHandler=new UserRankObjectHandler($controller->mDB);
		$this->mRank=&$this->mRankHandler->get($rank_id);
		if(!is_object($this->mRank))
			$this->mRank=&$this->mRankHandler->create();
	}
	
	function _proccessActionForm()
	{
		$this->mActionForm=new RankEditForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("?action=RankList",1,_MD_A_USER_MESSAGE_SAVE_RANK_SUCCESS);
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("?action=RankList",1,_MD_A_USER_ERROR_RAISE_ERROR);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_admin_rankedit_input.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}
}

?>