<?php

require_once XOOPS_MODULE_PATH."/user/admin/actions/UserGroupPropertyAction.class.php";

/**
 *
 * This function keeps difficult problems that this depens on the column's block of X2 theme format.
 */
class UserGroupPermAction extends UserGroupPropertyAction
{
	/**
	 * This function don't use actionform, now.
	 * I (minahito) must remove code-clone.
	 */
	function execute(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();

		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}

		//
		// Reset group permission
		//
		$gpermHandler =& xoops_gethandler('groupperm');
		$gpermHandler->deleteBasicPermission($this->mGroup->getVar('groupid'));
		
		if (isset($_POST['system']) && is_array($_POST['system'])) {
			foreach ($_POST['system'] as $sid => $value)
			{
				$item =& new User_PermissionSystemAdminItem($sid, null);
				$perm =& new User_Permission($this->mGroup->getVar('groupid'), $item);
			
				$perm->save();

				unset($perm);
			}
		}
		
		$moduleHandler =& xoops_gethandler('module');
		$modPerms = array();

		if (isset($_POST['module']) && is_array($_POST['module'])) {
			foreach ($_POST['module'] as $mid => $value)
			{
				$module =& $moduleHandler->get($mid);
				if (is_object($module)) {
					$item =& new User_PermissionModuleItem($module);
					$modPerms[$mid] =& new User_Permission($this->mGroup->getVar('groupid'), $item);

					if (isset($_POST['module_admin']) && isset($_POST['module_admin'][$mid])) {
						$value |= $_POST['module_admin'][$mid];
					}

					$modPerms[$mid]->setValue($value);
					
					$modPerms[$mid]->save();
				}
			}
		}

		if (isset($_POST['module_admin']) && is_array($_POST['module_admin'])) {
			foreach ($_POST['module_admin'] as $mid => $value)
			{
				$module =& $moduleHandler->get($mid);
				if (is_object($module)) {
					if (!isset($modPerms[$mid])) {
						$item =& new User_PermissionModuleItem($module);
						$modPerms[$mid] =& new User_Permission($this->mGroup->getVar('groupid'), $item);
						$modPerms[$mid]->setValue($value);

						$modPerms[$mid]->save();
					}
				}
			}
		}

		$blockHandler =& xoops_gethandler('block');

		if (isset($_POST['block']) && is_array($_POST['block'])) {
			foreach ($_POST['block'] as $bid => $value)
			{
				$block =& $blockHandler->get($bid);
				if (is_object($block)) {
					$item =& new User_PermissionBlockItem($block);
					$perm =& new User_Permission($this->mGroup->getVar('groupid'), $item);
					$perm->setValue($value);
					$perm->save();
					
					unset($perm);
				}
			}
		}
		
		return USER_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewIndex(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("group_perm.html");
		$render->setAttribute("group",$this->mGroup);
		$render->setAttribute("modulePermissions",$this->mPermissions);
		$render->setAttribute("blockPermissions",$this->mBlockPermissions);
		$render->setAttribute("systemPermissions",$this->mSystemPermissions);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$render)
	{
		XCube_Utils::redirectHeader("index.php?action=GroupPerm&amp;groupid=" . $this->mGroup->getVar('groupid'), 1, "*SUCCESS*");
	}
}

?>