<?php

require_once XOOPS_MODULE_PATH."/user/forms/UserConfirmForm.class.php";
require_once XOOPS_MODULE_PATH."/user/class/RegistMailBuilder.class.php";

class UserRegister_confirmAction extends UserAction
{
	var $mActionForm=null;
	var $mRegistForm=null;
	var $mUserConfig=array();
	
	var $mNewUser=null;
	
	var $mRedirectMessage=null;

	function prepare(&$controller,&$xoopsUser)
	{
		$confingHandler=&xoops_gethandler('config');
		$this->mUserConfig=&$confingHandler->getConfigsByCat(XOOPS_CONF_USER);

		$controller->mRoot->mEventManager->add("Module.User.Regist.Success",new XCube_InstanceDelegate($this,"eventNotifyMail"));
	}

	function execute(&$controller,&$xoopsUser)
	{
		// confirmForm
		$this->_getRegistForm($controller);
		$this->_processActionForm($controller);
		
		$memberHandler=&xoops_gethandler('member');
		$this->mNewUser=&$memberHandler->createUser();
		$this->mRegistForm->update($newUser);
		$this->mNewUser->setVar('uorder',$controller->getConfig('com_order'),true);
		$$this->mNewUser->setVar('umode',$controller->getConfig('com_mode'),true);
		if($this->mUserConfig['activation_type'] == 1) {
			$this->mNewUsersetVar('level',1,true);
		}

		if(!$memberHandler->insertUser($this->mNewUser)) {
			$this->mRedirectMessage=_US_REGISTERNG;
			return USER_FRAME_VIEW_ERROR;
		}

        if(!$memberHandler->addUserToGroup(XOOPS_GROUP_USERS,$this->mNewUser->getVar('uid'))) {
			$this->mRedirectMessage=_US_REGISTERNG;
			return USER_FRAME_VIEW_ERROR;
		}

		$this->_clearRegistForm($controller);

		$this->_processMail($controller);

		$controller->mRoot->mEventManager->raiseEvent("Module.User.Regist.Success");

		// TODO the following process

		if($this->mUserConfig['activation_type']==1)
			XCube_Utils::redirectHeader(XOOPS_URL,4,_US_ACTLOGIN);
	}
	
	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_getRegistForm($controller);
		$this->_processActionForm($controller);

		return USER_FRAME_VIEW_INPUT;
	}
	
	/**
	 * Get regist actionform from Session and set it to the member property.
	 */
	function _getRegistForm(&$controller)
	{
		$this->mRegistForm=&$_SESSION['user_register_actionform'];
		if(!is_object($this->mRegistForm))
			$controller->executeForward("./register.php");
	}

	/**
	 * clear session
	 */
	function _clearRegistForm(&$controller)
	{
		unset($_SESSION['user_register_actionform']);
	}
	
	function _processMail(&$controller)
	{
		$activationType=$this->mUserConfig['activation_type'];
		
		if($activationType==1)
			return;

		// Wmm..
		$builder = ($activationType==0) ? new RegistUserActivateMailBuilder()
		                                    : new RegistUserAdminActivateMailBuilder();

		$director=new UserRegistMailDirector($this->mNewUser,$controller->getConfig(),$this->mUserConfig);
		$director->contruct($builder);
		$mailer=&$builder->getResult();
		
		$mailer->send();	// CHECKS
	}
	
	function eventNotifyMail()
	{
		if($this->mUserConfig['new_user_notify'] == 1 && !empty($this->mUserConfig['new_user_notify_group'])) {
			$director=new UserRegistMailDirector($this->mNewUser,$controller->getConfig(),$this->mUserConfig);
			$bilder = new RegistUserNotifyMailBuilder();
			$director->contruct($builder);
			$mailer=&$builder->getResult();
			$mailer->send();
		}
	}

	function _processActionForm(&$controller)
	{
		$this->mActionForm=new UserConfirmForm();
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader(XOOPS_URL,1,$this->mRedirectMessage);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_register_confirm.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
		$renderSystem->setAttribute("registForm",$this->mRegistForm);
	}
}

?>