<?php

require_once XOOPS_MODULE_PATH."/user/forms/RegisterUserEditForm.class.php";

class UserRegisterAction extends UserAction
{
	var $mActionForm=null;
	var $mConfig;
	var $mEnableAgreeFlag=false;

	function prepare(&$controller,&$xoopsUser)
	{
		$this->mConfig=$controller->mModuleController->getConfig();
		
		//
		// If user is registered, kick to his information page.
		//
		if(is_object($xoopsUser))
			$controller->executeForward(XOOPS_URL."/user.php");
	}

	function execute(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if($this->mActionForm->hasError()) {
			return USER_FRAME_VIEW_INPUT;
		}
		else {
			$_SESSION['user_register_actionform']=&$this->mActionForm;
			$controller->executeForward('./register_confirm.php');
		}
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();

		return USER_FRAME_VIEW_INPUT;
	}
	
	function _processActionForm()
	{
		if($this->mConfig['reg_dispdsclmr']!=0 && $this->mConfig['reg_disclaimer']!=null) {
			$this->mEnableAgreeFlag=true;
			$this->mActionForm=new RegisterUserAgreeEditForm();
		}
		else {
			$this->mActionForm=new RegisterUserEditForm();
		}
		
		$this->mActionForm->prepare($this->mConfig);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_register_form.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
		$renderSystem->setAttribute("enableAgree",$this->mEnableAgreeFlag);
		if($this->mEnableAgreeFlag)
			$renderSystem->setAttribute("disclaimer",$this->mConfig['reg_disclaimer']);
	}
}

?>