<?php

require_once XOOPS_MODULE_PATH."/pm/forms/DeletePmsgForm.class.php";

class PmReadAction extends PmAction
{
	var $mPrivMessage=null;
	var $mSendUser=null;

	var $mPreviousMessage=null;
	var $mNextMessage=null;
	
	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		//
		// Request Check without ActionForm
		//
		$msg_id=intval($_REQUEST['msg_id']);


		//
		// Load private message object
		//
		$pmHandler=&xoops_gethandler('privmessage');
		$this->mPrivMessage=&$pmHandler->get($msg_id);

		if(!is_object($this->mPrivMessage))
			return PM_FRAME_VIEW_ERROR;


		//
		// Check read permission and the sender.
		//
		if($this->mPrivMessage->getVar('to_userid')!=$xoopsUser->getVar('uid'))
			return PM_FRAME_VIEW_ERROR;

		$this->mSendUser=&$this->mPrivMessage->getFromUser();
		if(!is_object($this->mSendUser))
			return PM_FRAME_VIEW_ERROR;


		//
		// Get previous and next message
		//
		$criteria=new CriteriaCompo();
		$criteria->add(new Criteria('msg_id',$this->mPrivMessage->getVar('msg_id'),"<"));
		$criteria->setLimit(1);
		$criteria->setSort('msg_time');
		$criteria->setOrder('DESC');
		$tm=&$pmHandler->getObjects($criteria);
		if(count($tm)>0 && is_object($tm[0]))
			$this->mPreviousMessage=&$tm[0];
		unset($tm);
		unset($criteria);

		$criteria=new CriteriaCompo();
		$criteria->add(new Criteria('msg_id',$this->mPrivMessage->getVar('msg_id'),">"));
		$criteria->setLimit(1);
		$criteria->setSort('msg_time');
		$tm=&$pmHandler->getObjects($criteria);
		if(count($tm)>0 && is_object($tm[0]))
			$this->mNextMessage=&$tm[0];


		//
		// If this message is unread, Raise read flag.
		//
		if(!$this->mPrivMessage->isRead())
			$pmHandler->setRead($this->mPrivMessage);


		return PM_FRAME_VIEW_INDEX;
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("./index.php",1,_MD_PM_ERROR_ACCESS);
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("readpmsg.html");
		$renderSystem->setAttribute("thisUser",$xoopsUser);
		if($this->mSendUser->isActive()) {
			$renderSystem->setAttribute("sendUser",$this->mSendUser);
		}
		$renderSystem->setAttribute("privMessage",$this->mPrivMessage);
		$renderSystem->setAttribute("previousMessage",$this->mPreviousMessage);
		$renderSystem->setAttribute("nextMessage",$this->mNextMessage);
		$renderSystem->setAttribute("anonymous",$controller->getConfig('anonymous'));
	}
}

?>