<?php

require_once XOOPS_MODULE_PATH."/pm/forms/DeletePmsgForm.class.php";

class PmDeleteAction extends PmAction
{
	var $mActionForm=null;
	
	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		return PM_FRAME_VIEW_ERROR;
	}

	function execute(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();

		//
		// Fetch request and validate.
		//
		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		//
		// If error, go to re-input.
		//
		if($this->mActionForm->hasError())
			return PM_FRAME_VIEW_ERROR;

		//
		// Delete PM
		//
		$pmHandler=&xoops_gethandler('privmessage');
		foreach($this->mActionForm->getVar('msg_id') as $msg_id) {
			$pm=&$pmHandler->get($msg_id);
			if(is_object($pm)&&($pm->getVar('to_userid')==$xoopsUser->getVar('uid')))
				$pmHandler->delete($pm);
			unset($pm);
		}

		return PM_FRAME_VIEW_SUCCESS;
	}

	function _processActionForm()
	{
		//
		// Create action form object by reply mode? or not?
		//
		$this->mActionForm=new DeletePmsgForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("./index.php",1,_PM_DELETED);
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("./index.php",1,_MD_PM_ERROR_ACCESS);
	}
}

?>