<?php
/**
 * @version $Id: Legacy_RenderSystem.class.php,v 1.1.2.5 2005/12/30 08:27:31 minahito Exp $
 */

require_once XOOPS_ROOT_PATH."/modules/legacyRender/kernel/Legacy_RenderTarget.class.php";


/**
 * Compatible render system with XOOPS 2 Themes & Templates.
 *
 * This manages theme and main render-target directly. And, this realizes
 * variable-sharing-mechanism with using smarty.
 */
class Legacy_RenderSystem extends XCube_RenderSystem
{
	var $mController;
	var $mXoopsTpl;

	var $mBlockShowFlags;
	var $mBlockContents;
	
	/**
	 * Temporary
	 */
	var $mThemeRenderTarget;
	
	/**
	 * Temporary
	 */
	var $mMainRenderTarget;
	
	var $_mContentsData=null;

	function Legacy_RenderSystem(&$controller)
	{
		parent::XCube_RenderSystem($controller);
		$this->mBlockContents=array();
	}
	
	function setDialogRenderMode()
	{
		die("DEPRECATED");
	}
	
	function prepare()
	{
		require_once XOOPS_ROOT_PATH."/class/template.php";

		// XoopsTpl default setup
		$this->mXoopsTpl=new XoopsTpl();
		
		$this->mXoopsTpl->register_modifier("xcstring","legacy_render_system_xcstring");
		$this->mXoopsTpl->register_modifier("xctext","legacy_render_system_xctext");

		// compatible
		$GLOBALS['xoopsTpl']=&$this->mXoopsTpl;
		
		$this->mXoopsTpl->xoops_setCaching(2);

		$this->mXoopsTpl->assign(array('xoops_requesturi' => htmlspecialchars($GLOBALS['xoopsRequestUri'], ENT_QUOTES),	//@todo ?????????????
									// set JavaScript /Weird, but need extra <script> tags for 2.0.x themes
									'xoops_js' => '//--></script><script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script><script type="text/javascript"><!--'
								));

		// If debugger request debugging to me, send debug mode signal by any methods.
		if($this->mController->mDebugger->isDebugRenderSystem())
			$this->mXoopsTpl->xoops_setDebugging(true);
		
   		$this->mXoopsTpl->assign(array('xoops_theme' => $this->mController->mConfig['theme_set'],
							'xoops_imageurl' => XOOPS_THEME_URL.'/'.$this->mController->mConfig['theme_set'].'/',
							'xoops_themecss'=> xoops_getcss($this->mController->mConfig['theme_set']),
							'xoops_requesturi' => htmlspecialchars($GLOBALS['xoopsRequestUri'], ENT_QUOTES),	//@todo ?????????????
							'xoops_sitename' => htmlspecialchars($this->mController->mConfig['sitename'], ENT_QUOTES),
							'xoops_slogan' => htmlspecialchars($this->mController->mConfig['slogan'], ENT_QUOTES),
							// set JavaScript/Weird, but need extra <script> tags for 2.0.x themes
							'xoops_js' => '//--></script><script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script><script type="text/javascript"><!--'
						));

		//
		// If this site has the setting of banner.
		// TODO this process depends on XOOPS 2.0.x.
		//
		if($this->mController->mConfig['banners']==1)
			$this->mXoopsTpl->assign('xoops_banner',xoops_getbanner());
		else
			$this->mXoopsTpl->assign('xoops_banner','&nbsp;');

		// --------------------------------------
		// Meta tags
		// --------------------------------------
		$configHandler=&xoops_gethandler('config');
		$configs =& $configHandler->getConfigsByCat(0,XOOPS_CONF_METAFOOTER);
		foreach ($configs as $config) {
		    // prefix each tag with 'xoops_'
			if(is_object($config))
				$this->mXoopsTpl->assign('xoops_'.$config->getVar('conf_name'),	$config->getConfValueForOutput());
	    }

		// --------------------------------------
		// Add User
		// --------------------------------------
		$arr=null;
		if(is_object($this->mController->mXoopsUser)) {
			$arr = array(
				'xoops_isuser' => true,
				'xoops_userid' => $this->mController->mXoopsUser->getVar('uid'),
				'xoops_uname' => $this->mController->mXoopsUser->getVar('uname'),
				'xoops_isadmin' => $this->mController->mXoopsUser->isAdmin());
		}
		else {
			$arr = array(
				'xoops_isuser' => false,
				'xoops_isadmin' => false);
		}

		$this->mXoopsTpl->assign($arr);
	}

	function setAttribute($key,$value)
	{
		$this->mRenderTarget->setAttribute($key,$value);
	}
	
	function getAttribute($key)
	{
		$this->mRenderTarget->getAttribute($key);
	}

	function renderBlock(&$target)
	{
		/**
		$cacheTime = $blockProcedure->getCacheTime();
		if(!$cacheTime) {
			$this->mXoopsTpl->xoops_setCaching(0);
		}
		else {
            $this->mXoopsTpl->xoops_setCaching(2);
            $this->mXoopsTpl->xoops_setCacheTime($bcachetime);
		}
		*/

		//
		// Temporary
		//
		$this->mXoopsTpl->xoops_setCaching(0);

		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		$result=&$this->mXoopsTpl->fetchBlock($target->getTemplateName(),$target->getAttribute("mid"));
		$target->setResult($result);
		
		//
		// Reset
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->clear_assign($key);
		}
	}
	
	function _render(&$target)
	{
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		$result=$this->mXoopsTpl->fetch("db:".$target->getTemplateName());
		$target->setResult($result);

		foreach($keys as $key) {
			$this->mXoopsTpl->clear_assign($key);
		}
	}
	
	function renderWithTarget(&$target)
	{
		//
		// TEST
		//
		$target->callPreFilter();
		
		//
		// TEST render->Begin();
		//
		$GLOBALS['currentRenderTarget']=&$target;
		
		//
		// The following lines are temporary until we will finish changing the style!
		//
		switch($target->getType()) {
			case XCUBE_RENDER_TARGET_TYPE_BLOCK:
				$this->renderTheme($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_MAIN:
				$this->renderMain($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_THEME:
				$this->renderTheme($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_BUFFER:
			default:
				break;
		}

		//
		// TEST render->End();
		//
		unset($GLOBALS['currentRenderTarget']);
	}

	function renderMain(&$target)
	{
		$cachedTemplateId = isset($GLOBLAS['xoopsCachedTemplateId']) ? $GLOBLAS['xoopsCachedTemplateId'] : null;

		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		foreach($this->mRenderTarget->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		if ($target->getTemplateName()) {
		    if ($cachedTemplateId!==null) {
		        $contents=$this->mXoopsTpl->fetch('db:'.$target->getTemplateName(), $xoopsCachedTemplateId);
		    } else {
		        $contents=$this->mXoopsTpl->fetch('db:'.$target->getTemplateName());
		    }
		} else {
		    if ($cachedTemplateId!==null) {
		        $this->mXoopsTpl->assign('dummy_content', $target->getAttribute("stdout_buffer"));
		        $contents=$this->mXoopsTpl->fetch($GLOBALS['xoopsCachedTemplate'], $xoopsCachedTemplateId);
		    } else {
		        $contents=$target->getAttribute("stdout_buffer");
		    }
		}
		
		$target->setResult($contents);
	}

	function renderTheme(&$target)
	{
		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		//
		// [TODO]
		// We must implement with a render-target.
		//
		// $this->_processLegacyTemplate();

		//
		// Assign module informations.
		//
		if($this->mController->mModuleController->isModuleProcess()) {	// The process of module
			$xoopsModule=&$this->mController->mModuleController->mModuleObject;
			$this->mXoopsTpl->assign(array('xoops_pagetitle' => $xoopsModule->getVar('name'),
			                               'xoops_modulename' => $xoopsModule->getVar('name'),
			                               'xoops_dirname' => $xoopsModule->getVar('dirname')));
		}
		else {
			$this->mXoopsTpl->assign('xoops_pagetitle', htmlspecialchars($this->mController->mConfig['slogan'], ENT_QUOTES));
		}


		// assing
		/// @todo I must move these to somewhere.
		$assignNameMap = array(
				XOOPS_SIDEBLOCK_LEFT=>array('showflag'=>'xoops_showlblock','block'=>'xoops_lblocks'),
				XOOPS_CENTERBLOCK_LEFT=>array('showflag'=>'xoops_showcblock','block'=>'xoops_clblocks'),
				XOOPS_CENTERBLOCK_RIGHT=>array('showflag'=>'xoops_showcblock','block'=>'xoops_crblocks'),
				XOOPS_CENTERBLOCK_CENTER=>array('showflag'=>'xoops_showcblock','block'=>'xoops_ccblocks'),
				XOOPS_SIDEBLOCK_RIGHT=>array('showflag'=>'xoops_showrblock','block'=>'xoops_rblocks')
			);

		foreach($assignNameMap as $key=>$val) {
			$this->mXoopsTpl->assign($val['showflag'],(isset($this->mBlockShowFlags[$key])&&$this->mBlockShowFlags[$key]) ? 1 : 0);
			if(isset($this->mBlockContents[$key])) {
				foreach($this->mBlockContents[$key] as $result) {
					$this->mXoopsTpl->append($val['block'],$result);
				}
			}
		}
		
		//
		// Render result, and set it to the RenderBuffer of the $target.
		//
		$result=null;
		if($target->getAttribute("isFileTheme")) {
			$result=$this->mXoopsTpl->fetch($target->getTemplateName()."/theme.html");
		}
		else {
			$result=$this->mXoopsTpl->fetch("db:".$target->getTemplateName());
		}

		$target->setResult($result);
	}
	
	/**
	 * @deprecated
	 */
	function renderMessageBox(&$messageBox)
	{
		$ret="";
		$class = ($messageBox->getType()==XCUBE_MESSAGEBOX_RESULT) ? "resultMsg" : "errorMsg";
		$ret ="<div class='$class'>";
		if($messageBox->getTitle()!=null)
			$ret.=@sprintf("<h4>%s</h4>",htmlspecialchars($messageBox->getTitle()));
			
		if(is_array($messageBox->getMessage())) {
			foreach($messageBox->getMessage() as $msg) {
				$ret.=htmlspecialchars($msg)."<br/>";
			}
		}
		else {
			$ret.=htmlspecialchars($messageBox->getMessage());
		}
		
		$ret.="</div>";

		return $ret;
	}

	/**
	 * @deprecated
	 */
	function renderConfirmMessageBox(&$messageBox)
	{
		$ret=@sprintf("<div class='confirmMsg'><h4>%s</h4>",$messageBox->getTitle());
		$ret.=@sprintf("<form method='post' action='%s'>",$messageBox->getAction());

		foreach($messageBox->getAttributes() as $key=>$value) {
			if(is_array($value))
				foreach($value as $radioName=>$radioValue) {
				$ret.=@sprintf("<input type='radio' name='%s' value='%s' /> %s<br />",$key,htmlspecialchars($radioValue),htmlspecialchars($radioName));
			}
			else {
				$ret.=@sprintf("<input type='hidden' name='%s' value='%s' />",$key,htmlspecialchars($value));
			}
		}
		
		$submitText=$messageBox->getSubmitText();
		if($submitText==null)
			$submitText=_SUBMIT;

		$ret.=@sprintf("<input type='submit' name='confirm_submit' value='%s' /><input type='button' name='confirm_back' value='%s'  onclick='javascript:history.go(-1);' />",
		                htmlspecialchars($submitText),_CANCEL);

		$ret.="</form></div>";

		return $ret;
	}


	//
	// There must not be the following functions here!
	//
	//

	/**
	 * @deprecated
	 */
	function sendHeader()
	{
		header('Content-Type:text/html; charset='._CHARSET);
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0', false);
		header('Pragma: no-cache');
	}

	/**
	 * @deprecated
	 */
	function showXoopsHeader($closeHead=true)
	{
		global $xoopsConfig;
		$myts =& MyTextSanitizer::getInstance();
		if ($xoopsConfig['gzip_compression'] == 1) {
			ob_start("ob_gzhandler");
		} else {
			ob_start();
		}

		$this->sendHeader();
		$this->_renderHeader($closeHead);
	}
	
	// TODO never direct putput
	/**
	 * @deprecated
	 */
	function _renderHeader($closehead=true)
	{
		global $xoopsConfig, $xoopsTheme, $xoopsConfigMetaFooter;

		echo "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>";

		echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="'._LANGCODE.'" lang="'._LANGCODE.'">
		<head>
		<meta http-equiv="content-type" content="text/html; charset='._CHARSET.'" />
		<meta http-equiv="content-language" content="'._LANGCODE.'" />
		<meta name="robots" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_robots']).'" />
		<meta name="keywords" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_keywords']).'" />
		<meta name="description" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_desc']).'" />
		<meta name="rating" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_rating']).'" />
		<meta name="author" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_author']).'" />
		<meta name="copyright" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_copyright']).'" />
		<meta name="generator" content="XOOPS" />
		<title>'.htmlspecialchars($xoopsConfig['sitename']).'</title>
		<script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script>
		';
		$themecss = getcss($xoopsConfig['theme_set']);
		echo '<link rel="stylesheet" type="text/css" media="all" href="'.XOOPS_URL.'/xoops.css" />';
		if ($themecss) {
			echo '<link rel="stylesheet" type="text/css" media="all" href="'.$themecss.'" />';
			//echo '<style type="text/css" media="all"><!-- @import url('.$themecss.'); --></style>';
		}
		if ($closehead) {
			echo '</head><body>';
		}
	}
	
	/**
	 * @deprecated
	 */
	function _renderFooter()
	{
		echo '</body></html>';
	    ob_end_flush();
	}
	
	/**
	 * @deprecated
	 */
	function showXoopsFooter()
	{
		$this->_renderFooter();
	}
}

function legacy_render_system_xcstring($string,$modifierName=null)
{
	if(is_object($GLOBALS['currentRenderTarget'])) {
		$modifier=&$GLOBALS['currentRenderTarget']->searchModifier($modifierName);
		if(is_object($modifier))
			$modifier->convertString($string);
	}

	return $string;
}

function legacy_render_system_xctext($string,$modifierName=null)
{
	if(is_object($GLOBALS['currentRenderTarget'])) {
		$modifier=&$GLOBALS['currentRenderTarget']->searchModifier($modifierName);
		if(is_object($modifier))
			$modifier->convertText($string);
	}

	return $string;
}

?>