<?php

require_once XOOPS_ROOT_PATH."/modules/legacyRender/admin/class/LegacyTheme.class.php";

/**
 * This action shows the list of selectable themes to user.
 */
class LegacyRenderDefaultAction extends LegacyRenderAction
{
	var $mConfig;
	var $mThemes;
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$themeHandler =& new LegacyThemeHandler();
		$this->mThemes =& $themeHandler->enumAll();

		return LEGACY_RENDER_FRAME_VIEW_INDEX;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$configHandler =& xoops_gethandler('config');

		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('conf_name', 'theme_set'));
		$criteria->add(new Criteria('conf_catid', XOOPS_CONF));
		
		$configs =& $configHandler->getConfigs($criteria);

		if (count($configs)>0 && is_object($configs[0])) {
			$configs[0]->setVar('conf_value', $_POST['theme_name']);
			if ($configHandler->insertConfig($configs[0])) {
				$controller->mRoot->setThemeName($_POST['theme_name']);
			}
		}

		return $this->getDefaultView($controller, $xoopsUser);
	}
	
	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("theme_list.html");
		$render->setAttribute("themes", $this->mThemes);
		$render->setAttribute("currentThemeName", $controller->mRoot->getThemeName());
	}
}

?>