<?php

require_once XOOPS_BASE_PATH."/admin/class/AbstractModuleInstaller.class.php";

class Legacy_ModuleUninstaller extends Legacy_AbstractModuleInstaller
{
	/**
	 * Load xoops module object that isn't installed and return it.
	 * @static
	 * @access public
	 * @param $dirname string
	 * @return XoopsModule
	 */
	function &loadModuleObject($dirname)
	{
		$error = null;

		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->getByDirname($dirname);

		if (!is_object($module)) {
			$this->mLog->addError("*Module not found*");
			return $error;
		}
		
		if ($module->getVar('isactive') != 0) {
			$this->mLog->addError("*For uninstall, turn off the active-status of the module.*");
			return $error;
		}

		return $module;
	}
	
	/**
	 * Delete module information from XOOPS database because this class is uninstaller.
	 */
	function _installModule()
	{
		$moduleHandler =& xoops_gethandler('module');
		if (!$moduleHandler->delete($this->mModule)) {
			$this->mLog->addError("*Could not delete module information from XOOPS database.*");
		}
		else {
			$this->mLog->addReport("*Delete module information from XOOPS database.*");
		}
	}

	/**
	 * Drop table because this class is uninstaller.
	 */
	function _installTable()
	{
		$root =& XCube_Root::getSingleton();
		$db =& $root->mController->getDB();

		$tables = $this->mModule->getInfo('tables');
		if ($tables != false && is_array($tables)) {
			foreach($tables as $table) {

				// TODO Do we need to check reserved core tables?

				$sql = "DROP TABLE " . $db->prefix($table);
				if ($db->query($sql)) {
					$this->mLog->addReport("Drop table " . $db->prefix($table));
				}
				else {
					$this->mLog->addError("Could not drop table " . $db->prefix($table));
				}
			}
		}
	}

	/**
	 * Delete template because this class is uninstaller.
	 */
	function _installTemplate()
	{
		$tplHandler =& xoops_gethandler('tplfile');

		$deleteTemplates =& $tplHandler->find(null, 'module', $this->mModule->getVar('mid'));
		
		foreach($deleteTemplates as $template) {
			$tplHandler->delete($template);
		}
	}

	/**
	 * Delete all of module's blocks.
	 */
	function _installBlock()
	{
		$blockHandler =& xoops_gethandler('block');
		$criteria = new Criteria('mid', $this->mModule->getVar('mid'));

		$blocks =& $blockHandler->getObjects($criteria);

		$gpermHandler =& xoops_gethandler('groupperm');
		foreach ($blocks as $block) {
			$blockHandler->delete($block);
			$this->mLog->addReport("Uninstall block '".$block->getName('block'));

			//
			// delete permission
			//
			$criteria =& new CriteriaCompo();
			$criteria->add(new Criteria('gperm_name', 'block_read'));
			$criteria->add(new Criteria('gperm_itemid', $block->getVar('bid')));
			$criteria->add(new Criteria('gperm_modid', 1));
			$gpermHandler->deleteAll($criteria);
		}

		$tplHandler =& xoops_gethandler('tplfile');
		$criteria =& new Criteria('tpl_module', $this->mModule->getVar('dirname'));
		if(!$tplHandler->deleteAll($criteria)) {
			$this->mLog->addError("Could not delete block templates : " . $tplHandler->db->error());
		}
	}

	function _installPreference()
	{
		Legacy_ModuleUtils::deleteAllConfigs($this->mModule, $this->mLog);
	}

	function _processScript()
	{
		$installScript = trim($this->mModule->getInfo('onUninstall'));
		if ($installScript != false) {
			require_once XOOPS_MODULE_PATH . "/" . $this->mModule->getVar('dirname') . "/" . $installScript;
			$funcName = 'xoops_module_uninstall_' . $this->mModule->getVar('dirname');
			if (function_exists($funcName)) {
				if (!call_user_func($funcName, $this->mModule)) {
					$this->mLog->addError("Failed to execute " . $funcName);
				}
			}
		}
	}
}

?>