<?php
/**
 * @version $Id: LegacyModuleListAction.class.php,v 1.1.2.3 2005/12/28 13:52:16 minahito Exp $
 */

require_once XOOPS_BASE_PATH."/admin/forms/ModuleListFilterForm.class.php";
require_once XOOPS_BASE_PATH."/admin/forms/ModuleSettingsForm.class.php";

class LegacyModuleListAction extends LegacyAdminAction
{
	var $mDB=null;
	var $mModuleObjects=array();
	var $mFilter=null;
	var $mForm=null;

	function prepare(&$controller,&$xoopsUser)
	{
		$this->mDB=&$controller->getDB();
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->mFilter=new ModuleListFilterForm();
		$this->mFilter->fetch();
		
		$moduleHandler=&xoops_gethandler('module');

		// dmy
		$criteria=new Criteria('mid',0,'>');
		$criteria->setSort($this->mFilter->getSort());
		$criteria->setOrder($this->mFilter->getOrder());
		
		$this->mModuleObjects=&$moduleHandler->getObjects($criteria);

		return LEGACY_ADMIN_FRAME_VIEW_INDEX;
	}
	
	function execute(&$controller,&$xoopsUser)
	{
		$moduleHandler=&xoops_gethandler('module');
		$objests=$moduleHandler->getObjects();

		$this->mForm=new ModuleSettingsForm();
		$this->mForm->prepare();
		
		$this->mForm->fetch();
		$this->mForm->validate();

		if($this->mForm->hasError() || !isset($_POST['dummy_ticket'])) {
			return $this->_processConfirm($controller,$xoopsUser);
		}
		else {
			return $this->_processSave($controller,$xoopsUser);
		}

	}
	
	function _processConfirm(&$controller,&$xoopsUser)
	{
		$moduleHandler=&xoops_gethandler('module');
		$objests=$moduleHandler->getObjects();

		//
		// Do mapping.
		//
		foreach($objests as $modObject) {
			$this->mModuleObjects[$modObject->getVar('mid')]=&$modObject;
			unset($modObject);
		}

		return LEGACY_ADMIN_FRAME_VIEW_INPUT;
	}

	function _processSave(&$controller,&$xoopsUser)
	{
		$moduleHandler=&xoops_gethandler('module');
		$objects=$moduleHandler->getObjects();
		
		$successFlag=true;
		foreach($objects as $modObject) {
			$mid=$modObject->getVar('mid');
			$modObject->setVar('name',$this->mForm->getVar('name',$mid));
			$modObject->setVar('weight',$this->mForm->getVar('weight',$mid));
			$modObject->setVar('isactive',$this->mForm->getVar('isactive',$mid));

			//
			// Store.
			//
			$successFlag&=$moduleHandler->insert($modObject);
		}
		
		return $successFlag ? LEGACY_ADMIN_FRAME_VIEW_SUCCESS : LEGACY_ADMIN_FRAME_VIEW_ERROR;
	}

	/**
	 * To support a template writer, this send the list of mid that actionForm kept.
	 */
	function executeViewInput(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("modulelist_confirm.html");
		$renderer->setAttribute('moduleObjects',$this->mModuleObjects);
		$renderer->setAttribute('actionForm',$this->mForm);
		
		//
		// To support a template writer, this send the list of mid that
		// actionForm kept.
		//
		$tarray=&$this->mForm->getVar('name');
		$renderer->setAttribute('mids',array_keys($tarray));
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("module_list.html");

		//
		// Load adminmenu before we assign these to template.
		//
		foreach(array_keys($this->mModuleObjects) as $key) {
			$this->mModuleObjects[$key]->loadAdminMenu();
			$this->mModuleObjects[$key]->loadInfo($this->mModuleObjects[$key]->getVar('dirname'));
		}

		$renderer->setAttribute('moduleObjects',$this->mModuleObjects);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderer)
	{
		XCube_Utils::redirectHeader('./index.php?action=ModuleList',1,"*SUCCESS*");
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderer)
	{
		XCube_Utils::redirectHeader('./index.php?action=ModuleList',1,"*ERROR*");
	}
}

?>