<?php
/**
 * @version $Id: LegacyHelpAction.class.php,v 1.1.2.4 2005/12/30 08:22:57 minahito Exp $
 */

/**
 * This class extends Smarty to mediate the collision compiled file name.
 */
class Legacy_HelpSmarty extends Smarty
{
	var $mDirname = null;
	var $mModuleObject = null;
	var $mFilename = null;

	function Legacy_HelpSmarty()
	{
		parent::Smarty();

		$this->compile_id = null;
		$this->_canUpdateFromFile = true;
		$this->compile_check = true;
		$this->compile_dir = XOOPS_COMPILE_PATH;
		$this->left_delimiter = "<{";
		$this->right_delimiter = "}>";

		$this->register_modifier("helpurl", "Legacy_modifier_helpurl");
	}
	
	function setDirname($dirname)
	{
		$this->mDirname = $dirname;
	}

	function _get_auto_filename($autoBase, $autoSource = null, $auotId = null)
	{
		$autoSource = $this->mDirname . "_help_" . $autoSource;
		return parent::_get_auto_filename($autoBase, $autoSource, $auotId);
	}
}

function Legacy_modifier_helpurl($file)
{
	$root =& XCube_Root::getSingleton();
	$modController =& $root->mController->getModuleController();
	$moduleObject =& $modController->getXoopsModule();
	
	$language = $root->mController->getConfig('language');
	$dirname = $moduleObject->getVar('dirname');

	//
	// TODO We should check file_exists.
	//

	$url = XOOPS_MODULE_URL . "/base/admin/index.php?action=Help&amp;dirname=${dirname}&amp;file=${file}";

	return $url;
}

/**
 * This action will show the information of a module specified to user.
 */
class LegacyHelpAction extends LegacyAdminAction
{
	var $mModuleObject = null;
	var $mContents = null;

	var $mErrorMessage = null;
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		//
		// TODO We must change the following lines to ActionForm.
		//
		$dirname = $_GET['dirname'];
		if (!preg_match("/^[a-z\_]+$/i", $dirname)) {
			return LEGACY_ADMIN_FRAME_VIEW_ERROR;
		}

		if (!is_dir(XOOPS_MODULE_PATH . "/" . $dirname)) {
			return LEGACY_ADMIN_FRAME_VIEW_ERROR;
		}

		$moduleHandler =& xoops_gethandler('module');
		$this->mModuleObject =& $moduleHandler->getByDirname($dirname);
		
		$language =& $controller->getConfig('language');

		//
		// TODO We must change the following lines to ActionForm.
		//
		$helpfile = isset($_GET['file']) ? $_GET['file'] : $this->mModuleObject->getHelp();

		//
		// Smarty
		//
		$smarty =& new Legacy_HelpSmarty();
		$smarty->setDirname($dirname);

		//
		// file check
		//
		$template_dir = XOOPS_MODULE_PATH . "/" . $dirname . "/language/" . $language;
		if (!file_exists($template_dir . "/" . $helpfile)) {
			$template_dir = XOOPS_MODULE_PATH . "/" . $dirname . "/language/english";
			if (!file_exists($template_dir . "/" . $helpfile)) {
				$this->mErrorMessage = _MD_A_BASE_ERROR_NO_HELP_FILE;
				return LEGACY_ADMIN_FRAME_VIEW_ERROR;
			}
		}

		$smarty->template_dir = $template_dir;
		$this->mContents = $smarty->fetch("file:" . $helpfile);

		return LEGACY_ADMIN_FRAME_VIEW_SUCCESS;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("help.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('contents', $this->mContents);
	}

	function executeViewError(&$controller, &$xoopsUser, &$renderer)
	{
		XCube_Utils::redirectHeader('./index.php?action=ModuleList', 1, $this->mErrorMessage);
	}
}

?>