<?php

require_once XOOPS_BASE_PATH."/class/Legacy_ModuleAdapter.class.php";
require_once XOOPS_BASE_PATH."/admin/forms/ActionSearchForm.class.php";

class ActionSearchEventArgs
{
	var $mKeywords;
	var $mRecords;

	function ActionSearchEventArgs($words)
	{
		$this->setKeywords($words);
	}
	
	function setKeywords($words)
	{
		foreach(explode(" ",$words) as $word) {
			if(strlen($word)>0)
				$this->mKeywords[]=$word;
		}
	}

	function getKeywords()
	{
		return $this->mKeywords;
	}

	function addRecord($moduleName,$url,$title,$desc=null)
	{
		$this->mRecords[]=new ActionSearchRecord($moduleName,$url,$title,$desc);
	}
	
	function &getRecords()
	{
		return $this->mRecords;
	}
	
	/**
	 * @return bool
	 */
	function hasRecord()
	{
		return count($this->mRecords)>0;
	}
}

class ActionSearchRecord
{
	var $mModuleName;
	var $mActionUrl;
	var $mTitle;
	var $mDescription;

	function ActionSearchRecord($moduleName,$url,$title,$desc=null)
	{
		$this->mModuleName=$moduleName;
		$this->mActionUrl=$url;
		$this->mTitle=$title;
		$this->mDescription=$desc;
	}
}

class LegacyActSearchAction extends LegacyAdminAction
{
	var $mModules=array();
	var $mModuleRecords=null;
	var $mRecords=null;
	var $mActionForm;

	function prepare(&$controller,&$xoopsUser)
	{
		parent::prepare(&$controller,&$xoopsUser);

		$db=&$controller->getDB();
		//
		// TODO : We don't use handler and write sql directly.
		//
		$sql = "SELECT {mod}.* FROM {mod},{perm} ".
		        "WHERE {mod}.mid={perm}.gperm_itemid AND {perm}.gperm_name='module_admin' AND {perm}.gperm_groupid IN ({groups}) ".
		        "ORDER BY {mod}.weight";

		$replaceMap=array("mod"=>$db->prefix("modules"),
		                 "perm"=>$db->prefix("group_permission"),
		                 "groups"=>implode(",",$xoopsUser->getGroups()));

		$sql=XCube_Utils::formatMessageByMap($sql,$replaceMap);

		$result=$db->query($sql);
		while($row=$db->fetchArray($result)) {
			$xoopsModule = new XoopsModule();
			$xoopsModule->assignVars($row);

			$adapter=new Legacy_ModuleAdapter($xoopsModule);
			$adapter->prepareAdmin($controller);
			
			$this->mModules[]=&$adapter;

			unset($xoopsModule);
			unset($adapter);
		}
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();
		return LEGACY_ADMIN_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if($this->mActionForm->hasError())
			return LEGACY_ADMIN_FRAME_VIEW_INPUT;

		$eventArgs=new ActionSearchEventArgs($this->mActionForm->getVar('keywords'));
		$controller->mRoot->mEventManager->raiseEvent("Module.Admin.ActionSearch",$this,$eventArgs);

		if($eventArgs->hasRecord()) {
			$this->mRecords=&$eventArgs->getRecords();
			return LEGACY_ADMIN_FRAME_VIEW_SUCCESS;
		}
		else {
			return LEGACY_ADMIN_FRAME_VIEW_INPUT;
		}
	}
	
	function _processActionForm()
	{
		$this->mActionForm=new ActionSearchForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("legacy_admin_actionsearch_success.html");
		$renderSystem->setAttribute("records",$this->mRecords);
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("legacy_admin_actionsearch_input.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}
}

?>