<?php
/**
 * @version
 */

/**
 * This is abstract class for 3 action classes that are Install, Update and Uninstall.
 */
class Legacy_AbstractModuleInstallAction extends LegacyAdminAction
{
	/**
	 * XoopsModule instance specified.
	 */
	var $mModuleObject = null;
	var $mLog = null;
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$dirname = trim($_GET['dirname']);

		$installer =& $this->_getInstaller($dirname);

		$this->mModuleObject =& $installer->loadModuleObject($dirname);

		if (!is_object($this->mModuleObject)) {
			$this->mLogLog =& $installer->getLog();
			return LEGACY_ADMIN_FRAME_VIEW_ERROR;
		}

		$this->mModuleObject->loadAdminMenu();
		$this->mModuleObject->loadInfo($dirname);
		
		return LEGACY_ADMIN_FRAME_VIEW_INDEX;
	}

	function execute(&$controller, &$xoopsUser)
	{
		$dirname = trim($_POST['dirname']);
		$agree = false;
		if (isset($_POST['agree'])) {
			$agree = intval($_POST['agree']) > 0 ? true : false;
		}

		$force=false;
		if(isset($_POST['force']))
			$force=intval($_POST['force'])>0 ? true : false;

		$installer =& $this->_getInstaller($dirname);
		$this->mModuleObject =& $installer->loadModuleObject($dirname);
		
		if (!is_object($this->mModuleObject)) {
			return LEGACY_ADMIN_FRAME_VIEW_ERROR;
		}

		if ($installer->hasAgree() && !$agree) {
			$this->_loadAgreement();
			return LEGACY_ADMIN_FRAME_VIEW_INPUT;
		}
		
		$installer->setForceMode($force);
		$installer->execute($dirname);

		$this->mLog =& $installer->getLog();
		
		return LEGACY_ADMIN_FRAME_VIEW_SUCCESS;
	}

	/**
	 * Return a procedure for this process.
	 */
	function &_getInstaller($dirname)
	{
	}
	
	function _loadAgreement()
	{
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("module_installers_error.html");
		$renderer->setAttribute('log', $this->mLog);
	}
}

?>