<?php

define("XCUBE_PAGENAVI_START",1);
define("XCUBE_PAGENAVI_PERPAGE",2);

/**
 * This is a class in a semiautomatic that acquires page navigation information.  
 */
class XCube_PageNavigator
{
	var $mStart=0;
	var $mTotal=0;
	var $mPerpage = 20;
	var $mUrl=null;
	
	var $mPrefix = null;

	var $mExtra=array();
	
	var $mFlags=0;

	function XCube_PageNavigator($url, $total, $flags=0)
	{
		$this->mUrl = $url;
		$this->setTotal($total);
		$this->mFlags = $flags;
	}
	
	function fetch()
	{
		$startKey = $this->getStartKey();
		$perpageKey = $this->getPerpageKey();

		if ($this->mFlags & XCUBE_PAGENAVI_START && isset($_REQUEST[$startKey])) {
			$this->mStart = intval($_REQUEST[$startKey]);
		}

		if ($this->mFlags & XCUBE_PAGENAVI_PERPAGE && isset($_REQUEST[$perpageKey])) {
			$this->mPerpage = intval($_REQUEST[$perpageKey]);
		}
	}

	function addExtra($key,$value)
	{
		$this->mExtra[$key]=$value;
	}
	
	/**
	 * Return url string for navigation. The return value is lose start value.
	 * The user need to add start value. For example, It is "$navi->getRenderUrl().'20'".
	 * This method name is bad. I must rename this.
	 * @return string
	 */
	function getRenderUrl()
	{
		if(count($this->mExtra)) {
			$url=$this->mUrl;
			$tarr=array();
			foreach($this->mExtra as $key=>$value) {
				$tarr[]=$key."=".urlencode($value);
			}
			if(strpos($this->mUrl,"?")!==false) {
				return $this->mUrl."&amp;".implode("&amp;",$tarr)."&amp;" . $this->getStartKey() . "=";
			}
			else {
				return $this->mUrl."?".implode("&amp;",$tarr)."&amp;" . $this->getStartKey() . "=";
			}
		}
		else {
			if(strpos($this->mUrl,"?")!==false) {
				return $this->mUrl."&amp;" . $this->getStartKey() . "=";
			}
			else {
				return $this->mUrl."?" . $this->getStartKey() . "=";
			}
		}
	}
	
	/**
	 * Return url string for sort. The return value is complete style.
	 */
	function renderSortUrl()
	{
		return $this->getRenderUrl() . $this->mStart;
	}

	function setStart($start)
	{
		$this->mStart = intval($start);
	}
	
	function getStart()
	{
		return $this->mStart;
	}
	
	function setTotal($total)
	{
		$this->mTotal = intval($total);
	}
	
	function getTotal()
	{
		return $this->mTotal;
	}
	
	function setPerpage($perpage)
	{
		$this->mPerpage = intval($perpage);
	}
	
	function getPerpage()
	{
		return $this->mPerpage;
	}

	function setPrefix($prefix)
	{
		$this->mPrefix = $prefix;
	}
	
	function getPrefix()
	{
		return $this->mPrefix;
	}

	function getStartKey()
	{
		return $this->mPrefix . "start";
	}

	function getPerpageKey()
	{
		return $this->mPrefix . "perpage";
	}
}

?>