<?php

require_once XOOPS_ROOT_PATH."/class/token.php";

define("XCUBE_MESSAGEBOX_RESULT",1);
define("XCUBE_MESSAGEBOX_ERROR",2);
define("XCUBE_MESSAGEBOX_YESNO",3);

class XCube_MessageBox
{
	var $mTitle;
	var $mMessage;
	var $mType;

	function XCube_MessageBox($title=null,$message=null,$type=XCUBE_MESSAGEBOX_RESULT)
	{
		$this->mTitle=$title;
		$this->mMessage=$message;
		$this->mType=$type;
	}
	
	function getType()
	{
		return $this->mType;
	}
	
	function setTitle($title)
	{
		$this->mTitle=$title;
	}
	
	function setMessage($message)
	{
		$this->mMessage=$message;
	}
	
	function getTitle()
	{
		return $this->mTitle;
	}
	
	function getMessage()
	{
		return $this->mMessage;
	}
	
	function render()
	{
		//
		// This class does not render directly.
		// Get the render system of this site, request it to render.
		//
		$root=&XCube_Root::getSingleton();
		$renderSystem=$root->mController->getRenderSystem();
		if($renderSystem!=null) {
			return $renderSystem->renderMessageBox($this);
		}
		else {
			return null;
		}
	}

	function show()
	{
		print $this->render();
	}
}

class XCube_ConfirmBox extends XCube_MessageBox
{
	var $mAction;
	var $mSubmitText=null;
	var $mAttributes=array();

	function XCube_ConfirmBox($title=null,$message=null)
	{
		parent::XCube_MessageBox($title,$message,XCUBE_MESSAGEBOX_YESNO);
	}
	
	function setAction($action)
	{
		$this->mAction=$action;
	}
	
	function getAction()
	{
		return $this->mAction;
	}
	
	function setSubmitText($str)
	{
		$this->mSubmitText=$str;
	}
	
	function getSubmitText()
	{
		return $this->mSubmitText;
	}
	
	function setAttribute($key,$value)
	{
		$this->mAttributes[$key]=$value;
	}
	
	function setAttributes(&$attr)
	{
		$this->mAttributes=&$attr;
	}

	function getAttributes()
	{
		return $this->mAttributes;
	}

	function render()
	{
		$root=&XCube_Root::getSingleton();
		$renderSystem=$root->mController->getRenderSystem();
		if($renderSystem!=null) {
			return $renderSystem->renderConfirmMessageBox($this);
		}
		else {
			return null;
		}
	}
}

/**
 * ConfirmMessageBox with Onetime Token.
 */
class XCube_TokenConfirmBox extends XCube_ConfirmBox
{
	var $mToken=null;

	function XCube_TokenConfirmBox($title=null,$message=null,$tokenName=XOOPS_TOKEN_DEFAULT)
	{
		parent::XCube_ConfirmBox($title,$message,XCUBE_MESSAGEBOX_YESNO);

		//
		// Create token.
		//
		$tokenHandler=new XoopsMultiTokenHandler();
		$this->mToken=&$tokenHandler->create($tokenName);

		//
		// Register to session. And, set it to own property.
		//
		$tokenHandler->register($this->mToken);
		$this->setAttribute($this->mToken->getTokenName(),$this->mToken->getTokenValue());
	}
}

?>