<?php
//======================
// xreview  饤֥
//======================


//-----------------------
// ǡå
//-----------------------

function checkComment($review_comment)
{
	$res = true;
	if( strlen($review_comment) > 65535) {
		$res = false;
	}
	return $res;
}

function checkTitle($review_title)
{
	$res = true;
	if( strlen($review_title) > 65535) {
		$res = false;
	}
	return $res;
}

function checkPoint($review_point)
{
	$res = false;
	if( ($review_point == "") || ($review_point >= 1 && $review_point <= 10) ) {
		$res = true;
	}
	return $res;
}

function checkURI($review_uri)
{
	$res = true;
	if( strlen($review_uri) > 65535) {
		$res = false;
	}
	return $res;
}


function checkExplanation($review_explanation)
{
	$res = true;
	if( strlen($review_explanation) > 65535) {
		$res = false;
	}
	return $res;
}

//-----------------------
// 桼
//-----------------------
class XreviewerOperator
{
	var $uname = " ";
	var $user_avatar = " ";

	function XreviewerOperator($userid) {
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();
		// ɾԤξ
		$user_sql  = "select uname,user_avatar from ".$xoopsDB->prefix( 'users' );
		$user_sql .= " where uid = " . intval($userid);
		$user_res = $xoopsDB->query($user_sql);
		$user_row = $xoopsDB->fetchArray($user_res);
		//assign
		$this->user_avatar = $user_row['user_avatar'];
		$this->uname = $user_row['uname'];
	}

};

//-----------------------
// ӥ塼å
//-----------------------
class XreviewReviewset
{
	var $id;

	function XreviewReviewset($id = "")
	{
		$this->id = $id;
	}

	function add($xreview_name, $target_uri_ids, $xreview_note)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql	= "insert into ".$xoopsDB->prefix('xreview_manage');
		$sql .= " values ('',".$xoopsDB->quoteString($xreview_name).",".$xoopsDB->quoteString($target_uri_ids).",".$xoopsDB->quoteString($xreview_note).")";

		$res = $xoopsDB->query($sql);

		return $res;
	}

	function update($xreview_name, $target_uri_ids, $xreview_note)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql	= "update ".$xoopsDB->prefix('xreview_manage');
		$sql .= " set ";
		$sql .= " xreview_name = ".$xoopsDB->quoteString($xreview_name).",";
		$sql .= " target_uri_ids = ".$xoopsDB->quoteString($target_uri_ids).",";
		$sql .= " xreview_note = ".$xoopsDB->quoteString($xreview_note);
		$sql .= " where ";
		$sql .= " id = ".intval($this->id);

		$res = $xoopsDB->query($sql);

		return $res;
	}

	function delete() {
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql	= "delete from ".$xoopsDB->prefix('xreview_manage');
		$sql .= " where id = ".intval($this->id);

		$res = $xoopsDB->query($sql);

		return $res;
	}
}

//-----------------------
// 
//-----------------------
class XreviewAuth
{

	function update($group_id_buff)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		//
		$sql	= "delete from ".$xoopsDB->prefix('xreview_auth');
		$res = $xoopsDB->query($sql);

		//Ͽ
		$reggrp_num = count($group_id_buff);
		if ($reggrp_num > 0 )
		{
			for($i=0; $i<$reggrp_num; $i++ )
			{
				$sql	= "insert into ".$xoopsDB->prefix('xreview_auth');
				$sql .= " values ('','regist',".intval($group_id_buff[$i]).")";
				$res = $xoopsDB->query($sql);
			}
		}
		return $res;
	}

}

//-----------------------
// URI
//-----------------------
class XreviewURI
{

	var $id = -1;

	function XreviewURI($id = "")
	{
		$this->id = $id;
	}

	function add($uri,$nameOfUri)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$insert_sql = "insert into ".$xoopsDB->prefix('xreview_uri');
		$insert_sql.= " (id,request_uri,review_name)";
		$insert_sql.= " values ('',".$xoopsDB->quoteString($uri).",".$xoopsDB->quoteString($nameOfUri).")";

		$res = $xoopsDB->query($insert_sql);

		return $res;
	}

	function update($review_name,$uri_link_flag,$uri_explanation)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		if($uri_link_flag == "on") {
			$uri_link_flag_value = 1;
		} else {
			$uri_link_flag_value = 0;
		}

		$sql	= "update ".$xoopsDB->prefix('xreview_uri');
		$sql .= " set ";
		$sql .= " review_name = ".$xoopsDB->quoteString($review_name).",";
		$sql .= " link_flag = ".$xoopsDB->quoteString($uri_link_flag_value).",";
		$sql .= " uri_explanation = ".$xoopsDB->quoteString($uri_explanation)." ";
		$sql .= " where id = ".intval($this->id);

		$res = $xoopsDB->query($sql);

		return $res;
	}

	function delete() {
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql  = "select request_uri from ".$xoopsDB->prefix('xreview_uri');
		$sql .= " where id = ".intval($this->id);
		$res = $xoopsDB->query($sql);
		if($row = $xoopsDB->fetchArray($res))
		{
			$uri = $row['request_uri'];
		}

		$sql	= "delete from ".$xoopsDB->prefix('xreview_uri');
		$sql .= " where id = ".intval($this->id);
		$res = $xoopsDB->query($sql);

		if($res) {
			$sql	= "delete from ".$xoopsDB->prefix('xreview_data');
			$sql .= " where request_uri = ".$xoopsDB->quoteString($uri);
			$res = $xoopsDB->query($sql);
			if($res) {
				$sql = "select id, target_uri_ids from ".$xoopsDB->prefix('xreview_manage');
				$res = $xoopsDB->query($sql);
				if($row = $xoopsDB->fetchArray($res))
				{
					$xreview_manage_id = $row['id'];
					$target_uri_ids = $row['target_uri_ids'];
					$target_uri_ids_buff = split(",",$target_uri_ids);
					$isHit = array_search($this->id,$target_uri_ids_buff);
					if( $isHit != NULL ) {
						array_splice($target_uri_ids_buff,$isHit,1);
						$update_sql  = "update ".$xoopsDB->prefix('xreview_manage');
						$update_sql .= " set ";
						$update_sql .= " target_uri_ids = ". $xoopsDB->quoteString(join($target_uri_ids_buff));
						$update_sql .= " where id = ".intval($xreview_manage_id);
						$res = $xoopsDB->query($update_sql);
					}
				}
			}
		}

		return $res;
	}

	function link_flag_update($uri_id_buffer)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		// LinkFlagꥢ
		$sql	= "update ".$xoopsDB->prefix('xreview_uri');
		$sql .= " set ";
		$sql .= " link_flag = 0 ";

		$res = $xoopsDB->query($sql);

		foreach($uri_id_buffer as $key => $value)
		{
			if (preg_match('/link_flag_*/', $key))
			{
				$id = intval(preg_replace("/link_flag_/","",$key));
				$sql	= "update ".$xoopsDB->prefix('xreview_uri');
				$sql .= " set ";
				$sql .= " link_flag = 1 ";
				$sql .= " where id = ".intval($id);
				$res = $xoopsDB->query($sql);
			}
		}

		return $res;
	}
}

//-----------------------
// ӥ塼
//-----------------------
class XreviewReview
{
	var $id;

	function XreviewReview($id = "")
	{
		$this->id = $id;
	}

	function add($uri,$userid,$comment,$point)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$insert_sql = "insert into ".$xoopsDB->prefix('xreview_data');
		$insert_sql.= " values('',".$xoopsDB->quoteString($uri).",".intval($userid).",".$xoopsDB->quoteString($comment).",".intval($point).")";

		$res = $xoopsDB->query($insert_sql);

		return $res;
	}

	function update($comment,$point)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql	= "update ".$xoopsDB->prefix('xreview_data');
		$sql .= " set ";
		$sql .= " comment = ".$xoopsDB->quoteString($comment).", ";
		$sql .= " point = ".intval($point)." ";
		$sql .= " where id = ".intval($this->id);

		$res = $xoopsDB->query($sql);

		return $res;
	}

	function delete() {
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql	= "delete from ".$xoopsDB->prefix('xreview_data');
		$sql .= " where id = ".intval($this->id);

		$res = $xoopsDB->query($sql);

		return $res;
	}
}

class XreviewReviewByUriUserid extends XreviewReview
{
	function XreviewReviewByUriUserid($uri, $userid)
	{
		$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

		$sql  = "select id from ".$xoopsDB->prefix('xreview_data');
		$sql .= " where ";
		$sql .= " request_uri = ".$xoopsDB->quoteString($uri)." ";
		$sql .= " and ";
		$sql .= " user_id = ".intval($userid);
		$res = $xoopsDB->query($sql);
		if($row = $xoopsDB->fetchArray($res))
		{
			$id = $row['id'];
			$this->id = $id;
		}
	}
}

?>
