<?php
if (!defined('XOOPS_ROOT_PATH')) exit();

$mydirname = basename(__FILE__,'.php');

$Pluginname = ucfirst($mydirname);
if (!preg_match("/^\w+$/", $Pluginname))
{
	trigger_error('Invalid pluginName');
	exit();
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
eval('
class Xmobile'.$Pluginname.'Plugin extends XmobileD3pipesPluginAbstract
{
	function Xmobile'.$Pluginname.'Plugin()
	{
		$this->__construct("'.$mydirname.'");
	}
}

class Xmobile'.$Pluginname.'PluginHandler extends XmobileD3pipesPluginHandlerAbstract
{
	function Xmobile'.$Pluginname.'PluginHandler($db)
	{
		$this->__construct("'.$mydirname.'",$db);
	}
}
');

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XmobileD3pipesPluginAbstract extends XmobilePlugin
{
	function __construct($mydirname)
	{
		// call parent constructor
		XmobilePlugin::XmobilePlugin();
		// define object elements
		$this->initVar('clipping_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('pipe_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('fingerprint', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('pubtime', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('link', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('headline', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('can_search', XOBJ_DTYPE_INT, '1', true);
		$this->initVar('highlight', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('weight', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('comments_count', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('fetched_time', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('data', XOBJ_DTYPE_TXTAREA, '', true);

		// define primary key
		$this->setKeyFields(array('clipping_id'));
		$this->setAutoIncrementField('clipping_id');
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function assignSanitizerElement()
	{
		$dohtml = 1;
		$dosmiley = 1;
		$doxcode = 1;

		$this->initVar('dohtml',XOBJ_DTYPE_INT,$dohtml);
		$this->initVar('dosmiley',XOBJ_DTYPE_INT,$dosmiley);
		$this->initVar('doxcode',XOBJ_DTYPE_INT,$doxcode);
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XmobileD3pipesPluginHandlerAbstract extends XmobilePluginHandler
{
	var $moduleDir = '';
	var $categoryTableName = '';
	var $itemTableName = '';
	var $template = 'xmobile_d3pipes.html';
// category parameters
	var $category_id_fld = 'pipe_id';
//	var $category_pid_fld = 'cat_id';
	var $category_title_fld = 'name';
	var $category_order_fld = 'weight';
// item parameters
	var $item_id_fld = 'clipping_id';
	var $item_cid_fld = 'pipe_id';
	var $item_title_fld = 'headline';
	var $item_description_fld = 'data';
	var $item_order_fld = 'pubtime';
	var $item_date_fld = 'pubtime';
	var $item_order_sort = 'DESC';

	var $item_list;
	var $total;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct($mydirname,$db)
	{
		XmobilePluginHandler::XmobilePluginHandler($db);

		$this->moduleDir = $mydirname;
		$this->categoryTableName = $mydirname.'_pipes';
		$this->itemTableName = $mydirname.'_clippings';
		
		//htmlspecialchars getUrlLink fix
		if(isset($_GET['amp;clipping_id'])){ $this->item_id = intval($_GET['amp;clipping_id']);}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function prepare(&$controller)
	{
		parent::prepare($controller);
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setCategoryId()
	{
		if (is_null($this->category_id_fld)) return;

		$cid = intval($this->utils->getGetPost($this->category_id_fld));

		if ($cid == 0) return;

		$item_cid = 0;
		if (!is_null($this->item_cid_fld))
		{
			$item_cid = intval($this->utils->getGetPost($this->item_cid_fld, 0));
		}

		if ($cid == 0 && $item_cid != 0)
		{
			$this->category_id = $item_cid;
		}
		else
		{
			$this->category_id = $cid;
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'category_id', $this->category_id);
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setItemCriteria()
	{
		$this->item_criteria =& new CriteriaCompo();
		$cat_ids = array();
		$record = $this->getD3pipes();
		foreach($record as $row)
		{
			$cat_ids[] = $row[$this->category_id_fld];
		}
		$this->item_criteria->add(new Criteria($this->category_id_fld,'('.implode(',', $cat_ids).')','IN'));
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setCategoryCriteria()
	{
		$this->category_criteria =& new CriteriaCompo();
		$this->category_criteria->add(new Criteria('main_disp',0,'<>'));
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setCategoryPageNavi()
	{
		global $xoopsModuleConfig;
		//$total = $this->categoryTree->getFirstChild($this->category_id);
		$total = count($this->categoryTree->getAllTreeArray($this->category_criteria));
 
		$this->categoryPageNavi =& new XmobilePageNavigator($total, $xoopsModuleConfig['max_title_row'], 'cat_start', $this->getCategoryExtraArg());
		$this->category_criteria->setLimit($this->categoryPageNavi->getPerpage());
		$this->category_criteria->setStart($this->categoryPageNavi->getStart());
		$this->categoryTree->setCriteria($this->category_criteria);
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// get d3pipe categories
	function getD3pipes()
	{
		$arr = array();
		$count = 0;
		$sql = 'SELECT * FROM '.$this->categoryTableName.' WHERE main_disp<>0 ORDER BY '.$this->category_order_fld;
		$result = $this->db->query($sql,$this->limit,$this->page_start);
		$count = $this->db->getRowsNum($result);
		if ($count == 0)
		{
			return false;
		}
		while($row = $this->db->fetchArray($result))
		{
			$arr [] = $row;
		}
		return $arr ;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ƥμ
// ͤϥ֥ȤǤϤʤ
	function getCatList()
	{
		$this->setNextViewState('list');
		$this->setBaseUrl();
		$this->setCategoryParameter();
		
		if (!is_null($this->category_pid_fld) || is_null($this->category_id))
		{
			//$categoryArray = $this->categoryTree->getFirstChild($this->category_id);
			//original method
			$categoryArray = $this->getD3pipes();
		}
		else
		{
			$categoryArray = false;
		}

		// ƥΥѥ󤯤ɽ
		$this->controller->render->template->assign('cat_path',$this->getCatPathFromId($this->category_id));

		if (!is_array($categoryArray))
		{
			return false;
		}

		$subcategory_count = count($categoryArray);

		if ($subcategory_count == 0) // ɽǡ̵
		{
			return false;
		}

		if (!is_null($this->category_id))
		{
			$item_count = $this->getItemCountById();
		}
		else
		{
			$item_count = 0;
		}

		if ($item_count > 0)
		{
			$use_accesskey = false;
		}
		else
		{
			$use_accesskey = true;
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getCatList subcategory_count', $subcategory_count);
		$this->utils->setDebugMessage(__CLASS__, 'getCatList item_count', $item_count);

		$cat_list = array();
		$i = 0;
		foreach($categoryArray as $category)
		{

			$id = $category[$this->category_id_fld];
			$title = $category[$this->category_title_fld];
			$url_parameter = $this->getBaseUrl();

			if (!is_null($this->category_pid_fld))
			{
				$pid = $category[$this->category_pid_fld];
				$url_parameter .= '&amp;'.$this->category_pid_fld.'='.$pid;
			}
			if (!is_null($this->category_id_fld))
			{
				$url_parameter .= '&amp;'.$this->category_id_fld.'='.$id;
			}
//			$htmlBody .= $this->getListTitleLink($number,$id,$title,$url_parameter,$use_accesskey).'<br />';
			$number = $i + 1; // Ѥֹ桢1鳫
			$cat_list[$i]['key'] = $number;
			$cat_list[$i]['title'] = $this->adjustTitle($title);
			$cat_list[$i]['url'] = $url_parameter;
			$cat_list[$i]['item_count'] = sprintf(_MD_XMOBILE_NUMBER, $this->getChildItemCountById($id));
			$i++;
		}
		return $cat_list;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	function getDefaultView()
	{
		parent::getListView();
	}
*/
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	function setBaseUrl()
	{
		$this->baseUrl = $this->utils->getLinkUrl('plugin',$this->nextViewState,$this->moduleDir,$this->sessionHandler->getSessionID());
		// debug
		$this->utils->setDebugMessage(__CLASS__, 'setBaseUrl', $this->baseUrl);
	}
*/
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ǡΥڡʥӥν
// ƥǡcriteria˥ߥåȡȤ
	function setItemListPageNavi()
	{
		global $xoopsModuleConfig;
		$this->total = $this->getD3pipeEntriesCount($this->category_id);
		$this->itemListPageNavi =& new XmobilePageNavigator($this->total, $xoopsModuleConfig['max_title_row'], 'start', $this->getItemExtraArg());
		$this->item_criteria->setLimit($this->itemListPageNavi->getPerpage());
		$this->item_criteria->setStart($this->itemListPageNavi->getStart());
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ǡܺ٤Υڡʥӥν
// ƥǡcriteria˥ߥåȡȤ
/*
	function setItemDetailPageNavi()
	{
		$this->total = $this->getD3pipeEntriesCount($this->category_id);

		$this->itemDetailPageNavi =& new XmobilePageNavigator($this->total, 1, 'start', $this->getItemExtraArg());
		$this->item_criteria->setLimit($this->itemDetailPageNavi->getPerpage());
		$this->item_criteria->setStart($this->itemDetailPageNavi->getStart());

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'setItemDetailPageNavi Limit', $this->itemDetailPageNavi->getPerpage());
		$this->utils->setDebugMessage(__CLASS__, 'setItemDetailPageNavi Start', $this->itemDetailPageNavi->getStart());
	}
*/
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ƥɽ륢ƥμ
	function getChildItemCountById($id)
	{
		$id = intval($id);
		$itemCount = $this->getD3pipeEntriesCount($id);

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getChildItemCountById itemCount', $itemCount);
		return $itemCount;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// μ
// ͤϥ֥ȤǤϤʤ
	function getItemList()
	{
		$this->setNextViewState('detail');
		$this->setBaseUrl();
		$this->setItemParameter();
		$this->setItemListPageNavi();

		$entry = $this->getD3pipeEntries($this->category_id);

		if (count($entry) == 0) // ɽǡ̵
		{
			$this->controller->render->template->assign('lang_no_item_list',_MD_XMOBILE_NO_DATA);
			return false;
		}

		for($i=$this->itemListPageNavi->getStart(); $i<$this->total; $i++)
		{
			if ($i == $this->itemListPageNavi->getPerpage())
			{
				break;
			}

			$title = htmlspecialchars($entry[$i]['headline'], ENT_QUOTES);
			// ܺ٥ѥѥ᡼
			$url_parameter = $this->getBaseUrl().'&amp;'.$this->category_id_fld.'='.$this->category_id.'&amp;start='.$i;
			$date = strftime('%Y-%m-%d', intval($entry[$i]['pubtime']));

			$number = $i + 1; // Ѥֹ桢1鳫
			$this->item_list[$i]['key'] = $number;
			$this->item_list[$i]['title'] = $this->adjustTitle($title);
			$this->item_list[$i]['url'] = $url_parameter;
			$this->item_list[$i]['date'] = $date;
			// ɽ
			$description = '';
//			if ($entry[$i]['content_encoded'])
//			{
//				$description = $entry[$i]['content_encoded'];
//			}
			if (isset($entry[$i]['allow_html']))
			{
				if ($entry[$i]['allow_html'])
				{
					$description = $entry[$i]['description'];
				}
			}
			else
			{
				$description = htmlspecialchars(trim(nl2br($entry[$i]['description'])), ENT_QUOTES);
			}
			if ($description != '')
			{
				$this->item_list[$i]['content'] = $description;
//				$this->item_list[$i]['content'] = mb_strimwidth($description, 0, 100, '..', SCRIPT_CODE);
			}
			// ȸURI
//			$this->item_list[$i]['link'] = htmlspecialchars($entry[$i]['link'], ENT_QUOTES);
//			$i++;
		}

		return $this->item_list;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// added for makinavi.jp
// ǿμ
// ͤϥ֥ȤǤϤʤ
	function getRecentList()
	{
		global $xoopsModuleConfig;

		if($xoopsModuleConfig['show_recent_title'] == 0)
		{
			return false;
		}

		$this->setNextViewState('detail');
		$this->setBaseUrl();
		$this->setItemParameter();
		if(!is_null($this->item_date_fld))
		{
			$this->item_criteria->setSort($this->item_date_fld);
			$this->item_criteria->setOrder('DESC');
			$this->item_criteria->setLimit($xoopsModuleConfig['recent_title_row']);
		}

//exit(var_dump($this->item_criteria->render()));


		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getRecentList criteria', $this->item_criteria->render());

		if(!$itemObjectArray = $this->getObjects($this->item_criteria))
		{
			$this->utils->setDebugMessage(__CLASS__, 'getRecentlist Error', $this->getErrors());
		}

		if(count($itemObjectArray) == 0) // ɽǡ̵
		{
			$this->controller->render->template->assign('lang_no_item_list',_MD_XMOBILE_NO_DATA);
			return false;
		}

		$recent_list = array();
		$i = 0;
		foreach($itemObjectArray as $itemObject)
		{
			$id = $itemObject->getVar($this->item_id_fld);
			$title = $itemObject->getVar($this->item_title_fld);
			$url_parameter = $this->getBaseUrl();

			if(!is_null($this->category_pid_fld) && !is_null($this->category_pid))
			{
				$url_parameter .= '&amp;'.$this->category_pid_fld.'='.$this->category_pid;
			}
			if(!is_null($this->category_id_fld) && ($this->item_cid_fld != $this->category_id_fld) && !is_null($this->category_id))
			{
				$url_parameter .= '&amp;'.$this->category_id_fld.'='.$this->category_id;
			}
			if(!is_null($this->item_cid_fld))
			{
				$cid = $itemObject->getVar($this->item_cid_fld);
				$url_parameter .= '&amp;'.$this->item_cid_fld.'='.$cid;
			}
			if(!is_null($this->item_id_fld))
			{
				$url_parameter .= '&amp;'.$this->item_id_fld.'='.$id;
			}
			$date = '';
			if(!is_null($this->item_date_fld))
			{
				$date = strftime('%Y-%m-%d %H:%M',$itemObject->getVar($this->item_date_fld));
			}

			$recent_list[$i]['title'] = $this->adjustTitle($title);
			$recent_list[$i]['url'] = $url_parameter;
			$recent_list[$i]['date'] = $date;
			$i++;
		}
		return $recent_list;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ܺ١ȡԽѥ󥯤μ
// ͤϥ֥ȤǤϤʤHTML
	function getItemDetail()
	{
		
		if ($this->item_id)
		{
			$itemDetail = $this->getD3pipeClipping($this->item_id);
			$this->setItemDetailPageNavi();
//			$page = $this->getItemPageFromID($this->item_id);
//			$_GET['start'] = $page;
		}
		else
		{
			$entry = $this->getD3pipeEntries($this->category_id);
			$start = intval($this->utils->getGetPost('start'));
			$itemDetail = $entry[$start];
		}

		if ($itemDetail == '') // ɽǡ̵
		{
			$this->controller->render->template->assign('lang_no_item_list',_MD_XMOBILE_NO_DATA);
			return false;
		}

		$detail4html = '';

		// ȥ
		if ($itemDetail['headline'] != '')
		{
			$detail4html .= _MD_XMOBILE_TITLE;
			$detail4html .= htmlspecialchars($itemDetail['headline'], ENT_QUOTES).'<br />';
		}
		// ա
		$date = strftime('%Y-%m-%d', intval($itemDetail['pubtime']));
		$detail4html .= _MD_XMOBILE_DATE.$date.'<br />';
		// ɽ
//		if ($itemDetail['content_encoded'])
//		{
//			$description = $itemDetail['content_encoded'];
//		}
		$description = '';
		if (isset($itemDetail['allow_html']))
		{
			if ($itemDetail['allow_html'])
			{
				$description = $itemDetail['description'];
			}
		}
		else
		{
			$description = htmlspecialchars(trim(nl2br($itemDetail['description'])), ENT_QUOTES);
		}
		if ($description != '')
		{
			$detail4html .= _MD_XMOBILE_CONTENTS.'<br />';
			$detail4html .= $description.'<br />';
		}
		// ȸURI
//		if ($itemDetail['link'] != '')
//		{
//			$detail4html .= htmlspecialchars($itemDetail['link'], ENT_QUOTES).'<br />';
//		}

		return $detail4html;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// get d3pipe clippings
	function getD3pipeClippingsFromPipeID($pipe_id)
	{
		if (!$pipe_id) return false;

		$configHandler =& xoops_gethandler('module');
		$moduleConfig =& $configHandler->getByDirname($Pluginname);
		include_once XOOPS_TRUST_PATH.'/modules/d3pipes/include/main_functions.php';
		$pos = 0;
		$clippings= d3pipes_main_get_clippings_moduledb($this->moduleDir, $pipe_id, $moduleConfig['entries_per_eachpipe'], $pos);
		return $clippings;
	}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getD3pipeEntriesCount($pipe_id)
	{
		$count = 0;
		if ($pipe_id == 0)
		{
			$this->getObjects();
			$count = $this->getCount();
		}
		else
		{
			$entries = $this->getD3pipeEntries($pipe_id);
			$count = count($entries);
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getD3pipeEntriesCount', $count);

		return $count;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getD3pipeEntries($pipe_id)
	{
		if (!$pipe_id) return false;

		$configHandler =& xoops_gethandler('module');
		$moduleConfig =& $configHandler->getByDirname($mydirname);
		include_once XOOPS_TRUST_PATH.'/modules/d3pipes/include/common_functions.php';

		$pipe4assign = d3pipes_common_get_pipe4assign($this->moduleDir, $pipe_id);
		$entries = d3pipes_common_fetch_entries($this->moduleDir ,$pipe4assign ,$moduleConfig['entries_per_eachpipe'] ,$errors ,$moduleConfig);

		return $entries;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// get d3pipe clipping
	function getD3pipeClipping($clipping_id)
	{
		if (!$clipping_id) return false;
		include_once XOOPS_TRUST_PATH.'/modules/d3pipes/include/common_functions.php';
		$clip= d3pipes_common_get_clipping($this->moduleDir, $clipping_id);
		return $clip;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
