<?php

/**
 * $Id: configuration.php,v 1.2 2005/03/04 06:49:16 kizumo Exp $
 * Module: analog
 * Author: kizumo
 * Licence: GNU
 */


include_once(sprintf('%s/class/xoopsobject.php', XOOPS_ROOT_PATH));
include_once(sprintf('%s/class/xoopstree.php', XOOPS_ROOT_PATH));

define("ANALOG_DB_PREFIX_CONFIG", "analog_conf");

class AnalogConfiguration extends XoopsObject {
	/**
	 * Constructs an instance of this class
	 */
	function AnalogConfiguration() {
		$this->XoopsObject();

		$this->initVar("confid", XOBJ_DTYPE_INT, 0, false);
		$this->initVar("name", XOBJ_DTYPE_TXTBOX, null, true, 255, true);
		$this->initVar("configuration", XOBJ_DTYPE_ARRAY, null, true);
	}
}

class AnalogConfigurationHandler extends XoopsObjectHandler {

	function &create() {
		return new AnalogConfiguration();
	}

	function &get($id) {
		$id = intval($id);
		if ($id > 0 ) {
			$sql = sprintf('SELECT confid, name, configuration FROM %s WHERE confid=%d',
					$this->db->prefix(ANALOG_DB_PREFIX_CONFIG), $id);
			if ($result = $this->db->query($sql)) {
				if ($this->db->getRowsNum($result)==1) {
					$obj = $this->create();
					$obj->assignVars($this->db->fetchArray($result));
					return $obj;
				}
			}
		}
		return false;
	}

	function insert(&$obj) {
		if (get_class($obj) != 'analogconfiguration') {  // must be lowercase only
			return false;
		}
		if (!$obj->isDirty()) {
			return true;
		}
		if (!$obj->cleanVars()) {
			return false;
		}

		foreach ($obj->cleanVars as $k => $v) {
			${$k} = $v;
		}

		$count = $this->getCount(new Criteria('confid', $confid));
		if ($confid > 0 && $count > 0) {
			$sql = sprintf('UPDATE %s SET name=%s, configuration=%s WHERE confid=%d',
					$this->db->prefix(ANALOG_DB_PREFIX_CONFIG),
					$this->db->quoteString($name),
					$this->db->quoteString($configuration), $confid);
		} else {
			$sql = sprintf('INSERT INTO %s (name, configuration) VALUES (%s, %s)',
					$this->db->prefix(ANALOG_DB_PREFIX_CONFIG),
					$this->db->quoteString($name),
					$this->db->quoteString($configuration));
		}
		if (!$result = $this->db->queryF($sql)) {  // must be queryF()
			return false;
		}

		if (empty($confid)) {
			$obj->setVar('confid', $this->db->getInsertId());
		}

		return true;
	}

	function delete(&$obj) {
		if (get_class($obj) != 'analogconfiguration') {
			return false;
		}

		$sql = sprintf('DELETE FROM %s WHERE confid=%d LIMIT 1',
				$this->db->prefix(ANALOG_DB_PREFIX_CONFIG), $obj->getVar('confid'));
		if (!$result = $this->db->queryF($sql)) {  // must be queryF()
			return false;
		}
		return true;
	}

	function getCount($criteria=null) {
		$sql = sprintf('SELECT count(*) as count FROM %s',
				$this->db->prefix(ANALOG_DB_PREFIX_CONFIG));
		if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
			$sql .= sprintf(' %s', $criteria->renderWhere());
		}
		if (!$result = $this->db->query($sql)) {
			return 0;
		}
		$count = $this->db->fetchArray($result);
		return $count['count'];
	}

	function &getObjects($criteria=null, $id_as_key=false) {
		$ret = array();
		$limit = $start = 0;

		$sql = sprintf('SELECT * FROM %s',
				$this->db->prefix(ANALOG_DB_PREFIX_CONFIG));
		if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
			$sql .= sprintf(' %s', $criteria->renderWhere());
            //$groupby = trim(str_replace('GROUP BY', "", $criteria->getGroupby()));
            //$sql .= ($groupby=='')?'':sprintf(' %s', $criteria->getGroupby());
			$sort = ($criteria->getSort()!='') ? $criteria->getSort() : 'confid';
			$sql .= sprintf(' ORDER BY %s %s', $sort, $criteria->getOrder());
			$limit = $criteria->getLimit();
			$start = $criteria->getStart();
		}
		if (!$result = $this->db->query($sql, $limit, $start)) {
			return $ret;
		}
		while ($myrow = $this->db->fetchArray($result)) {
			$obj = $this->create();
			$obj->assignVars($myrow);
			if ($id_as_key) {
				$ret[$myrow['confid']] =& $obj;
			} else {
				$ret[] =& $obj;
			}
			unset($obj);
		}
		return $ret;
	}
}
?>