<?php

// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2011 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
/*
 * constant strings
 */

// _MD_<MODULENAME>_<STRINGNAME>

// font
define('_MD_XOONIPS_FONT_LANGUAGE', 'english');

// labels
define('_MD_XOONIPS_LABEL_HOME', 'Home');
define('_MD_XOONIPS_LABEL_ADD', 'Add');
define('_MD_XOONIPS_LABEL_MODIFY', 'Modify');
define('_MD_XOONIPS_LABEL_DELETE', 'Delete');
define('_MD_XOONIPS_LABEL_UPDATE', 'Update');
define('_MD_XOONIPS_LABEL_UPLOAD', 'Upload');
define('_MD_XOONIPS_LABEL_NEXT', 'Next');
define('_MD_XOONIPS_LABEL_BACK', 'Back');
define('_MD_XOONIPS_LABEL_CANCEL', 'Cancel');
define('_MD_XOONIPS_LABEL_SUBMIT', 'Submit');
define('_MD_XOONIPS_LABEL_ACTION', 'Action');
define('_MD_XOONIPS_LABEL_WEIGHT', 'Weight');

define('_MD_XOONIPS_LABEL_ITEM_NUMBER_LIMIT', 'Maximum number of items');
define('_MD_XOONIPS_LABEL_INDEX_NUMBER_LIMIT', 'Maximum number of indexes');
define('_MD_XOONIPS_LABEL_ITEM_STORAGE_LIMIT', 'Maximum size of items[MB]');

define('_MD_XOONIPS_LABEL_GROUP_NAME', 'Group Name');
define('_MD_XOONIPS_LABEL_GROUP_DESCRIPTION', 'Group Description');
define('_MD_XOONIPS_LABEL_GROUP_ADMINISTRATORS', 'Group Administrators');
define('_MD_XOONIPS_LABEL_GROUP_MEMBERS', 'Group Members');
define('_MD_XOONIPS_LABEL_GROUP_NUM_OF_ITEMS', 'Number of Shared Items');

define('_MD_XOONIPS_ITEM_LISTING_ITEM', 'Listing item');
define('_MD_XOONIPS_ITEM_ORDER_BY', 'Order by');
define('_MD_XOONIPS_ITEM_NUM_OF_ITEM_PER_PAGE', 'No.Item per page');
define('_MD_XOONIPS_ITEM_SELECT_ITEM_TYPE_LABEL', 'Select item type');
define('_MD_XOONIPS_ITEM_ADD_ITEM_BUTTON_LABEL', 'Add item');
define('_MD_XOONIPS_ITEM_EDIT_INDEX_BUTTON_LABEL', 'Edit index');
define('_MD_XOONIPS_ITEM_SEARCH_RESULT', 'Search Result');
define('_MD_XOONIPS_ITEM_SEARCH_KEYWORD', 'Search Keyword');
define('_MD_XOONIPS_ITEM_SEARCH_ITEMTYPE', 'Search Scope');
define('_MD_XOONIPS_ITEM_SEARCH_TAB_ITEM', 'Item');
define('_MD_XOONIPS_ITEM_SEARCH_TAB_METADATA', 'Metadata');
define('_MD_XOONIPS_ITEM_SEARCH_TAB_FILE', 'File');
define('_MD_XOONIPS_ITEM_NO_ITEM_LISTED', 'No items found.');

define('_MD_XOONIPS_ITEM_DETAIL_ITEM_TITLE', 'Detail');
define('_MD_XOONIPS_ITEM_MODIFY_ITEM_TITLE', 'Modify');
define('_MD_XOONIPS_ITEM_MODIFY_ITEM_CONFIRM', 'Modify');
define('_MD_XOONIPS_ITEM_MODIFY_ITEM_CONFIRM_MESSAGE', '');
define('_MD_XOONIPS_ITEM_REGISTER_ITEM_TITLE', 'Register');
define('_MD_XOONIPS_ITEM_REGISTER_ITEM_CONFIRM', 'Register');
define('_MD_XOONIPS_ITEM_REGISTER_ITEM_CONFIRM_MESSAGE', '');

define('_MD_XOONIPS_ITEM_PRINT_FRIENDLY_BUTTON_LABEL', 'Print friendly');
define('_MD_XOONIPS_ITEM_UPDATE_BUTTON_LABEL', 'Update');
define('_MD_XOONIPS_ITEM_DELETE_BUTTON_LABEL', 'Delete');
define('_MD_XOONIPS_ITEM_REGISTER_BUTTON_LABEL', 'Register');
define('_MD_XOONIPS_ITEM_MODIFY_BUTTON_LABEL', 'Modify');
define('_MD_XOONIPS_ITEM_NEXT_BUTTON_LABEL', 'Next');
define('_MD_XOONIPS_ITEM_BACK_BUTTON_LABEL', 'Back');

define('_MD_XOONIPS_ITEM_CERTIFY_ITEM_TITLE', 'Certify item');
define('_MD_XOONIPS_ITEM_CERTIFY_BUTTON_LABEL', 'Accept');
define('_MD_XOONIPS_ITEM_UNCERTIFY_BUTTON_LABEL', 'Reject');
define('_MD_XOONIPS_ITEM_WITHDRAW_BUTTON_LABEL', 'Withdraw');

define('_MD_XOONIPS_ITEM_ITEM_LABEL', 'Item');
define('_MD_XOONIPS_ITEM_INDEX_LABEL', 'Index');

define('_MD_XOONIPS_ITEM_SELECT_INDEX_LABEL', 'Index:');
define('_MD_XOONIPS_ITEM_SELECT_BUTTON_LABEL', 'Select');
define('_MD_XOONIPS_ITEM_SELECT_CANCEL_BUTTON_LABEL', 'Back to previous page');
define('_MD_XOONIPS_ITEM_SELECT_NONE_LABEL', 'None');

define('_MD_XOONIPS_ITEM_README_LABEL', 'Readme');
define('_MD_XOONIPS_ITEM_LICENSE_LABEL', 'License');
define('_MD_XOONIPS_ITEM_RIGHTS_LABEL', 'Rights');
define('_MD_XOONIPS_ITEM_PREVIEW_LABEL', 'Preview');
define('_MD_XOONIPS_ITEM_CAPTION_LABEL', 'Caption of Preview');
define('_MD_XOONIPS_ITEM_ATTACHMENT_LABEL', 'Attachment');
define('_MD_XOONIPS_ITEM_TEXTFILE_LABEL', 'Text file');
define('_MD_XOONIPS_ITEM_FILE_HEAD_LABEL', 'File:');
define('_MD_XOONIPS_ITEM_CAPTION_HEAD_LABEL', 'Caption:');
define('_MD_XOONIPS_ITEM_ORIGINAL_FILE_NAME_LABEL', 'Original file name');
define('_MD_XOONIPS_ITEM_MIME_TYPE_LABEL', 'Mime-type');
define('_MD_XOONIPS_ITEM_TYPE_LABEL', 'Type');
define('_MD_XOONIPS_ITEM_SIZE_LABEL', 'Size');
define('_MD_XOONIPS_ITEM_LAST_UPDATED_LABEL', 'Last updated');
define('_MD_XOONIPS_ITEM_DOWNLOAD_LABEL', 'Download');
define('_MD_XOONIPS_ITEM_DOWNLOAD_COUNT_LABEL', 'Downloads');
define('_MD_XOONIPS_ITEM_TOTAL_DOWNLOAD_COUNT_SINCE_LABEL', 'Total downloads since ');

define('_MD_XOONIPS_ITEM_TEXT_FILE_EDIT_LABEL', 'Edit');
define('_MD_XOONIPS_ITEM_UPLOAD_LABEL', 'Upload');
define('_MD_XOONIPS_ITEM_OK_LABEL', 'Ok');
define('_MD_XOONIPS_ITEM_CANCEL_LABEL', 'Cancel');

define('_MD_XOONIPS_ITEM_FROM_LABEL', 'From');
define('_MD_XOONIPS_ITEM_TO_LABEL', 'To');

define('_MD_XOONIPS_ITEM_TITLE_REQUIRED', "Please enter 'Title'");
define('_MD_XOONIPS_ITEM_UPLOAD_PREVIEW', "preview file '%s' will not be uploaded. \\npush Upload button first");

define('_MD_XOONIPS_ITEM_REQUIRED_MARK', '<span style="color: red;">*</span>');
define('_MD_XOONIPS_ITEM_DOWNLOAD_CONFIRMATION', 'Do you accept the License Agreement of this file ?');

define('_MD_XOONIPS_ADD_TO_PUBLIC_EXPLANATION', 'Add to public index<br />');
define('_MD_XOONIPS_ADD_TO_PUBLIC_LABEL', 'Submit');

define('_MD_XOONIPS_ITEM_VIEWED_COUNT_LABEL', 'Views');

//Basic Information field name
define('_MD_XOONIPS_ITEM_TITLE_LABEL', 'Title');
define('_MD_XOONIPS_ITEM_KEYWORDS_LABEL', 'Free Keywords');
define('_MD_XOONIPS_ITEM_DESCRIPTION_LABEL', 'Description');
define('_MD_XOONIPS_ITEM_DOI_LABEL', 'ID');
define('_MD_XOONIPS_ITEM_ITEM_TYPE_LABEL', 'Item Type');
define('_MD_XOONIPS_ITEM_CREATION_DATE_LABEL', 'Created Date');
define('_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL', 'Last Modified Date');
define('_MD_XOONIPS_ITEM_CHANGELOG_LABEL', 'Change Log');
define('_MD_XOONIPS_ITEM_CHANGELOGS_LABEL', 'Change Log(History)');
define('_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL', 'Contributor');
define('_MD_XOONIPS_ITEM_UID_LABEL', 'Uid');
define('_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL', 'Date');
define('_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL', 'Year');
define('_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL', 'Month');
define('_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL', 'Day');

define('_MD_XOONIPS_ITEM_SELECT_INDEX', 'Please select Index from the tree.');
define('_MD_XOONIPS_ITEM_SELECT_PRIVATE_INDEX', 'Please select at least one Private Index from the tree.');
define('_MD_XOONIPS_ITEM_SELECT_PRIVATE_INDEX_AUTO', 'This item is registered to /Private , because no other private indexes are specified.');
define('_MD_XOONIPS_ITEM_NEED_TO_BE_CERTIFIED', 'It needs to be certified by a moderator or a group administrator to open this item to the public. It will take a few days.');
define('_MD_XOONIPS_ITEM_FORBIDDEN', "Sorry, you don't have the permission to access this area.");
define('_MD_XOONIPS_ITEM_CANNOT_ACCESS_ITEM', "Sorry, you don't have the permission to access this item.");
define('_MD_XOONIPS_ITEM_DELETE_CONFIRMATION_MESSAGE', 'Are you sure you want to permanently delete this item from the database?');
define('_MD_XOONIPS_ITEM_ACCEPT_CERTIFY_CONFIRMATION_MESSAGE', 'Would you like to accept this item?');
define('_MD_XOONIPS_ITEM_CANCEL_CERTIFY_CONFIRMATION_MESSAGE', 'Are you sure you want to reject this item from the Public space?');
define('_MD_XOONIPS_ITEM_WITHDRAW_CONFIRMATION_MESSAGE', 'Are you sure you want to withdraw this item from the Public space?');

define('_MD_XOONIPS_ITEM_NEW_REGISTRATION_ITEMS_MAIL_SUBJECT', 'New registration items');
define('_MD_XOONIPS_ITEM_NEW_REGISTRATION_ITEMS_MAIL_BODY', '');

define('_MD_XOONIPS_ITEM_DETAIL_URL', 'URL for Detail');
define('_MD_XOONIPS_ITEM_ADVANCED_SEARCH_TITLE', 'Search Items');

define('_MD_XOONIPS_ITEM_UPLOAD_FILE_TOO_LARGE', 'Uploaded file is too large.');
define('_MD_XOONIPS_ITEM_UPLOAD_FILE_FAILED', 'Cannot upload file.');
define('_MD_XOONIPS_ITEM_THUMBNAIL_BAD_FILETYPE', 'Bad filetype. Cannot create thumbnail.');
define('_MD_XOONIPS_ITEM_NO_CERTIFY_ITEMS', 'No items found.');
define('_MD_XOONIPS_HEADER_CERTIFY_ITEMS', 'Please certify the following items.');

define('_MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT', 'No more items are able to be registered. Please contact administrator.');
define('_MD_XOONIPS_ITEM_WARNING_INDEX_NUMBER_LIMIT', 'No more indexes are able to be registered. Please contact administrator.');
define('_MD_XOONIPS_ITEM_WARNING_ITEM_STORAGE_LIMIT', 'Not enough disk space. No more items are able to be registered. Please contact administrator.');
define('_MD_XOONIPS_ITEM_WARNING_FIELD_TRIM', 'Red part will be trimmed because of length limit.');

define('_MD_XOONIPS_ITEM_NUM_OF_ITEM', 'Number of Items');
define('_MD_XOONIPS_ITEM_STORAGE_OF_ITEM', 'Storage of Items');

define('_MD_XOONIPS_ITEM_PANKUZU_ADVANCED_SEARCH', 'Advanced Search');
define('_MD_XOONIPS_ITEM_SEARCH_BUTTON_LABEL', 'Search');
define('_MD_XOONIPS_ITEM_SEARCH_BACK_BUTTON_LABEL', 'Back');

define('_MD_XOONIPS_ITEM_PENDING_NOW', '(Pending)');

define('_MD_XOONIPS_ITEM_BAD_FILE', 'bad file');
define('_MD_XOONIPS_ITEM_BAD_FILE_TYPE', 'bad file type');
define('_MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE', 'cannot create temporary file');
define('_MD_XOONIPS_ITEM_CANNOT_CREATE_ZIP', 'cannot create zip file');
define('_MD_XOONIPS_ITEM_SEARCH_ERROR', 'search query failed.');
define('_MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR', 'search syntax error.');

define('_MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_TEXT', 'Modified; %s.');
define('_MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_DELIMITER', ', ');

//define( '_MD_XOONIPS_ITEM_ASCEND', '&darr;' );
//define( '_MD_XOONIPS_ITEM_DESCEND', '&uarr;' );
define('_MD_XOONIPS_ITEM_ASCEND', '&#9660;');
define('_MD_XOONIPS_ITEM_DESCEND', '&#9650;');

define('_MD_XOONIPS_ITEM_RELATED_TO_ADD_ID', 'Please write a related item ID per line.');
define('_MD_XOONIPS_ITEM_RELATED_TO_EDIT_ID', 'Uncheck if you want to delete relation.');
define('_MD_XOONIPS_ITEM_RELATED_TO_LEAVE_IT', 'Leave it');
define('_MD_XOONIPS_ITEM_RELATED_TO_ITEM_ID', 'Item ID');
define('_MD_XOONIPS_ITEM_RELATED_TO_ITEM_SUMMARY', 'Item summary');
define('_MD_XOONIPS_ITEM_RELATED_TO_LABEL', 'Related to');
define('_MD_XOONIPS_ITEM_RELATED_TO_ADD_ID_BUTTON_LABEL', 'Search items(new window)');
define('_MD_XOONIPS_ITEM_RELATED_TO_DESCRIPTION', '');
define('_MD_XOONIPS_ITEM_RELATED_TO_CLOSE_LABEL', 'Close window');

define('_MD_XOONIPS_RIGHTS_SOME_RIGHTS_RESERVED', 'Some rights reserved');
define('_MD_XOONIPS_RIGHTS_ALL_RIGHTS_RESERVED', 'All rights reserved');
define('_MD_XOONIPS_RIGHTS_ALLOW_COMMERCIAL_USE', 'Allow commercial uses of your resource?');
define('_MD_XOONIPS_RIGHTS_ALLOW_MODIFICATIONS', 'Allow modifications of your resource?');
define('_MD_XOONIPS_RIGHTS_YES_SA', 'Yes, as long as others share alike');

/// following defines for moderator
define(
    '_MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR', "Sorry, you don't have the right to access this area. You should be a moderator to access.
"
);

// groups.php, groupadmin.php, editgroups.php
define('_MD_XOONIPS_TITLE_GROUP_LIST', 'Group List');
define('_MD_XOONIPS_TITLE_GROUP_MEMBER_EDIT', 'Edit Group Members');
define('_MD_XOONIPS_TITLE_GROUP_EDIT', 'Edit Group Information');
define('_MD_XOONIPS_TITLE_GROUP_CREATE', 'Create New Group');
define('_MD_XOONIPS_MSG_GROUP_EMPTY', 'No Groups Found');
define('_MD_XOONIPS_MSG_GROUP_ENTER_NAME', 'Please enter group name');
define('_MD_XOONIPS_MSG_GROUP_ENTER_ADMINS', 'Please enter group admins');
define('_MD_XOONIPS_MSG_GROUP_DELETE_CONFIRM', 'Are you sure you want to delete this group?');
define('_MD_XOONIPS_MSG_GROUP_NAME_EXISTS', 'Group name already exists');
define('_MD_XOONIPS_MSG_GROUP_NAME_FORBIDDEN', 'That group name is forbidden');
define('_MD_XOONIPS_LABEL_GROUPADMIN_MEMBERS', 'Members');
define('_MD_XOONIPS_LABEL_GROUPADMIN_NONMEMBERS', 'Non-members');
define('_MD_XOONIPS_LABEL_GROUPADMIN_ADD', 'Add --&gt;');
define('_MD_XOONIPS_LABEL_GROUPADMIN_DELETE', '&lt;-- Delete');
define('_MD_XOONIPS_ERROR_GROUP_SELECT', 'Failure in retrieve group');
define('_MD_XOONIPS_ERROR_GROUP_INSERT', 'Failure in register group');
define('_MD_XOONIPS_ERROR_GROUP_UPDATE', 'Failure in update group');
define('_MD_XOONIPS_ERROR_GROUP_DELETE', 'Failure in delete group');

// certify.php
define('_MD_XOONIPS_MODERATOR_CERTIFY_USER', 'User certification');
define('_MD_XOONIPS_MODERATOR_DETAIL', 'Detail');
define('_MD_XOONIPS_MODERATOR_CERTIFY', 'Certify');

// certifyuser.php : uncertify_confirm
define('_MD_XOONIPS_MODERATOR_UNCERTIFY', 'Reject');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_CANCEL_LABEL', 'Cancel');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_EXECUTE_LABEL', 'Submit');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_TITLE', 'Rejection for User Registration');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_DESC', 'Please write your message, why he/she cann\'t use this site.');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_SUCCESS', 'User has been Rejected');

define('_MD_XOONIPS_MODERATOR_ERROR_SELECT_USER', 'Invalid user');

define('_MD_XOONIPS_MODERATOR_NOT_ACTIVATED', "You can't access this area because you are not certified.");
define('_MD_XOONIPS_MODERATOR_NO_CERTIFY_USERS', 'No users to be certified');

define('_MD_XOONIPS_MODERATOR_PANKUZU_CERTIFY_USERS', 'Certify Users');

define('_MD_XOONIPS_USER_CERTIFICATION_SUCCEED', 'The user has been certified');

/// following defines for index

define('_MD_XOONIPS_INDEX_NUMBER_OF_PRIVATE_INDEX_LABEL', 'Number of Private Indexes');
define('_MD_XOONIPS_INDEX_NUMBER_OF_GROUP_INDEX_LABEL', 'Number of Group Indexes');
define('_MD_XOONIPS_INDEX_TOO_MANY_INDEXES', "Too Many Indexes. Can't register more index.");
define('_MD_XOONIPS_INDEX_NO_INDEX', 'No Subindex Keyword');

define('_MD_XOONIPS_INDEX_BUTTON_REGISTER', 'register');
define('_MD_XOONIPS_INDEX_TITLE_EDIT', 'Edit Index Keyword');
define('_MD_XOONIPS_INDEX_TITLE_ADD', 'Add');
define('_MD_XOONIPS_INDEX_TITLE_NEW_INDEX_KEYWORD', 'New Index Keyword');
define('_MD_XOONIPS_INDEX_TITLE_MODIFY', 'Modify');
define('_MD_XOONIPS_INDEX_INDEX_KEYWORD', 'Index Keyword');
define('_MD_XOONIPS_INDEX_RENAME_TO', 'Rename to');
define('_MD_XOONIPS_INDEX_LABEL_UPDOWN', 'Up/Down');
define('_MD_XOONIPS_INDEX_LABEL_UP', 'Up');
define('_MD_XOONIPS_INDEX_LABEL_DOWN', 'Down');
define('_MD_XOONIPS_INDEX_BUTTON_RENAME', 'rename');
define('_MD_XOONIPS_INDEX_BUTTON_DELETE', 'delete');
define('_MD_XOONIPS_INDEX_BUTTON_MOVETO', 'move to');
define('_MD_XOONIPS_INDEX_LABEL_WITH_SELECTED', 'With selected:');

define('_MD_XOONIPS_INDEX_PANKUZU_EDIT_PUBLIC_INDEX_KEYWORD', 'Edit Public Tree');
define('_MD_XOONIPS_INDEX_PANKUZU_EDIT_GROUP_INDEX_KEYWORD', 'Edit Group Tree');
define('_MD_XOONIPS_INDEX_PANKUZU_EDIT_PRIVATE_INDEX_KEYWORD', 'Edit Private Tree');
define('_MD_XOONIPS_INDEX_NAME_CANNOT_BE_EMPTY', 'index keyword name cannot be empty');
define('_MD_XOONIPS_INDEX_DESTINATION_HAS_TOO_MANY_INDEXES', 'ERROR: destination has too many indexes');

define('_MD_XOONIPS_INDEX_RENAME_MESSAGE', 'Index keyword %s was renamed to %s. The following items were affected:');
define('_MD_XOONIPS_INDEX_RENAME_MAIL_SUBJECT', 'Index keyword has been renamed.');
define('_MD_XOONIPS_INDEX_DELETE_MESSAGE', 'Index keyword %s was deleted. The following items were affected:');
define('_MD_XOONIPS_INDEX_DELETE_MAIL_SUBJECT', 'Index keyword has been deleted.');
define('_MD_XOONIPS_INDEX_MOVETO_MESSAGE', 'Index keyword %s was moved to %s. The following items were affected:');
define('_MD_XOONIPS_INDEX_MOVETO_MAIL_SUBJECT', 'Index keyword has been moved.');
define('_MD_XOONIPS_INDEX_TITLE_CONFLICT', "index name '%s' conflicts");
define('_MD_XOONIPS_INDEX_TITLE_EXCEEDS', 'index name is too long.');
define('_MD_XOONIPS_INDEX_TITLE_EMPTY', 'index name cannot be empty.');
define('_MD_XOONIPS_INDEX_FORBIDDEN', 'index tree is hidden from unregistered users');
define('_MD_XOONIPS_INDEX_BAD_MOVE', "invalid operation. can't move index.");

/// following defines for account

// error labels
define('_MD_XOONIPS_ACCOUNT_BAD_CONFIG', 'XooNIps is misconfigured. AL_PATH is not specified in xoops_xnp_config table.');
define('_MD_XOONIPS_ACCOUNT_CANNOT_INITIALIZE_AL', 'could not initialize an AbstractLayer');
define('_MD_XOONIPS_ACCOUNT_DSN_EMPTY', 'xoonips dsn is not configured.');

//labels of register/edit account items
define('_MD_XOONIPS_ACCOUNT_ADDRESS', 'Address');
define('_MD_XOONIPS_ACCOUNT_DIVISION', 'Division');
define('_MD_XOONIPS_ACCOUNT_TEL', 'Phone No');
define('_MD_XOONIPS_ACCOUNT_FAX', 'Fax No');
define('_MD_XOONIPS_ACCOUNT_COMPANY_NAME', 'Institute / University / Company Name');
define('_MD_XOONIPS_ACCOUNT_COUNTRY', 'Country');
define('_MD_XOONIPS_ACCOUNT_ZIPCODE', 'Zip Code');
define('_MD_XOONIPS_ACCOUNT_NOTICE_MAIL', 'New Item Mail Notification');
define('_MD_XOONIPS_ACCOUNT_PRIVATE_ITEM_NUMBER_LIMIT', 'Maximum Private Items');
define('_MD_XOONIPS_ACCOUNT_PRIVATE_INDEX_NUMBER_LIMIT', 'Maximum Private Indexes');
define('_MD_XOONIPS_ACCOUNT_PRIVATE_ITEM_STORAGE_LIMIT', 'Maximum Disk Space for Private Items [MB]');
define('_MD_XOONIPS_ACCOUNT_POSITION', 'Position');
define('_MD_XOONIPS_ACCOUNT_NSRA', 'No Position Assigned');
define('_MD_XOONIPS_ACCOUNT_NSRID', 'No Positions in Database');
define('_MD_XOONIPS_ACCOUNT_APPEAL', 'Free description');
define('_MD_XOONIPS_ACCOUNT_CVITAE', 'Curriculum Vitae');

define('_MD_XOONIPS_ACCOUNT_XNP_USER_INFO', 'My Profile');

define('_MD_XOONIPS_ACCOUNT_NOTICE_MAIL_TOO_LITTLE', 'Mail Notification should be more than or equal to zero.');
define('_MD_XOONIPS_ACCOUNT_INVALID_SECRETKEY', 'invalid secretkey');
define('_MD_XOONIPS_ACCOUNT_PUSH_BUTTON_TO_ENTER_USERINFO', 'Push to register');
define('_MD_XOONIPS_ACCOUNT_INVITATION_SUCCED', 'Thanks for your invitation.');
define('_MD_XOONIPS_ACCOUNT_NOTREGISTERED1', 'Not registered?  Click ');
define('_MD_XOONIPS_ACCOUNT_NOTREGISTERED2', 'here.');
define('_MD_XOONIPS_ACCOUNT_NOTIFICATIONS', 'Notifications');

// registeruser.php errormessage
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_ADDRESS', 'Address'.' is too long. It must be less than 127 characters.');
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_DIVISION', 'Division'.' is too long. It must be less than 127 characters.');
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_TEL', 'Phone No'.' is too long. It must be less than 32 characters.');
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_COMPANY_NAME', 'Fax No'.' is too long. It must be less than 32 characters.');
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_ZIPCODE', 'Zip Code'.' is too long. It must be less than 127 characters.');
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_COUNTRY', 'Institute / University / Company Name'.' is too long. It must be less than 127 characters.');
define('_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_FAX', 'Country'.' is too long. It must be less than 32 characters.');
define('_MD_XOONIPS_ACCOUNT_MUST_BE_FILLED_IN', "'%s' must be filled in.");

define('_MD_XOONIPS_ACCOUNT_INVITE_USER', 'Invite User');
define('_MD_XOONIPS_ACCOUNT_INVITE_USER_MAIL_SUBJECT', 'Invitation to ');

// useradmin.define
define('_MD_XOONIPS_ACCOUNT_CANNOT_ACQUIRE_USER_INFO', 'Failure in retrive user information');
define('_MD_XOONIPS_ACCOUNT_CANNOT_UPDATE_USER_INFO', 'Failure in update user information');

define('_MD_XOONIPS_ACCOUNT_QUERY_ERROR', 'Database query error');

define('_MD_XOONIPS_ACCOUNT_FORBIDDEN', "Sorry, you don't have permission to access this area.");

define('_MD_XOONIPS_ACCOUNT_SELECT_USER', 'Select User');
define('_MD_XOONIPS_ACCOUNT_DELETE_USER', 'Delete User');
define('_MD_XOONIPS_ACCOUNT_PASSWORD_DOESNT_MATCH', 'The new password does not match.');

define('_MD_XOONIPS_ACCOUNT_PREFERENCE', 'Perference');

// user.php : delete_confirm
define('_MD_XOONIPS_ACCOUNT_DELETE_CANCEL_LABEL', 'Cancel');
define('_MD_XOONIPS_ACCOUNT_DELETE_EXECUTE_LABEL', 'Execute');
define('_MD_XOONIPS_ACCOUNT_DELETE_TITLE', 'User Delete Confirmation');
define('_MD_XOONIPS_ACCOUNT_DELETE_DESC', 'Do you really want to delete user account?');
define('_MD_XOONIPS_ACCOUNT_DELETE_IGNORE_USER', 'Please remove System Administrator or Moderator or Group Administrator User Privileges');
define('_MD_XOONIPS_ACCOUNT_DELETE_ITEM_HANDOVER', 'Please transfer Public and/or Group items before User Deletion');
define('_MD_XOONIPS_ACCOUNT_DELETE_SUCCESS', 'User has been deleted');

//
// mesasge for user registration
//
define('_MD_XOONIPS_ACTIVATE_KEY_SUBJECT', 'User activation key for %s');
define('_MD_XOONIPS_ACTIVATE_BY_USER_CERTIFY_MANUAL', 'An e-mail has been sent to the registered e-mail address. You will need to activate your account by following the instructions in the e-mail. After completing the activation, please wait for certification of your account from the moderator.');
define('_MD_XOONIPS_ACTIVATE_BY_USER_CERTIFY_AUTO', 'An e-mail has been sent to the registered e-mail address. Please follow the instructions in the e-mail to activate your account.');
define('_MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_MANUAL', 'An e-mail has sent to a moderator. Wait for your account certification. You get a notice of certification by e-mail. ');
define('_MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_MANUAL_MAILNG', 'Failed in sending e-mail to moderator to request your account certification. Contact to an adminstrator or a moderator.');
define('_MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_AUTO', 'Your account has been certified. You have an access to this site with username and password you registered.');
define('_MD_XOONIPS_ACTIVATE_BY_ADMIN_CERTIFY_AUTO', 'The account of the user has been registered. Wait for your account activation. You get a notice of activation by e-mail.');
define('_MD_XOONIPS_ACTIVATE_BY_ADMIN_CERTIFY_MANUAL', 'The account of the user has been registered. Wait for your account activation and certification. You get a notice of certification by e-mail.');
define('_MD_XOONIPS_ACTIVATE_BY_ADMIN_MAILNG', 'Failed in sending e-mail to an adminstrator to request your account activation. Contact to an adminstrator.');

define('_MD_XOONIPS_ACTIVATED_BY_USER_CERTIFIED_AUTO', 'Your account of the user has been certified. You have an access to this site with username and password you registered.');
define('_MD_XOONIPS_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO', 'The account of the user has been activated and certified. An e-mail to notice certification has been sent to registered address.');
define('_MD_XOONIPS_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO_MAILNG', 'The account of the user has been activated and certified. However, failed in sending e-mail of notice to registered address.');
define('_MD_XOONIPS_ACTIVATED_BY_USER_AND_CERTIFY_MANUAL', 'Your account has been activated. Please wait for its certification before to use it. The certification will be notified to you by an e-mail from the moderator.');
define('_MD_XOONIPS_ACTIVATED_BY_ADMIN_AND_CERTIFY_MANUAL', 'The account has been activated. After moderator certifies the account, an email is sent to registered address.');
define('_MD_XOONIPS_ACTIVATED_BY_USER_AND_CERTIFY_MANUAL_MAILNG', 'Failed in sending e-mail to moderator to request your account certification. Contact to a moderator.');
define('_MD_XOONIPS_ACTIVATED_BY_ADMIN_AND_CERTIFY_MANUAL_MAILNG', 'Failed in sending e-mail to moderator to request your account certification.');

define('_MD_XOONIPS_ACCOUNT_NOT_ACTIVATED', "You can't access this area because you are not certified. Wait for your account certification. You get a notice of certification by e-mail.");
define('_MD_XOONIPS_USER_ACTIVATED', 'Your account has been activated. Please wait for that your account is certified by moderator.');
define('_MD_XOONIPS_USER_NOACTTPADM', "You don't have access to this area because your account has not been activated or certified.");
define('_MD_XOONIPS_ACCOUNT_ALREADY_CERTIFIED', 'The user is already certified');
define('_MD_XOONIPS_ACCOUNT_ACTIVATE_NG', 'Failed in activate account. Contact to administrator and moderator.');

//subjects for e-mail of user registration
define('_MD_XOONIPS_ACCOUNT_CERTIFIED', 'Your account has been certified.');
define('_MD_XOONIPS_ACCOUNT_REJECTED', 'Your account has been rejected.');
define('_MD_XOONIPS_ACCOUNT_REGISTERD', 'Certify new account');

// admin/config.php
define('_MD_XOONIPS_ACCOUNT_CONFIG', 'Site Configuration');

define('_MD_XOONIPS_ACCOUNT_AMAZON_ASSOCIATES_ID_TITLE', 'Amazon Associates ID');

define('_MD_XOONIPS_ACCOUNT_REQUIRED_MARK', '(*)');
define('_MD_XOONIPS_ACCOUNT_EXPLAIN_REQUIRED_MARK', '(*) = required');

// event_log.php
define('_MD_XOONIPS_EVENTLOG_DOWNLOAD_TITLE', 'Download Event Logs');
define('_MD_XOONIPS_EVENTLOG_DOWNLOAD_DESC1', 'Download event logs for the following period:');
define('_MD_XOONIPS_EVENTLOG_DOWNLOAD_DESC2', '');
define('_MD_XOONIPS_EVENTLOG_DATE_FROM_PREFIX', ' from : ');
define('_MD_XOONIPS_EVENTLOG_DATE_TO_PREFIX', ' to&nbsp;&nbsp;&nbsp;: ');
define('_MD_XOONIPS_EVENTLOG_DATE_YEAR_PREFIX', '');
define('_MD_XOONIPS_EVENTLOG_DATE_YEAR_POSTFIX', '');
define('_MD_XOONIPS_EVENTLOG_DATE_MONTH_PREFIX', '-');
define('_MD_XOONIPS_EVENTLOG_DATE_MONTH_POSTFIX', '');
define('_MD_XOONIPS_EVENTLOG_DATE_DAY_PREFIX', '-');
define('_MD_XOONIPS_EVENTLOG_DATE_DAY_POSTFIX', '');
define('_MD_XOONIPS_EVENTLOG_DATE_TILDA', '-');
define('_MD_XOONIPS_EVENTLOG_CATEGORY_TITLE', 'Category');
define('_MD_XOONIPS_EVENTLOG_CATEGORY_DESC', 'Select period, and click Download (get a csv file) or Graph(show a log graph).');
define('_MD_XOONIPS_EVENTLOG_DOWNLOAD', 'Download');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP', 'Access to top page');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM', 'Access to item');
define('_MD_XOONIPS_EVENTLOG_DOWNLOAD_ITEM', 'Download of item');
define('_MD_XOONIPS_EVENTLOG_ADD', 'New users and items');
define('_MD_XOONIPS_EVENTLOG_GRAPH', 'Graph');
define('_MD_XOONIPS_EVENTLOG_ACCESS_LABEL', 'Access');
define('_MD_XOONIPS_EVENTLOG_DL_LABEL', 'Download');
define('_MD_XOONIPS_EVENTLOG_NEW_USER_LABEL', 'Users');
define('_MD_XOONIPS_EVENTLOG_NEW_ITEM_LABEL', 'Items');
define('_MD_XOONIPS_EVENTLOG_DAYS_LABEL', 'Days');
define('_MD_XOONIPS_EVENTLOG_MONTHS_LABEL', 'Months');
define('_MD_XOONIPS_EVENTLOG_TOTAL_LABEL', 'Total');
define('_MD_XOONIPS_EVENTLOG_DOMAINS_LABEL', 'Domains');
define('_MD_XOONIPS_EVENTLOG_PER_ITEM_LABEL', 'Per item');
define('_MD_XOONIPS_EVENTLOG_PER_USER_LABEL', 'Per user');
define('_MD_XOONIPS_EVENTLOG_PER_FILE_LABEL', 'Per file');
define('_MD_XOONIPS_EVENTLOG_LIST_LABEL', 'View');
define('_MD_XOONIPS_EVENTLOG_VIEW_TITLE', 'Registered Informations');
define('_MD_XOONIPS_EVENTLOG_VIEW_DESCRIPTION', 'Click Download(get a csv file) or View(browse data).');
define('_MD_XOONIPS_EVENTLOG_VIEW_LIST_TITLE', 'Registered Users and Items');
define('_MD_XOONIPS_EVENTLOG_VIEW_USER_TITLE', 'Registered Users');
define('_MD_XOONIPS_EVENTLOG_VIEW_USER_PER_PAGE_LABEL', 'User per page');
define('_MD_XOONIPS_EVENTLOG_VIEW_ITEM_TITLE', 'Registered Items');
define('_MD_XOONIPS_EVENTLOG_VIEW_ITEM_PER_PAGE_LABEL', 'Item per page');
define('_MD_XOONIPS_EVENTLOG_EVENT_TYPES', 'dummy,Login Failure,Login Success,Logout,Insert Item,Update Item,Delete Item,View Item,Download File,Request To Certify Item,Insert Index,Update Index,Delete Index,Certify Item,Reject Item,Request To Insert Account,Certify Account,Insert Group,Update Group,Delete Group,Insert Group Member,Delete Group Member,View Top Page,Quick Search,Advanced Search,Start SU,End SU');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS', 'Event Type,Timestamp,Exec UID,Remote Host,Index ID,Item ID,File ID,UID,GID,Search Keyword,Login Name,Additional Information');
// - for CSV files
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DATE', 'Date,Count');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DOMAINS', 'Remote host,Count');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DL_PER_ITEM', 'Item id,Title,Contributor,Item type,');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DL_PER_FILE', 'File id,File name,Title,Contributor,Item type,');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DL_PER_USER', 'User,');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_ACCESS_ITEM', 'Item id,Title,Contributor,Item type,');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_ACCESS_USER', 'User,Title,Item type,');
define('_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_TOTAL', 'Total');

define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DAYS_LABEL', 'Access to top page (Days)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_MONTHS_LABEL', 'Access to top page (Months)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_TOTAL_LABEL', 'Access to top page (Total)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DOMAINS_LABEL', 'Access to top page (Domains)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DAYS_LABEL', 'Access to items (Days)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_MONTHS_LABEL', 'Access to items (Months)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_TOTAL_LABEL', 'Access to items (Total)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DOMAINS_LABEL', 'Access to items (Domains)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_PER_ITEM_LABEL', 'Access to items (per item)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_PER_USER_LABEL', 'Access to items (per user)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_DAYS_LABEL', 'Download items (Days)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_MONTHS_LABEL', 'Download items (Months)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_TOTAL_LABEL', 'Download items (Total)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_DOMAINS_LABEL', 'Download items (Domains)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_PER_ITEM_LABEL', 'Download items (per item)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_PER_FILE_LABEL', 'Download items (per file)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_PER_USER_LABEL', 'Download items (per user)');
define('_MD_XOONIPS_EVENTLOG_NEW_USERS_LABEL', 'New users (Months)');
define('_MD_XOONIPS_EVENTLOG_NEW_ITEMS_LABEL', 'New items (Months)');
// - for graphs
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DAYS_TITLE', 'Access to top page (Days)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DAYS_TITLE', 'Access to items (Days)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_DAYS_TITLE', 'Download items (Days)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_MONTHS_TITLE', 'Access to top page (Months)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_MONTHS_TITLE', 'Access to items (Months)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_MONTHS_TITLE', 'Download items (Months)');
define('_MD_XOONIPS_EVENTLOG_NEW_USER_MONTHS_TITLE', 'New users (Months)');
define('_MD_XOONIPS_EVENTLOG_NEW_ITEM_MONTHS_TITLE', 'New items (Months)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DAYS_TOTAL_TITLE', 'Access to top page (Total)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DAYS_TOTAL_TITLE', 'Access to items (Total)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_DAYS_TOTAL_TITLE', 'Download items (Total)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DOMAINS_TITLE', 'Access to top page (Domains)');
define('_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DOMAINS_TITLE', 'Access to items (Domains)');
define('_MD_XOONIPS_EVENTLOG_DL_ITEM_DOMAINS_TITLE', 'Download items (Domains)');

//pankuzu
define('_MI_XOONIPS_ACCOUNT_PANKUZU_PLATFORM_USER', 'XooNIps User');
define('_MI_XOONIPS_ACCOUNT_PANKUZU_GROUP_ADMINISTRATOR', 'Group Administrator');
define('_MI_XOONIPS_ACCOUNT_PANKUZU_MODERATOR', 'Moderator');
define('_MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR', '&nbsp;&raquo;&raquo;&nbsp;');
define('_MI_XOONIPS_ITEM_PANKUZU_CERTIFY_PUBLIC_ITEMS', 'Certify Public Items');
define('_MI_XOONIPS_ITEM_PANKUZU_CERTIFY_GROUP_ITEMS', 'Certify Group Items');
define('_MI_XOONIPS_ITEM_PANKUZU_EDIT_ACCOUNT', 'Edit Account');
define('_MI_XOONIPS_ITEM_PANKUZU_VIEW_ACCOUNT', 'View Account');
define('_MI_XOONIPS_ITEM_PANKUZU_EDIT_CURRICULUM_VITAE', 'Edit Curriculum Vitae');

//export/import
define('_MD_XOONIPS_EXPORT_PANKUZU_EXPORT', 'Export');
define('_MD_XOONIPS_EXPORT_PANKUZU_EXPORT_CONFIG', 'Export setting');
define('_MD_XOONIPS_EXPORT_PANKUZU_EXPORT_LICENSE', 'License agreement');
define('_MD_XOONIPS_EXPORT_PANKUZU_EXPORT_INDEX', 'Export indexes');
define('_MD_XOONIPS_EXPORT_CONFIG_TITLE', 'Export setting');
define('_MD_XOONIPS_EXPORT_CONFIG_SUBMIT', 'Next');
define('_MD_XOONIPS_EXPORT_RECURSIVE', 'Export indexes recursive');
define('_MD_XOONIPS_EXPORT_ATTACHMENT', 'Export attachments');
define('_MD_XOONIPS_EXPORT_BUTTON_LABEL', 'Export');
define('_MD_XOONIPS_EXPORT_EXPORT_LICENSE', 'License agreement');
define('_MD_XOONIPS_EXPORT_LICENSE', 'License');
define('_MD_XOONIPS_EXPORT_ACCEPT', 'Accept');
define('_MD_XOONIPS_EXPORT_CANNOT_BE_EXPORTED_ITEMS', 'Following items can not be exported.');
define('_MD_XOONIPS_EXPORT_NO_ITEMS_FOUND', 'No items found.');
define('_MD_XOONIPS_EXPORT_ACCEPT_ALL', 'Accept all');
define('_MD_XOONIPS_EXPORT_EXPORT_ITEMS_EMPTY', 'no export item specified');
define('_MD_XOONIPS_EXPORT_LICENSE_AGREEMENT_SUBMIT', 'Download');
define('_MD_XOONIPS_EXPORT_EXPORT_INDEX', 'Exporting indexes in following settings');
define('_MD_XOONIPS_EXPORT_TYPE_ITEM', 'Export items');
define('_MD_XOONIPS_EXPORT_TYPE_INDEX', 'Export indexes');
define('_MD_XOONIPS_IMPORT_TITLE', 'Import');
define('_MD_XOONIPS_IMPORT_FILE', 'File to import');
define('_MD_XOONIPS_IMPORT_INDEX', 'Indexes to import');
define('_MD_XOONIPS_IMPORT_INDEX_TEXT', 'Choose indexes to import from index tree');
define('_MD_XOONIPS_IMPORT_REQUIRED', '(Required)');
define('_MD_XOONIPS_IMPORT_PANKUZU_IMPORT', 'Import');
define('_MD_XOONIPS_IMPORT_PANKUZU_RESOLVE_CONFLICT', 'Resolve conflict');
define('_MD_XOONIPS_IMPORT_TITLE_RESOLVE_CONFLICT', 'Resolve conflict');
define('_MD_XOONIPS_IMPORT_IMPORT_ALL', 'Import all');
define('_MD_XOONIPS_IMPORT_IMPORT_ITEM', 'Import item');
define('_MD_XOONIPS_IMPORT_PANKUZU_UPLOAD_FILE', 'Upload file');
define('_MD_XOONIPS_IMPORT_IMPORT_SUCCESSFULLY', 'Items have been successfully imported.');
define('_MD_XOONIPS_IMPORT_NO_ITEMS_IMPORTED', 'No items have been imported.');
define('_MD_XOONIPS_IMPORT_INDEX_NUMBER_LIMIT_OVER_FLOW', 'Error: Number of private indexes are exceeded. Please contact admin.');
define('_MD_XOONIPS_IMPORT_ITEM_NUMBER_LIMIT_OVER_FLOW', 'Error: Number of private items are exceeded. Please contact admin.');
define('_MD_XOONIPS_IMPORT_RESOLVE_CONFLICT_SUBMIT', 'Next');
define('_MD_XOONIPS_IMPORT_UPLOAD_SUBMIT', 'Next');
define('_MD_XOONIPS_IMPORT_PANKUZU_CHECK_LENGTH', 'Check length of each fields');
define('_MD_XOONIPS_IMPORT_TITLE_CHECK_LENGTH', 'Check length of each fields');
define('_MD_XOONIPS_IMPORT_CHECK_LENGTH_SUBMIT', 'Upload');
define('_MD_XOONIPS_IMPORT_CHECK_LENGTH_WARNING', 'Following items exceed length limit. Red part will be trimmed.');
define('_MD_XOONIPS_IMPORT_CHECK_LENGTH_NO_WARNING', 'No items will be trimmed.');
define('_MD_XOONIPS_IMPORT_INDEX_CANNOT_WRITE', 'Indexes as follows are ignored. You can only import to your own private indexes.');
define('_MD_XOONIPS_IMPORT_IGNORE_CHECK', 'Don\'t care confliction and trimming');
define('_MD_XOONIPS_IMPORT_NO_STRINGS_ARE_TRIMMED', 'No strings are trimmed');
define('_MD_XOONIPS_IMPORT_NO_CONFLICT_ITEMS', 'No confliction');
define('_MD_XOONIPS_IMPORT_NUMBER_OF_CONFLICT_ITEMS', 'Number of conflict items:');
define('_MD_XOONIPS_IMPORT_FOLLOWING_ITEM_CONFLICT', 'Following items conflict.');
define('_MD_XOONIPS_IMPORT_IMPORT_ALL_AS_NEW', "All conflict items will be imported as an new items\n(check boxes of update are ignored).");
define('_MD_XOONIPS_IMPORT_IMPORT_MODIFY', 'Update following items that has been registered to indexes imported to');
define('_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_IN_OTHER_INDEXES', 'In other indexes, following items conflict.(not updated)');
define('_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_IN_THE_SAME_FILE', 'In the same import file, following items conflict.');
define('_MD_XOONIPS_IMPORT_IMPORT_CAN_NOT_MODIFY', 'This item can\'t be imported because it conflict with plural items.');
define('_MD_XOONIPS_IMPORT_LOGGING', 'Logging');
define('_MD_XOONIPS_IMPORT_ERROR', 'Error in importing.');
define('_MD_XOONIPS_IMPORT_READY', 'Ready to import.');
define('_MD_XOONIPS_IMPORT_NO_ERROR', 'No errors.');
define('_MD_XOONIPS_IMPORT_REVIEW_LOG', 'Make sure the log.');
define('_MD_XOONIPS_IMPORT_LOCAL_FILE', 'Import a local file');
define('_MD_XOONIPS_IMPORT_REMOTE_FILE', 'Import a remote file');
define('_MD_XOONIPS_IMPORT_ERROR_CHECK_ONLY', 'Don\'t import(Error check only)');
define('_MD_XOONIPS_IMPORT_CONTRIBUTOR_SELECT', 'To import it in place of the other user');
define('_MD_XOONIPS_IMPORT_ERROR_CKECK_DONE', 'Check has done.');
define('_MD_XOONIPS_IMPORT_INDEX_TREE_CREATED', 'Indexes below has been imported to(If the index already exists , it is not modified.)');
define('_MD_XOONIPS_IMPORT_INDEX_TREE_FAILED', 'Imporing index tree failed.');
define('_MD_XOONIPS_IMPORT_FILE_NOT_FOUND', 'Import file is not found.');
define('_MD_XOONIPS_IMPORT_FILE_NOT_SPECIFIED', 'Import file is not specified.');
define('_MD_XOONIPS_IMPORT_CERTIFY_AUTO', 'To certify items automatically.');
define('_MD_XOONIPS_IMPORT_NO_ITEMS_ARE_FOUND', 'No items to be imported are found.  Make sure that import file is correct.');
define('_MD_XOONIPS_IMPORT_FOLLOWING_INDEX', 'Following indexes are imported.');
define('_MD_XOONIPS_IMPORT_FOLLOWING_INDEX_TEST', 'Following indexes will be imported.');
define('_MD_XOONIPS_IMPORT_CIRCULAR_INDEX', 'Indexes can\'t be imported because of circular structure.');

define('_MD_XOONIPS_EVENT_ITEM_IS_SHOWN_IN', 'Item is shown in following index');
define('_MD_XOONIPS_EVENT_NEW_GROUP', 'New group has been created');

define('_MD_XOONIPS_ITEM_LANG_LABEL', 'Language');
define('_MD_XOONIPS_ITEM_LANG_OPTION_IDS', 'eng,jpn,fra,deu,esl,ita,dut,sve,nor,dan,fin,por,chi,kor');
define('_MD_XOONIPS_ITEM_LANG_OPTION_NAMES', 'English,Japanese,French,German,Spanish,Italian,Dutch,Swedish,Norwegian,Danish,Finnish,Portuguese,Chinese,Korean');
define('_MD_XOONIPS_DOWNLOAD_LIMITATION_OPTION_LABEL', 'Download Limitation');
define('_MD_XOONIPS_DOWNLOAD_NOTIFICATION_OPTION_LABEL', 'Download Notification');
define('_MD_XOONIPS_DOWNLOAD_ABNORMAL_CONFIGURATION', 'XooNIps Abnormal Download File Configuration');

define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_LABEL', 'Login User');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL', 'Everyone');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_ONLY_LABEL', 'Login User only');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_DO_LABEL', 'Yes');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_DONT_LABEL', 'No');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_EXPLANATION', 'This option is effective only if download limitation option is "login user" and event "notify when item is downloaded" is "on"');

define('_MD_XOONIPS_ITEM_ATTACHMENT_FILE_INFO_TITLE_LABEL', 'download file information');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_TITLE_LABEL', 'download notification');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_QUERY_LABEL', 'If you download this file, item owner will be notified that you downloaded.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_YES_LABEL', 'I accept that.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_NO_LABEL', 'I do not accept that.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_TITLE_LABEL', 'license agreement');
define('_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_QUERY_LABEL', 'Please read the following license agreement carefully.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_YES_LABEL', 'I accept the terms in the license agreement.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_NO_LABEL', 'I do not accept the terms in the license agreement.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_NEED_AGREE_LABEL', 'Acceptance is needed to download this file.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_NEED_AGREE_BOTH_LABEL', 'Both acceptances are needed to download this file.');
define('_MD_XOONIPS_ITEM_ATTACHMENT_DOWNLOAD_LABEL', 'Download');
define('_MD_XOONIPS_ITEM_ATTACHMENT_CANCEL_LABEL', 'Cancel');
define('_MD_XOONIPS_ITEM_ATTACHMENT_BAD_TOKEN_LABEL', 'You have already downloaded this file.<br />Please retry download after page reload.');
define('_MD_XOONIPS_ITEM_DOWNLOAD_NOSCRIPT_LABEL', 'To download this file, enable JavaScript in your browser.');

// harvest.php
define('_MD_XOONIPS_OAIPMH_HARVEST_RESULT', 'Result of harvesting');
define('_MD_XOONIPS_BACK_TO_OAIPMH_CONFIGURATION', 'Back to OAI-PMH maintenance');

define('_MD_XOONIPS_METADATA_SEARCH_LABEL', 'Metadata Search');

// labels for item_show (edit)
define('_MD_XOONIPS_ITEMSHOW_CURRICULUM_VITAE', 'Curriculum Vitae');
define('_MD_XOONIPS_ITEM_SHOW_EDIT_TITLE', 'Edit Show Items');
define('_MD_XOONIPS_ITEM_SHOW_ITEMLIST_PREV', 'PREV');
define('_MD_XOONIPS_ITEM_SHOW_ITEMLIST_NEXT', 'NEXT');
define('_MD_XOONIPS_ITEM_SHOW_ITEMLIST_CHECK', 'Check');
define('_MD_XOONIPS_ITEM_SHOW_ITEMLIST_ITEMS', 'Items');
define('_MD_XOONIPS_ITEM_SHOW_ITEMLIST_SUBMIT', 'Submit');
define('_MD_XOONIPS_NEED_LOGIN', 'The publication list can be inspected by logging in.');

// labels of userlists, showusers
define('_MD_XOONIPS_USERLIST_TITLE', 'User List');
define('_MD_XOONIPS_USERLIST_EXPLANATION', 'Self-introduction will be displayed if a name is clicked.');

define('_MD_XOONIPS_SHOW_USER_TITLE', 'User Information');
define('_MD_XOONIPS_SEND_MESSAGE', 'Message To');
define('_MD_XOONIPS_SHOW_CV_LABEL', 'Curriculum Vitae');
define('_MD_XOONIPS_SHOW_PUBILICATION_LIST', 'Publication List');
define('_MD_XOONIPS_SHOW_BACKTOLIST_LABEL', 'Back to User List');
define('_MD_XOONIPS_VIEW_USER_ACCOUNT', 'View Account');
define('_MD_XOONIPS_EDIT_LISTS', 'Edit');
define('_MD_XOONIPS_ORDER_CHANGE', 'Order');

define('_MD_XOONIPS_UPLOAD_MAX_FILESIZE', 'File size up to:');
define('_MD_XOONIPS_UPLOAD_ERR_OK', 'upload succeed');
define('_MD_XOONIPS_UPLOAD_ERR_INI_SIZE', 'upload filesize too large( upload_max_filesize )');
define('_MD_XOONIPS_UPLOAD_ERR_FORM_SIZE', 'upload filesize too large( MAX_FILE_SIZE )');
define('_MD_XOONIPS_UPLOAD_ERR_PARTIAL', 'uploaded file is imcomplete');
define('_MD_XOONIPS_UPLOAD_ERR_NO_FILE', 'no files are uploaded');
define('_MD_XOONIPS_UPLOAD_ERR_NO_TMP_DIR', 'temporary folder does not exists.');
define('_MD_XOONIPS_UPLOAD_ERR_CANT_WRITE', 'can\'t write to disk.');

// labels for edit curriculum vitae, publication list.
define('_MD_XOONIPS_EDIT_CV_TITLE', 'Edit CV');
define('_MD_XOONIPS_EDIT_CURRICULUM_VITAE', 'Edit Curriculum Vitae');
define('_MD_XOONIPS_ADD_CURRICULUM_VITAE_LABEL', 'Add Curriculum Vitae');
define('_MD_XOONIPS_ADD_CURRICULUM_VITAE_WARNING', 'Please enter the title of Curriculum Vitae.');
define('_MD_XOONIPS_CURRICULUM_VITAE_FROM', 'From');
define('_MD_XOONIPS_CURRICULUM_VITAE_TO', 'To');
define('_MD_XOONIPS_CURRICULUM_VITAE_TITLE', 'Title');
define('_MD_XOONIPS_ADD_CURRICULUM_VITAE', 'Add');
define('_MD_XOONIPS_MODIFY_CURRICULUM_VITAE_LABEL', 'Edit Curriculum Vitae');
define('_MD_XOONIPS_NO_CURRICULUM_VITAE_DATA', 'No Title Data.');
define('_MD_XOONIPS_CURRICULUM_VITAE_BUTTON_EDIT', 'modify');
define('_MD_XOONIPS_CURRICULUM_VITAE_CHECK_INFO', 'Back to your User Information');
define('_MD_XOONIPS_CURRICULUM_VITAE_INSERT', 'Now, Curriculum Vitae data is registered into a database.');
define('_MD_XOONIPS_NO_PUBLICATION_ITEM_DATA', 'No Item data for Publication List.');
define('_MD_XOONIPS_PUBLICATION_ITEM_CHANGE', 'Change item order for Publication List');
define('_MD_XOONIPS_PUBLICATION_ITEM_INSERT', 'Now, Publication item data is registered into a database.');

define('_MD_XOONIPS_SU_TITLE', 'Switch User Account');
define('_MD_XOONIPS_SU_TARGET_USER', 'Switch to');
define('_MD_XOONIPS_SU_ADMIN_PASSWORD', 'Your Password');
define('_MD_XOONIPS_SU_OK', 'OK');
define('_MD_XOONIPS_SU_CANNOT_LOGOUT', 'End to switch user account before logout!');

define('_MD_XOONIPS_SU_START', 'Switching to another account.');
define('_MD_XOONIPS_SU_FAIL', 'Incorrect password!');
define('_MD_XOONIPS_SU_END', 'Returning to your account.');
define('_MD_XOONIPS_SU_EXPLAIN', 'You can switch to another account temporary.');

// doi( sort id )
define('_MD_XOONIPS_ITEM_DOI_DUPLICATE_ID', 'ID is duplicated.');
define('_MD_XOONIPS_ITEM_DOI_NOT_FOUND', 'ID is not found.');
define('_MD_XOONIPS_ITEM_DOI_INVALID_ID', 'Invallid character is used in ID, or too long ID. ID must be %d characters or less.');

define('_MD_XOONIPS_SEARCH_ALL', 'ALL');
define('_MD_XOONIPS_SEARCH_METADATA', 'Metadata');
define('_MD_XOONIPS_SEARCH_TITLE_AND_KEYWORD', 'Title & Keyword');

define('_MD_XOONIPS_PAGENAVI_NEXT', 'NEXT');
define('_MD_XOONIPS_PAGENAVI_PREV', 'PREV');

define('_MD_XOONIPS_ADD_FROM_ITEM_LIST_BUTTON_LABEL', 'Item List');
define('_MD_XOONIPS_ADD_FROM_COLUMN_LABEL', 'Add items from ');
define('_MD_XOONIPS_ADD_FROM_INDEX_BUTTON_LABEL', 'Index keyword');
define('_MD_XOONIPS_ADD_FROM_SEARCH_BUTTON_LABEL', 'Search');

define('_MD_XOONIPS_ERROR_CANNOT_EDIT_LOCKED_ITEM', 'cannot edit item because it is %s');
define('_MD_XOONIPS_ERROR_CANNOT_DELETE_LOCKED_ITEM', 'cannot delete item because it is %s');
define('_MD_XOONIPS_ERROR_CANNOT_WITHDRAW_LOCKED_ITEM', 'cannot withdraw item because it is %s');
define('_MD_XOONIPS_WARNING_CANNOT_EDIT_LOCKED_ITEM', 'cannot edit this item because it is %s');
define('_MD_XOONIPS_WARNING_CANNOT_EDIT_LOCKED_INDEX', 'cannot edit this index because it has items %s');
define('_MD_XOONIPS_ERROR_CANNOT_EDIT_LOCKED_INDEX', 'cannot edit index because it has items %s');
define('_MD_XOONIPS_WARNING_CANNOT_EDIT_LOCKED_GROUP', 'cannot edit this group because it has items %s');
define('_MD_XOONIPS_ERROR_CANNOT_EDIT_LOCKED_GROUP', 'cannot edit group because it has items %s');
define('_MD_XOONIPS_ERROR_CANNOT_DELETE_LOCKED_GROUP', 'cannot delete group because it has items %s');
define('_MD_XOONIPS_ERROR_CANNOT_REMOVE_MEMBER_WHO_SHARE_ITEMS', 'cannot remove users %s because they share items to this group');
define('_MD_XOONIPS_ERROR_CANNOT_OVERWRITE_LOCKED_ITEM', "cannot overwrite '%s' because it is %s");
define('_MD_XOONIPS_LOCK_TYPE_STRING_NOT_LOCKED', 'not locked');
define('_MD_XOONIPS_LOCK_TYPE_STRING_CERTIFY_REQUEST', 'requested to certify');
define('_MD_XOONIPS_LOCK_TYPE_STRING_TRANSFER_REQUEST', 'requested to transfer');
define('_MD_XOONIPS_LOCK_TYPE_STRING_PUBLICATION_GROUP_INDEX', 'requested to certify');
define('_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_LOCKED_CERTIFY_REQUEST', 'In the same index, following items conflict.(not updated because they are '._MD_XOONIPS_LOCK_TYPE_STRING_CERTIFY_REQUEST.')');
define('_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_LOCKED_TRANSFER_REQUEST', 'In the same index, following items conflict.(not updated because they are '._MD_XOONIPS_LOCK_TYPE_STRING_TRANSFER_REQUEST.')');

define('_MD_XOONIPS_ITEM_TRANSFER_NOTIFYSBJ', 'Item has been transferred');
define('_MD_XOONIPS_ACCOUNT_CERTIFY_REQUEST_NOTIFYSBJ', 'New account has been registered');
define('_MD_XOONIPS_ACCOUNT_CERTIFIED_NOTIFYSBJ', 'Account has been certified');
define('_MD_XOONIPS_ACCOUNT_REJECTED_NOTIFYSBJ', 'Account has been rejected');
define('_MD_XOONIPS_ITEM_CERTIFY_REQUEST_NOTIFYSBJ', 'Item has been registerd into index keyword.');
define('_MD_XOONIPS_ITEM_CERTIFIED_AUTO_NOTIFYSBJ', 'Item has been certified automatically');
define('_MD_XOONIPS_ITEM_CERTIFIED_NOTIFYSBJ', 'Item has been certified');
define('_MD_XOONIPS_ITEM_REJECTED_NOTIFYSBJ', 'Item has been rejected');
define('_MD_XOONIPS_USER_ITEM_TRANSFER_REQUEST_NOTIFYSBJ', 'You are requested to inherit items');
define('_MD_XOONIPS_USER_ITEM_TRANSFER_ACCEPTED_NOTIFYSBJ', 'Your request to transfer items has been accepted');
define('_MD_XOONIPS_USER_ITEM_TRANSFER_REJECTED_NOTIFYSBJ', 'Your request to transfer items has been rejected');
define('_MD_XOONIPS_USER_INDEX_RENAMED_NOTIFYSBJ', 'Your items has been affected(renamed index)');
define('_MD_XOONIPS_USER_INDEX_MOVED_NOTIFYSBJ', 'Your items has been affected(moved index)');
define('_MD_XOONIPS_USER_INDEX_DELETED_NOTIFYSBJ', 'Your items has been affected(moved index)');
define('_MD_XOONIPS_USER_ITEM_CERTIFIED_NOTIFYSBJ', 'Your item has been certified');
define('_MD_XOONIPS_USER_ITEM_REJECTED_NOTIFYSBJ', 'Your item has been rejected');
define('_MD_XOONIPS_USER_FILE_DOWNLOADED_NOTIFYSBJ', 'Your file has been downloaded');

define('_MD_XOONIPS_PUSH_BUTTON_TO_ACTIVATE', 'To activate account, push Activate button.');
define('_MD_XOONIPS_ACTIVATE', 'Activate');

define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_PAGE_TITLE', 'Transfer items');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_ITEM_ID', 'ID');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_ITEM_TYPE', 'Item type');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_TITLE', 'Title');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_UNSELECT', 'Remove');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_SUBMIT', 'Next');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_TO', 'Transferee:');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_LOCK_TYPE_CERTIFY_REQUEST_EXPLANATION', 'Can not transfer because it is locked by certify request.');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_LOCK_TYPE_TRANSFER_REQUEST_EXPLANATION', 'Can not transfer because it is locked by transfer request.');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_CAN_NOT_TRANSFER_THIS_ITEM_HAVE_ANOTHER_PARENT', "Can not transfer this item because it's referred from other items.");
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_NO_TRANSFER_ITEMS', 'No items selected');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_PAGE_DESCRIPTION', 'Select items to transfer and transferee user');

define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_PAGE_TITLE', 'Transfer items');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_ITEM_ID', 'ID');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_ITEM_TYPE', 'Item type');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_TITLE', 'Title');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_BACK', 'Back to previous page');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_SUBMIT', 'execute transfer');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_USER_IS_NOT_SUBSCRIBED_TO_GROUPS', 'Can not transfer because transferee %s is not subscribed to group %s.');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_TO', 'Transferee:');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_PAGE_DESCRIPTION', 'Would you like to transfer the following items ?');
define('_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_NO_TRANSFER_ITEMS', 'No items selected');

define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_PAGE_TITLE', 'Transfer confirmation');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_LIMIT_CHECK_OUT_OF_BOUNDS', 'Can not transfer items because number of items or storage size of transferee is out of bounds.');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_ITEM_ID', 'ID');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_ITEM_TYPE', 'Item type');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_OWNER', 'Owner');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_TITLE', 'Title');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_TO_INDEX', 'Index transfer to:');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_ACCEPT', 'Accept');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_REJECT', 'Reject');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_BACK_TO_TOP', 'Back to top');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_NO_TRANSFER_ITEMS', 'No transfer request');

define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_DETAIL_PAGE_TITLE', 'Detail of transfer item');
define('_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_DETAIL_CLOSE', 'Close');

define('_MD_XOONIPS_TRANSFER_NOTIFICATION_ITEM_TITLE', 'Title:');
define('_MD_XOONIPS_TRANSFER_NOTIFICATION_ITEM_DETAIL', 'Detail:');
define('_MD_XOONIPS_TRANSFER_NOTIFICATION_ITEM_DETAIL_FORBIDDEN', 'Access forbidden. This is private item.');

define('_MD_XOONIPS_TRANSFER_CHANGE_LOG_AUTOFILL_TEXT', 'Modified; owner from %s to %s.');

define('_MD_XOONIPS_TRANSFER_USER_ACCEPT_COMPLETE', 'Accept transfer item completed.');
define('_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR', 'Failed in accept transfer item');
define('_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR_BAD_SUBSCRIBE_GROUP', 'Transferee is not subscribed groups.');
define('_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR_NUMBER_OR_STORAGE_EXCEED', 'Can not transfer items because number of items or storage size exceeds.');
define('_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR_NO_ITEM', 'No transfer request');
define('_MD_XOONIPS_TRANSFER_USER_REJECT_COMPLETE', 'Reject transfer item completed');
define('_MD_XOONIPS_TRANSFER_USER_REJECT_ERROR', 'Failed in reject transfer item');
define('_MD_XOONIPS_TRANSFER_USER_REJECT_ERROR_NO_ITEM', 'No transfer request');
define('_MD_XOONIPS_TRANSFER_USER_REQUEST_COMPLETE', 'Request for transfer is finished. To complete transfer accept by transferee is needed.');
define('_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR', 'Failed in request transfer item');
define('_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR_BAD_SUBSCRIBE_GROUP', "Transferee is not subscribed to group '%s'.");
define('_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR_NO_TRANSFEREE_USER', 'Cannot transfer items because there is only 1 user');
define('_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR_NO_ITEMTYPE', 'No item type modules installed');
define('_MD_XOONIPS_TRANSFER_USER_LIST_ITEM_ERROR_BAD_SUBSCRIBE_GROUP_NAME', "Can not transfer items because you are not subscribed to group '%s'.");
define('_MD_XOONIPS_TRANSFER_USER_CAN_NOT_TRANSFER_ITEM', 'Can not transfer selected items.');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_JPN', 'Japanese');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_ENG', 'English');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_FRA', 'French');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_DEU', 'German');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_ESL', 'Spanish');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_ITA', 'Italian');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_DUT', 'Dutch');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_SVE', 'Swedish');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_NOR', 'Norwegian');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_DAN', 'Danish');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_FIN', 'Finnish');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_POR', 'Portuguese');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_CHI', 'Chinese');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_KOR', 'Korean');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_ITEM_ID', 'Item ID');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_ITEMTYPE', 'Item type ID');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_USERNAME', 'Contributor');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_TITLES', 'Title');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_KEYWORDS', 'Free Keywords');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_DESCRIPTION', 'Description');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_EXT_ID', 'ID');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LAST_MODIFIED_DATE', 'Last Modified Date');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_REGISTRATION_DATE', 'Created Date');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_CREATION_YEAR', 'Date(Year)');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_CREATION_MONTH', 'Date(Month)');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_CREATION_MDAY', 'Date(Day)');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG', 'Language');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_URL', 'URL');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_INDEXES', 'Index');
define('_MD_XOONIPS_XMLRPC_DISPLAY_NAME_RELATED_TO', 'Related to');

define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_PAGE_TITLE', 'Metadata Search');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_REPOSITORY_COUNT', 'Repositories: ');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_METADATA_COUNT', 'Metadata: ');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_REPOSITORY_NAME', 'Repository name');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_REPOSITORY_NOT_SPECIFIED', '(None)');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_KEYWORD', 'Keyword');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_SUBMIT', 'Search');
define('_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_ILLEGAL_CONDITION', 'Repository name or Keyword is required.');

define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_PAGE_TITLE', 'Metadata Search Result');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_TITLE', 'Title');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_REPOSITORY_NAME', 'Repository name');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_ID', 'ID');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_LAST_UPDATE_DATE', 'Last update date');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_CREATION_DATE', 'Created date');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_DATE', 'Date');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_LINK', 'Resource link');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_ORDER_BY', 'Order by: ');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_TITLE_LABEL', 'Title');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_IDENTIFIER_LABEL', 'ID');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_LAST_UPDATE_DATE_LABEL', 'Last update date');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_CREATION_DATE_LABEL', 'Created date');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_DATE_LABEL', 'Date');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_ASC_LABEL', 'Ascend');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_DESC_LABEL', 'Descend');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_NUM_OF_METADATA_PER_PAGE', 'Number of Metadata per Page: ');
define('_MD_XOONIPS_OAIPMH_SEARCH_RESULT_BACK', 'Search other conditions');
define('_MD_XOONIPS_OAMPMH_SEARCH_RESULT_PAGENAVI_PREV', 'PREV');
define('_MD_XOONIPS_OAMPMH_SEARCH_RESULT_PAGENAVI_NEXT', 'NEXT');

define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_PAGE_TITLE', 'Metadata detail');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_TITLE', 'Title');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_REPOSITORY_NAME', 'Repository name');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_ID', 'ID');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_LAST_UPDATE_DATE', 'Last update date');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_CREATION_DATE', 'Created date');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_DATE', 'Date');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_CREATOR', 'Creator');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_RESOURCE_LINK', 'Resource link');
define('_MD_XOONIPS_OAIPMH_METADATA_DETAIL_BACK', 'Back');

// breadcrumbs
define('_MD_XOONIPS_BREADCRUMBS_USER', 'User');
define('_MD_XOONIPS_BREADCRUMBS_GROUPADMIN', 'Group Admin');
define('_MD_XOONIPS_BREADCRUMBS_MODERATOR', 'Moderator');
// - event_log.php
define('_MD_XOONIPS_BREADCRUMBS_EVENTLOG', 'Event Logs');
define('_MD_XOONIPS_BREADCRUMBS_EVENTLOG_GRAPH', 'Graph');
define('_MD_XOONIPS_BREADCRUMBS_EVENTLOG_LIST', 'List');

//// 200801 add ////
define('_MD_XOONIPS_HEADER_GROUP_CERTIFY_ITEMS', 'Please certify the following group items.');
define('_MD_XOONIPS_ITEM_GROUP_CERTIFY_ITEM_TITLE', 'Certify group item');
define('_MD_XOONIPS_ITEM_GROUP_INDEX_LABEL', 'group<BR>index');
define('_MD_XOONIPS_ITEM_GROUP_INDEX_TO_PUBLIC', 'Publication group item');
define('_MD_XOONIPS_ITEM_NO_GROUP_CERTIFY_ITEMS', 'No request group items found.');
define('_MD_XOONIPS_CREATE_GROUP_TREE_TO_PUBLIC_INDEX_TREE_FAILED', 'Create index tree failed.');
define('_MD_XOONIPS_GROUP_TREE_TO_PUBLIC_INDEX_TREE_FAILED', 'Publication group item failed');
define('_MI_XOONIPS_ITEM_PANKUZU_CERTIFY_GROUP_PUBLIC_ITEMS', 'Group Item Certification');

define('_MD_XOONIPS_MULTIPLE_FIELD_ADD_LABEL', 'Add');
