<?php

// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2011 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

class OaidcListRecordsHandler extends ListRecordsHandler
{
    public function __construct($_parser, $_baseURL)
    {
        parent::__construct($_parser, $_baseURL, 'oai_dc');
    }

    public function startElementHandler($parser, $name, $attrs)
    {
        if ('DC' == $this->getElementName($name)) {
            $this->_namespaces = $this->getNamespaceArray($attrs);
            array_push($this->tagstack, $name);
        } else {
            parent::startElementHandler($parser, $name, $attrs);
        }
    }

    public function endElementHandler($parser, $name)
    {
        $support_tags = array(
            'SUBJECT',
            'DESCRIPTION',
            'PUBLISHER',
            'CONTRIBUTOR',
            'DATE',
            'TYPE',
            'FORMAT',
            'IDENTIFIER',
            'SOURCE',
            'LANGUAGE',
            'RELATION',
            'COVERAGE',
            'RIGHTS',
        );
        if (isset($this->tagstack[3]) && 'HEADER' == $this->getElementName($this->tagstack[3]) || !in_array($this->getElementName(end($this->tagstack)), $support_tags)
        ) {
            parent::endElementHandler($parser, $name);
        } elseif ('DATE' == $this->getElementName(end($this->tagstack))) {
            $this->_creation_date = $this->_cdata_buf;
            $this->search_text[] = $this->_cdata_buf;
            $this->addMetadataField(end($this->tagstack), $this->_cdata_buf, XOONIPS_METADATA_CATEGORY_CREATION_DATE);
            array_pop($this->tagstack);
        } elseif ('IDENTIFIER' == $this->getElementName(end($this->tagstack))) {
            $result = preg_match('/^(s?https?:\\/\\/'."[-_.!~*'\\(\\)a-zA-Z0-9;\\/?:\\@&=+\$,%#]+)/", $this->_cdata_buf);
            if (1 == $result) {
                $this->_resource_url[] = $this->_cdata_buf;
                $this->addMetadataField(end($this->tagstack), $this->_cdata_buf, XOONIPS_METADATA_CATEGORY_RESOURCE_LINK);
            } else {
                $this->addMetadataField(end($this->tagstack), $this->_cdata_buf);
            }
            array_pop($this->tagstack);
        } else {
            $this->addMetadataField(end($this->tagstack), $this->_cdata_buf);
            array_pop($this->tagstack);
        }
    }
}
