<?php
// $Revision: 1.1.2.7 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
/**
 * constant strings
 * $Revision: 1.1.2.7 $
 */

// _MD_<MODULENAME>_<STRINGNAME>

// font
define( '_MD_XOONIPS_FONT_LANGUAGE', 'japanese' );

// labels
define( '_MD_XOONIPS_LABEL_HOME', 'ホーム' );
define( '_MD_XOONIPS_LABEL_ADD', '追加' );
define( '_MD_XOONIPS_LABEL_MODIFY', '編集' );
define( '_MD_XOONIPS_LABEL_DELETE', '削除' );
define( '_MD_XOONIPS_LABEL_UPDATE', '更新' );
define( '_MD_XOONIPS_LABEL_UPLOAD', 'アップロード' );
define( '_MD_XOONIPS_LABEL_NEXT', '次へ' );
define( '_MD_XOONIPS_LABEL_BACK', '戻る' );
define( '_MD_XOONIPS_LABEL_CANCEL', 'キャンセル' );
define( '_MD_XOONIPS_LABEL_SUBMIT', '送信' );
define( '_MD_XOONIPS_LABEL_ACTION', '操作' );
define( '_MD_XOONIPS_LABEL_WEIGHT', '並び順' );

define( '_MD_XOONIPS_LABEL_ITEM_NUMBER_LIMIT', '登録可能なアイテムの最大個数' );
define( '_MD_XOONIPS_LABEL_INDEX_NUMBER_LIMIT', '登録可能なインデックスの最大個数' );
define( '_MD_XOONIPS_LABEL_ITEM_STORAGE_LIMIT', '登録可能なアイテムの最大ディスク容量[MB]' );

define( '_MD_XOONIPS_LABEL_GROUP_NAME', 'グループ名' );
define( '_MD_XOONIPS_LABEL_GROUP_DESCRIPTION', 'グループ詳細' );
define( '_MD_XOONIPS_LABEL_GROUP_ADMINISTRATORS', 'グループ管理者' );
define( '_MD_XOONIPS_LABEL_GROUP_MEMBERS', 'グループメンバー' );
define( '_MD_XOONIPS_LABEL_GROUP_NUM_OF_ITEMS', '共有アイテム数' );

define( "_MD_XOONIPS_ITEM_LISTING_ITEM", "アイテム一覧" );
define( "_MD_XOONIPS_ITEM_ORDER_BY", "並び順 : " );
define( "_MD_XOONIPS_ITEM_NUM_OF_ITEM_PER_PAGE", "No.Item per page" );
define( "_MD_XOONIPS_ITEM_SELECT_ITEM_TYPE_LABEL", "アイテムタイプ選択" );
define( "_MD_XOONIPS_ITEM_ADD_ITEM_BUTTON_LABEL", "アイテム追加" );
define( "_MD_XOONIPS_ITEM_EDIT_INDEX_BUTTON_LABEL", "インデックス編集" );
define( "_MD_XOONIPS_ITEM_SEARCH_RESULT", "検索結果" );
define( "_MD_XOONIPS_ITEM_SEARCH_KEYWORD", "検索キーワード" );
define( "_MD_XOONIPS_ITEM_SEARCH_ITEMTYPE", "検索対象" );
define( "_MD_XOONIPS_ITEM_SEARCH_TAB_ITEM", "アイテム" );
define( "_MD_XOONIPS_ITEM_SEARCH_TAB_METADATA", "メタデータ" );
define( "_MD_XOONIPS_ITEM_SEARCH_TAB_FILE", "ファイル" );
define( "_MD_XOONIPS_ITEM_NO_ITEM_LISTED", "このインデックスにはアイテムが登録されていません" );

define( "_MD_XOONIPS_ITEM_DETAIL_ITEM_TITLE", "詳細" );
define( "_MD_XOONIPS_ITEM_MODIFY_ITEM_TITLE", "編集" );
define( "_MD_XOONIPS_ITEM_MODIFY_ITEM_CONFIRM", "編集" );
define( "_MD_XOONIPS_ITEM_MODIFY_ITEM_CONFIRM_MESSAGE", "" );
define( "_MD_XOONIPS_ITEM_REGISTER_ITEM_TITLE", "登録" );
define( "_MD_XOONIPS_ITEM_REGISTER_ITEM_CONFIRM", "登録" );
define( "_MD_XOONIPS_ITEM_REGISTER_ITEM_CONFIRM_MESSAGE", "" );

define( "_MD_XOONIPS_ITEM_PRINT_FRIENDLY_BUTTON_LABEL", "印刷" );
define( "_MD_XOONIPS_ITEM_UPDATE_BUTTON_LABEL", "更新" );
define( "_MD_XOONIPS_ITEM_DELETE_BUTTON_LABEL", "削除" );
define( "_MD_XOONIPS_ITEM_REGISTER_BUTTON_LABEL", "登録" );
define( "_MD_XOONIPS_ITEM_MODIFY_BUTTON_LABEL", "編集" );
define( "_MD_XOONIPS_ITEM_NEXT_BUTTON_LABEL", "次へ" );
define( "_MD_XOONIPS_ITEM_BACK_BUTTON_LABEL", "戻る" );

define( "_MD_XOONIPS_ITEM_CERTIFY_ITEM_TITLE", "アイテム承認" );
define( "_MD_XOONIPS_ITEM_CERTIFY_BUTTON_LABEL", "Accept" );
define( "_MD_XOONIPS_ITEM_UNCERTIFY_BUTTON_LABEL", "Reject" );
define( "_MD_XOONIPS_ITEM_WITHDRAW_BUTTON_LABEL", "Withdraw" );

define( "_MD_XOONIPS_ITEM_ITEM_LABEL", "アイテム" );
define( "_MD_XOONIPS_ITEM_INDEX_LABEL", "インデックス" );

define( "_MD_XOONIPS_ITEM_SELECT_INDEX_LABEL", "インデックス：" );
define( "_MD_XOONIPS_ITEM_SELECT_BUTTON_LABEL", "選択する" );
define( "_MD_XOONIPS_ITEM_SELECT_CANCEL_BUTTON_LABEL", "選択しないで戻る" );
define( "_MD_XOONIPS_ITEM_SELECT_NONE_LABEL", "なし" );

define( "_MD_XOONIPS_ITEM_README_LABEL", "Readme" );
define( "_MD_XOONIPS_ITEM_LICENSE_LABEL", "License" );
define( "_MD_XOONIPS_ITEM_RIGHTS_LABEL", "Rights" );
define( "_MD_XOONIPS_ITEM_PREVIEW_LABEL", "プレビュー" );
define( "_MD_XOONIPS_ITEM_CAPTION_LABEL", "プレビューのキャプション" );
define( "_MD_XOONIPS_ITEM_ATTACHMENT_LABEL", "添付ファイル" );
define( "_MD_XOONIPS_ITEM_TEXTFILE_LABEL", "テキストファイル" );
define( "_MD_XOONIPS_ITEM_FILE_HEAD_LABEL", "ファイル：" );
define( "_MD_XOONIPS_ITEM_CAPTION_HEAD_LABEL", "キャプション：" );
define( "_MD_XOONIPS_ITEM_ORIGINAL_FILE_NAME_LABEL", "元ファイル名" );
define( "_MD_XOONIPS_ITEM_MIME_TYPE_LABEL", "Mime-type" );
define( "_MD_XOONIPS_ITEM_TYPE_LABEL", "Type" );
define( "_MD_XOONIPS_ITEM_SIZE_LABEL", "Size" );
define( "_MD_XOONIPS_ITEM_LAST_UPDATED_LABEL", "Last updated" );
define( "_MD_XOONIPS_ITEM_DOWNLOAD_LABEL", "Download" );
define( "_MD_XOONIPS_ITEM_DOWNLOAD_COUNT_LABEL", "Downloads" );
define( "_MD_XOONIPS_ITEM_TOTAL_DOWNLOAD_COUNT_SINCE_LABEL", "Total downloads since " );

define( "_MD_XOONIPS_ITEM_TEXT_FILE_EDIT_LABEL", "編集" );
define( "_MD_XOONIPS_ITEM_UPLOAD_LABEL", "更新" );
define( "_MD_XOONIPS_ITEM_OK_LABEL", "OK" );
define( "_MD_XOONIPS_ITEM_CANCEL_LABEL", "キャンセル" );

define( "_MD_XOONIPS_ITEM_FROM_LABEL", "From" );
define( "_MD_XOONIPS_ITEM_TO_LABEL", "To" );

define( "_MD_XOONIPS_ITEM_TITLE_REQUIRED", "'タイトル' を入力して下さい．" );
define( "_MD_XOONIPS_ITEM_UPLOAD_PREVIEW", "先にUploadボタンを押して、プレビューファイル '%s' をアップロードしてください．" );

define( "_MD_XOONIPS_ITEM_REQUIRED_MARK", "<span style=\"color: red;\">*</span>" );
define( "_MD_XOONIPS_ITEM_DOWNLOAD_CONFIRMATION", "このファイルのライセンス文に合意しますか？" );

define( "_MD_XOONIPS_ADD_TO_PUBLIC_EXPLANATION", "公開領域へ追加<br />" );
define( "_MD_XOONIPS_ADD_TO_PUBLIC_LABEL", "追加" );

define( '_MD_XOONIPS_ITEM_VIEWED_COUNT_LABEL', '閲覧数' );

//Basic Information field name
define( "_MD_XOONIPS_ITEM_TITLE_LABEL", "タイトル" );
define( "_MD_XOONIPS_ITEM_KEYWORDS_LABEL", "フリーキーワード" );
define( "_MD_XOONIPS_ITEM_DESCRIPTION_LABEL", "概要" );
define( "_MD_XOONIPS_ITEM_DOI_LABEL", "ID" );
define( "_MD_XOONIPS_ITEM_ITEM_TYPE_LABEL", "アイテムタイプ" );
define( "_MD_XOONIPS_ITEM_CREATION_DATE_LABEL", "作成日" );
define( "_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL", "最終更新日" );
define( "_MD_XOONIPS_ITEM_CHANGELOG_LABEL", "変更内容" );
define( "_MD_XOONIPS_ITEM_CHANGELOGS_LABEL", "更新履歴" );
define( "_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL", "登録者" );
define( "_MD_XOONIPS_ITEM_UID_LABEL", "登録者ID" );
define( "_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL", "日付" );
define( "_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL", "年" );
define( "_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL", "月" );
define( "_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL", "日" );

define( "_MD_XOONIPS_ITEM_SELECT_INDEX", "インデックスツリーからインデックスを選択して下さい．" );
define( "_MD_XOONIPS_ITEM_SELECT_PRIVATE_INDEX", "少なくとも 1つのプライベートインデックスをツリーから選択して下さい．" );
define( "_MD_XOONIPS_ITEM_SELECT_PRIVATE_INDEX_AUTO", "プライベートインデックスが指定されなかったので、このアイテムは/Privateに登録されます．" );
define( "_MD_XOONIPS_ITEM_NEED_TO_BE_CERTIFIED", "公開されるためにはモデレータもしくはグループ管理者の承認が必要です．この作業には数日要する場合があります．" );
define( "_MD_XOONIPS_ITEM_FORBIDDEN"    ,"このエリアへのアクセス権がありません．" );
define( "_MD_XOONIPS_ITEM_CANNOT_ACCESS_ITEM"    ,"このアイテムへのアクセス権がありません．" );
define( "_MD_XOONIPS_ITEM_DELETE_CONFIRMATION_MESSAGE", "本当に削除してよろしいですか?" );
define( "_MD_XOONIPS_ITEM_ACCEPT_CERTIFY_CONFIRMATION_MESSAGE", "本当にこのアイテム公開を承認してよろしいですか?" );
define( "_MD_XOONIPS_ITEM_CANCEL_CERTIFY_CONFIRMATION_MESSAGE", "本当にこのアイテム公開を却下してよろしいですか?" );
define( "_MD_XOONIPS_ITEM_WITHDRAW_CONFIRMATION_MESSAGE", "本当にこのアイテム公開を却下してよろしいですか?" );

define( "_MD_XOONIPS_ITEM_NEW_REGISTRATION_ITEMS_MAIL_SUBJECT", "新規に登録されたアイテム" );
define( "_MD_XOONIPS_ITEM_NEW_REGISTRATION_ITEMS_MAIL_BODY", "" );

define( "_MD_XOONIPS_ITEM_DETAIL_URL", "詳細なURL" );
define( "_MD_XOONIPS_ITEM_ADVANCED_SEARCH_TITLE", "アイテム検索" );

define( "_MD_XOONIPS_ITEM_UPLOAD_FILE_TOO_LARGE", "アップロードするファイルが大きすぎます．");
define( "_MD_XOONIPS_ITEM_UPLOAD_FILE_FAILED", "ファイルをアップロードできません．" );
define( "_MD_XOONIPS_ITEM_THUMBNAIL_BAD_FILETYPE", "未対応のファイル形式です．サムネイルが作成できません．" );
define( "_MD_XOONIPS_ITEM_NO_CERTIFY_ITEMS", "新規登録アイテムはありません．" );
define( "_MD_XOONIPS_HEADER_CERTIFY_ITEMS", "以下のアイテムを承認して下さい．" );

define( "_MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT", "これ以上アイテムを登録できません．サイト管理者に連絡して下さい．" );
define( "_MD_XOONIPS_ITEM_WARNING_INDEX_NUMBER_LIMIT", "これ以上インデックスを登録できません．サイト管理者に連絡して下さい．" );
define( "_MD_XOONIPS_ITEM_WARNING_ITEM_STORAGE_LIMIT", "ディスク領域が足りません．これ以上アイテムを登録できません．サイト管理者に連絡して下さい．" );
define( "_MD_XOONIPS_ITEM_WARNING_FIELD_TRIM", "文字数制限のため、赤字で示した部分は切り捨てられます" );

define( "_MD_XOONIPS_ITEM_NUM_OF_ITEM", "アイテム数(登録数/最大数)" );
define( "_MD_XOONIPS_ITEM_STORAGE_OF_ITEM", "添付ファイル容量(使用済/最大)" );

define( "_MD_XOONIPS_ITEM_PANKUZU_ADVANCED_SEARCH", "詳細検索" );
define( "_MD_XOONIPS_ITEM_SEARCH_BUTTON_LABEL", "検索" );
define( "_MD_XOONIPS_ITEM_SEARCH_BACK_BUTTON_LABEL", "戻る" );

define( "_MD_XOONIPS_ITEM_PENDING_NOW", "(Pending)" );

define( "_MD_XOONIPS_ITEM_BAD_FILE", "不正なファイル" );
define( "_MD_XOONIPS_ITEM_BAD_FILE_TYPE", "不正なファイル形式" );
define( "_MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE", "テンポラリファイルを作成できません．" );
define( "_MD_XOONIPS_ITEM_CANNOT_CREATE_ZIP", "ZIPファイルを作成できません．" );
define( "_MD_XOONIPS_ITEM_SEARCH_ERROR", "検索の問い合わせに失敗しました．" );
define( "_MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR", "検索式の文法に誤りがあります．" );

define( '_MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_TEXT', '%s を変更' );
define( '_MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_DELIMITER', ', ' );

//define( '_MD_XOONIPS_ITEM_ASCEND', '&darr;' );
//define( '_MD_XOONIPS_ITEM_DESCEND', '&uarr;' );
define( '_MD_XOONIPS_ITEM_ASCEND', '▼' );
define( '_MD_XOONIPS_ITEM_DESCEND', '▲' );

define( '_MD_XOONIPS_ITEM_RELATED_TO_ADD_ID', '追加する関連アイテムのIDを1行につきひとつ入力してください．' );

define( '_MD_XOONIPS_ITEM_RELATED_TO_EDIT_ID', '削除したい関連アイテムのチェックをOFFにしてください．' );
define( '_MD_XOONIPS_ITEM_RELATED_TO_LEAVE_IT', '関連を残す' );
define( '_MD_XOONIPS_ITEM_RELATED_TO_ITEM_ID', 'アイテムID' );
define( '_MD_XOONIPS_ITEM_RELATED_TO_ITEM_SUMMARY', 'アイテムの概要' );
define( "_MD_XOONIPS_ITEM_RELATED_TO_LABEL", "関連アイテム" );
define( "_MD_XOONIPS_ITEM_RELATED_TO_ADD_ID_BUTTON_LABEL", "アイテムを探す(新しいウィンドウ)" );
define( "_MD_XOONIPS_ITEM_RELATED_TO_DESCRIPTION", "" );
define( "_MD_XOONIPS_ITEM_RELATED_TO_CLOSE_LABEL", "ウィンドウを閉じる" );

define( '_MD_XOONIPS_RIGHTS_SOME_RIGHTS_RESERVED', 'Some rights reserved' );
define( '_MD_XOONIPS_RIGHTS_ALL_RIGHTS_RESERVED', 'All rights reserved' );
define( '_MD_XOONIPS_RIGHTS_ALLOW_COMMERCIAL_USE', 'あなたの作品の営利目的利用を許しますか?' );
define( '_MD_XOONIPS_RIGHTS_ALLOW_MODIFICATIONS', 'あなたの作品の翻案・改変を許しますか?' );
define( '_MD_XOONIPS_RIGHTS_YES_SA', 'はい。ただし、他の人々が同じ条件で共有する場合のみ。' );

/// following defines for moderator 
define("_MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR"    ,"このエリアへのアクセス権限がありません．モデレータ権限が必要になります．" );

// groups
define( '_MD_XOONIPS_TITLE_GROUP_LIST', 'グループ一覧' );
define( '_MD_XOONIPS_TITLE_GROUP_MEMBER_EDIT', 'グループメンバー編集' );
define( '_MD_XOONIPS_TITLE_GROUP_EDIT', 'グループ編集' );
define( '_MD_XOONIPS_TITLE_GROUP_CREATE', 'グループ新規作成' );
define( '_MD_XOONIPS_MSG_GROUP_EMPTY', 'グループが登録されていません' );
define( '_MD_XOONIPS_MSG_GROUP_ENTER_NAME', 'グループ名を入力してください' );
define( '_MD_XOONIPS_MSG_GROUP_ENTER_ADMINS', 'グループ管理者を入力してください' );
define( '_MD_XOONIPS_MSG_GROUP_DELETE_CONFIRM', '本当にこのグループを削除しますか?' );
define( '_MD_XOONIPS_MSG_GROUP_NAME_EXISTS', 'そのグループ名は既に存在します' );
define( '_MD_XOONIPS_MSG_GROUP_NAME_FORBIDDEN', 'そのグループ名は使用できません' );
define( '_MD_XOONIPS_LABEL_GROUPADMIN_MEMBERS', 'メンバー' );
define( '_MD_XOONIPS_LABEL_GROUPADMIN_NONMEMBERS', '非メンバー' );
define( '_MD_XOONIPS_LABEL_GROUPADMIN_ADD', '追加 --&gt;' );
define( '_MD_XOONIPS_LABEL_GROUPADMIN_DELETE', '&lt;-- 削除' );
define( '_MD_XOONIPS_ERROR_GROUP_SELECT', 'グループの取得に失敗しました' );
define( '_MD_XOONIPS_ERROR_GROUP_INSERT', 'グループの登録に失敗しました' );
define( '_MD_XOONIPS_ERROR_GROUP_UPDATE', 'グループの更新に失敗しました' );
define( '_MD_XOONIPS_ERROR_GROUP_DELETE', 'グループの削除に失敗しました' );

// certify.php
define('_MD_XOONIPS_MODERATOR_CERTIFY_USER','ユーザ承認');
define('_MD_XOONIPS_MODERATOR_DETAIL','詳細');
define('_MD_XOONIPS_MODERATOR_CERTIFY','承認');

// certifyuser.php : uncertify_confirm
define('_MD_XOONIPS_MODERATOR_UNCERTIFY','拒否');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_CANCEL_LABEL','中止');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_EXECUTE_LABEL','実行');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_TITLE','ユーザ承認拒否確認');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_DESC','ユーザ登録を拒否します。<br />拒否理由がある場合は以下にその旨を書いてください。');
define('_MD_XOONIPS_MODERATOR_UNCERTIFY_SUCCESS','ユーザ登録の拒否が完了しました。');
define("_MD_XOONIPS_MODERATOR_ERROR_SELECT_USER"    ,"ユーザの指定が不正です" );


define("_MD_XOONIPS_MODERATOR_NOT_ACTIVATED"    ,"承認されていないためアクセスできません．" );
define("_MD_XOONIPS_MODERATOR_NO_CERTIFY_USERS"    ,"承認待ちのユーザはいません．" );

define("_MD_XOONIPS_MODERATOR_PANKUZU_CERTIFY_USERS", "ユーザ承認" );
define("_MD_XOONIPS_USER_CERTIFICATION_SUCCEED", "ユーザを承認しました．" );

/// following defines for index

define( "_MD_XOONIPS_INDEX_NUMBER_OF_PRIVATE_INDEX_LABEL", "プライベートインデックス数" );
define( "_MD_XOONIPS_INDEX_NUMBER_OF_GROUP_INDEX_LABEL", "グループインデックス数" );
define( "_MD_XOONIPS_INDEX_TOO_MANY_INDEXES", "登録可能なインデックス数を超えたため、インデックスを作成できません" );
define( "_MD_XOONIPS_INDEX_NO_INDEX", "サブインデックスキーワードはありません" );

define( "_MD_XOONIPS_INDEX_BUTTON_REGISTER", "登録");// 
define( "_MD_XOONIPS_INDEX_TITLE_EDIT", "インデックスキーワード編集");// 
define( "_MD_XOONIPS_INDEX_TITLE_ADD", "追加");// 
define( "_MD_XOONIPS_INDEX_TITLE_NEW_INDEX_KEYWORD", "New Index Keyword");// 
define( "_MD_XOONIPS_INDEX_TITLE_MODIFY", "編集");// 
define( "_MD_XOONIPS_INDEX_INDEX_KEYWORD", "インデックスキーワード");// 
define( "_MD_XOONIPS_INDEX_RENAME_TO", "Rename to");// 
define( "_MD_XOONIPS_INDEX_LABEL_UPDOWN", "上へ/下へ");// 
define( "_MD_XOONIPS_INDEX_LABEL_UP", "上へ");// 
define( "_MD_XOONIPS_INDEX_LABEL_DOWN", "下へ");// 
define( "_MD_XOONIPS_INDEX_BUTTON_RENAME", "改名");// 
define( "_MD_XOONIPS_INDEX_BUTTON_DELETE", "削除");// 
define( "_MD_XOONIPS_INDEX_BUTTON_MOVETO", "次へ移動 : ");// 
define( "_MD_XOONIPS_INDEX_LABEL_WITH_SELECTED", "With selected:");// 

define( "_MD_XOONIPS_INDEX_PANKUZU_EDIT_PUBLIC_INDEX_KEYWORD", "公開ツリー編集");// 
define( "_MD_XOONIPS_INDEX_PANKUZU_EDIT_GROUP_INDEX_KEYWORD", "グループツリー編集");// 
define( "_MD_XOONIPS_INDEX_PANKUZU_EDIT_PRIVATE_INDEX_KEYWORD", "プライベートツリー編集");// 
define( "_MD_XOONIPS_INDEX_NAME_CANNOT_BE_EMPTY", "インデックスキーワードが空欄です");//
define( "_MD_XOONIPS_INDEX_DESTINATION_HAS_TOO_MANY_INDEXES", "エラー: 宛先のインデックスはインデックス数が多すぎます");//

define( "_MD_XOONIPS_INDEX_RENAME_MESSAGE", "インデックスキーワードの名前が %s から %s に変更されました．これに伴い次のアイテムにも影響がありました :");//
define( "_MD_XOONIPS_INDEX_RENAME_MAIL_SUBJECT", "インデックスキーワードの名前が変更されました．" );
define( "_MD_XOONIPS_INDEX_DELETE_MESSAGE", "インデックスキーワード %s が削除されました．これに伴い次のアイテムにも影響がありました :");//
define( "_MD_XOONIPS_INDEX_DELETE_MAIL_SUBJECT", "インデックスキーワードが削除されました" );
define( "_MD_XOONIPS_INDEX_MOVETO_MESSAGE", "インデックスキーワード %s が %s へ移動されました．これに伴い次のアイテムも影響がありました :");//
define( "_MD_XOONIPS_INDEX_MOVETO_MAIL_SUBJECT", "インデックスキーワードは移動されました．" );
define( "_MD_XOONIPS_INDEX_TITLE_CONFLICT", "インデックス名 '%s' が競合しています．" );
define( "_MD_XOONIPS_INDEX_TITLE_EXCEEDS", "インデックス名が長すぎます" );
define( "_MD_XOONIPS_INDEX_TITLE_EMPTY", "インデックス名を空にすることはできません．" );
define( "_MD_XOONIPS_INDEX_FORBIDDEN", "未登録ユーザなのでインデックスツリーを表示できません．" );
define( "_MD_XOONIPS_INDEX_BAD_MOVE", "不正な操作です．インデックスを移動できません．" );

/// following defines for account

// error labels
define('_MD_XOONIPS_ACCOUNT_BAD_CONFIG','XooNIps の設定が異常です．xoops_xnp_config テーブルに AL_PATH の指定がありません．');
define('_MD_XOONIPS_ACCOUNT_CANNOT_INITIALIZE_AL','Abstract Layer の初期化に失敗しました．');
define('_MD_XOONIPS_ACCOUNT_DSN_EMPTY','xoonips の dsn が設定されていません．');

//labels of register/edit account items
define("_MD_XOONIPS_ACCOUNT_ADDRESS", "住所" );
define("_MD_XOONIPS_ACCOUNT_DIVISION", "所属" );
define("_MD_XOONIPS_ACCOUNT_TEL", "電話番号" );
define("_MD_XOONIPS_ACCOUNT_FAX", "FAX番号" );
define("_MD_XOONIPS_ACCOUNT_COMPANY_NAME", "機関名/大学名/会社名" );
define("_MD_XOONIPS_ACCOUNT_COUNTRY", "国名" );
define("_MD_XOONIPS_ACCOUNT_ZIPCODE", "郵便番号" );
define("_MD_XOONIPS_ACCOUNT_NOTICE_MAIL", "新着メール送信間隔 [日]" );
define("_MD_XOONIPS_ACCOUNT_PRIVATE_ITEM_NUMBER_LIMIT",  "プライベートアイテムの最大登録数" );
define("_MD_XOONIPS_ACCOUNT_PRIVATE_INDEX_NUMBER_LIMIT", "プライベートインデックスの最大登録数" );
define("_MD_XOONIPS_ACCOUNT_PRIVATE_ITEM_STORAGE_LIMIT", "プライベートアイテムの最大ディスク容量 [MB]" );
define("_MD_XOONIPS_ACCOUNT_POSITION", "職名" );
define("_MD_XOONIPS_ACCOUNT_NSRA", "職名は設定されていません" );
define("_MD_XOONIPS_ACCOUNT_NSRID", "職名の設定がありません" );
define("_MD_XOONIPS_ACCOUNT_APPEAL", "自由記述" );
define("_MD_XOONIPS_ACCOUNT_CVITAE", "略歴" );

define("_MD_XOONIPS_ACCOUNT_XNP_USER_INFO", "ユーザ情報" );

define("_MD_XOONIPS_ACCOUNT_NOTICE_MAIL_TOO_LITTLE", "メール送信間隔には 0以上の数値を指定してください．" );
define("_MD_XOONIPS_ACCOUNT_INVALID_SECRETKEY", "不正なシークレットキーです．" );
define("_MD_XOONIPS_ACCOUNT_PUSH_BUTTON_TO_ENTER_USERINFO", "ボタンを押してください．ユーザ登録画面へ進みます．");
define("_MD_XOONIPS_ACCOUNT_INVITATION_SUCCED", "ご紹介ありがとうございました．" );
define("_MD_XOONIPS_ACCOUNT_NOTREGISTERED1", "今すぐ<a href='registeruser.php'>登録</a>しませんか？" );
define("_MD_XOONIPS_ACCOUNT_NOTREGISTERED2", "" );
define("_MD_XOONIPS_ACCOUNT_NOTIFICATIONS", "イベント通知機能" );

// register.php errormessage
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_ADDRESS"     ,"住所"                           . "が長すぎます．全角127文字以下にして下さい．");
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_DIVISION"    ,"所属"                          . "が長すぎます．全角127文字以下にして下さい．");
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_TEL"         ,"電話番号"                          . "が長すぎます．半角32文字以下にして下さい．");
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_COMPANY_NAME","FAX番号"                            . "が長すぎます．半角32文字以下にして下さい．");
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_ZIPCODE"     ,"郵便番号"                          . "が長すぎます．全角127文字以下にして下さい．");
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_COUNTRY"     ,"機関名/大学名/会社名" . "が長すぎます．全角127文字以下にして下さい．");
define("_MD_XOONIPS_ACCOUNT_REG_TOO_LONG_FAX"         ,"国名"                           . "が長すぎます．半角32文字以下にしてください．");
define("_MD_XOONIPS_ACCOUNT_MUST_BE_FILLED_IN", "'%s' を入力してください．" );

define("_MD_XOONIPS_ACCOUNT_INVITE_USER"    ,"ユーザ紹介" );
define("_MD_XOONIPS_ACCOUNT_INVITE_USER_MAIL_SUBJECT"    ,"ご紹介のお知らせ " );

// useradmin.php
define("_MD_XOONIPS_ACCOUNT_CANNOT_ACQUIRE_USER_INFO", "ユーザ情報の取得に失敗しました．" );
define("_MD_XOONIPS_ACCOUNT_CANNOT_UPDATE_USER_INFO" , "ユーザ情報の更新に失敗しました．" );

define("_MD_XOONIPS_ACCOUNT_QUERY_ERROR"    ,"データベースのクエリエラーです．" );

define("_MD_XOONIPS_ACCOUNT_FORBIDDEN"    ,"このエリアへのアクセスは許可されていません．" );

define( "_MD_XOONIPS_ACCOUNT_SELECT_USER", "ユーザ選択" );
define( "_MD_XOONIPS_ACCOUNT_DELETE_USER", "ユーザ削除" );
define( "_MD_XOONIPS_ACCOUNT_PASSWORD_DOESNT_MATCH", "パスワードが一致しません．" );

define( "_MD_XOONIPS_ACCOUNT_PREFERENCE", "一般設定" );

// user.php : delete_confirm
define('_MD_XOONIPS_ACCOUNT_DELETE_CANCEL_LABEL','中止');
define('_MD_XOONIPS_ACCOUNT_DELETE_EXECUTE_LABEL','実行');
define('_MD_XOONIPS_ACCOUNT_DELETE_TITLE','アカウント削除確認');
define('_MD_XOONIPS_ACCOUNT_DELETE_DESC','ユーザアカウントを本当に削除しても良いですか？<br />アカウントを削除した場合、全てのユーザ情報が失われます。');
define('_MD_XOONIPS_ACCOUNT_DELETE_IGNORE_USER','システム管理者、モデレータ、グループ管理者はアカウントを削除することはできません。');
define('_MD_XOONIPS_ACCOUNT_DELETE_ITEM_HANDOVER','公開・グループ共有アイテムを他のユーザに移譲してください');
define('_MD_XOONIPS_ACCOUNT_DELETE_SUCCESS','アカウントを削除しました');

// 
// mesasge for user registration
// 
define("_MD_XOONIPS_ACTIVATE_KEY_SUBJECT", '%sさんのアクティベートキーです' );
define("_MD_XOONIPS_ACTIVATE_BY_USER_CERTIFY_MANUAL", '登録メールアドレス宛にアクティベートキーを送信しました。メールの指示にしたがってアカウントをアクティベートしてください。アクティベートした後は、モデレータによる承認をお待ちください。' );
define("_MD_XOONIPS_ACTIVATE_BY_USER_CERTIFY_AUTO", '登録メールアドレス宛にアクティベートキーを送信しました。メールの指示にしたがってアカウントをアクティベートしてください。' );
define("_MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_MANUAL", 'モデレータへアカウントの承認を申請しました。モデレータの承認をお待ちください。承認完了時にはメールにてお知らせします。' );
define("_MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_MANUAL_MAILNG", 'アカウントの承認を申請するメールをモデレータへ送信できませんでした。管理者およびモデレータに問い合わせてください。');
define("_MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_AUTO", 'アカウントの承認が完了しました。登録時に入力したユーザ名とパスワードでログインしてください。');
define("_MD_XOONIPS_ACTIVATE_BY_ADMIN_CERTIFY_AUTO", '登録が完了しました。サイト管理者のアクティベートをお待ちください。アクティベート完了時にはメールにてお知らせします。');
define("_MD_XOONIPS_ACTIVATE_BY_ADMIN_CERTIFY_MANUAL", '登録が完了しました。サイト管理者のアクティベートと、モデレータの承認をお待ちください。承認完了時にはメールにてお知らせします。');
define("_MD_XOONIPS_ACTIVATE_BY_ADMIN_MAILNG", 'サイト管理者にアクティベートの要求メールを送信できませんでした。サイト管理者に問い合わせてください。' );

define("_MD_XOONIPS_ACTIVATED_BY_USER_CERTIFIED_AUTO", 'アカウントを承認しました。登録時のユーザ名とパスワードでログインしてください。');
define("_MD_XOONIPS_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO", 'アカウントをアクティベートしました。登録時のメールアドレスに通知メールを送信しました。');
define("_MD_XOONIPS_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO_MAILNG", 'アカウントをアクティベートしましたが、登録時のメールアドレスに通知メールを送信できませんでした。');
define("_MD_XOONIPS_ACTIVATED_BY_USER_AND_CERTIFY_MANUAL", 'アカウントをアクティベートしました。アカウントがモデレータに承認されるまでお待ちください。');
define("_MD_XOONIPS_ACTIVATED_BY_ADMIN_AND_CERTIFY_MANUAL", 'アカウントをアクティベートしました。モデレータがアカウント承認した後、登録メールアドレスに通知されます。');
define("_MD_XOONIPS_ACTIVATED_BY_USER_AND_CERTIFY_MANUAL_MAILNG", 'アカウントの承認を申請するメールをモデレータへ送信できませんでした。管理者およびモデレータに問い合わせてください。');
define("_MD_XOONIPS_ACTIVATED_BY_ADMIN_AND_CERTIFY_MANUAL_MAILNG", 'アカウントの承認を申請するメールをモデレータへ送信できませんでした。');

define("_MD_XOONIPS_ACCOUNT_NOT_ACTIVATED", 'モデレータの承認が完了していないため、XooNIpsを利用できません。モデレータの承認をお待ちください。承認完了時にはメールにてお知らせします。' );
define("_MD_XOONIPS_USER_ACTIVATED", 'アカウントはアクティベートされました。モデレータによる承認をお待ちください。');
define("_MD_XOONIPS_USER_NOACTTPADM", 'アカウントのアクティベート、またはモデレータの承認が完了していないため、XooNIpsを利用できません。');
define("_MD_XOONIPS_ACCOUNT_ALREADY_CERTIFIED", "既に承認されています" );
define("_MD_XOONIPS_ACCOUNT_ACTIVATE_NG", "アカウントをアクティベートできませんでした。管理者およびモデレータに問い合わせてください。" );

//subjects for e-mail of user registration
define("_MD_XOONIPS_ACCOUNT_CERTIFIED", 'アカウントの承認が完了しました。' );
define('_MD_XOONIPS_ACCOUNT_REGISTERD','ユーザを承認してください');


// admin/config.php
define("_MD_XOONIPS_ACCOUNT_CONFIG", "サイト動作設定");

define("_MD_XOONIPS_ACCOUNT_AMAZON_ASSOCIATES_ID_TITLE"   , 'AmazonアソシエイトID' );

define( "_MD_XOONIPS_ACCOUNT_REQUIRED_MARK", "(*)" );
define( "_MD_XOONIPS_ACCOUNT_EXPLAIN_REQUIRED_MARK", "(*) = 必須" );

// event_log.php
define( '_MD_XOONIPS_EVENTLOG_DOWNLOAD_TITLE', 'イベントログダウンロード' );
define( '_MD_XOONIPS_EVENTLOG_DOWNLOAD_DESC1', '以下で指定された期間のログを出力します:' );
define( '_MD_XOONIPS_EVENTLOG_DOWNLOAD_DESC2', 'のイベントログを' );
define( '_MD_XOONIPS_EVENTLOG_DATE_FROM_PREFIX', '' );
define( '_MD_XOONIPS_EVENTLOG_DATE_TO_PREFIX', '' );
define( '_MD_XOONIPS_EVENTLOG_DATE_YEAR_PREFIX', '' );
define( '_MD_XOONIPS_EVENTLOG_DATE_YEAR_POSTFIX', '年' );
define( '_MD_XOONIPS_EVENTLOG_DATE_MONTH_PREFIX', '' );
define( '_MD_XOONIPS_EVENTLOG_DATE_MONTH_POSTFIX', '月' );
define( '_MD_XOONIPS_EVENTLOG_DATE_DAY_PREFIX', '' );
define( '_MD_XOONIPS_EVENTLOG_DATE_DAY_POSTFIX', '日' );
define( '_MD_XOONIPS_EVENTLOG_DATE_TILDA', ' 〜 ' );
define( "_MD_XOONIPS_EVENTLOG_CATEGORY_TITLE", "イベント別" );
define( "_MD_XOONIPS_EVENTLOG_CATEGORY_DESC", "確認したいログの期間を選び，ダウンロードまたはグラフをクリックしてください" );
define( "_MD_XOONIPS_EVENTLOG_DOWNLOAD", "ダウンロード" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP", "トップページのアクセス回数" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM", "アイテムへのアクセス回数" );
define( "_MD_XOONIPS_EVENTLOG_DOWNLOAD_ITEM", "アイテムのダウンロード数" );
define( "_MD_XOONIPS_EVENTLOG_ADD", "新規登録ユーザ及び新規登録アイテム" );
define( "_MD_XOONIPS_EVENTLOG_GRAPH", "グラフ" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_LABEL", "アクセス" );
define( "_MD_XOONIPS_EVENTLOG_DL_LABEL", "ダウンロード" );
define( "_MD_XOONIPS_EVENTLOG_NEW_USER_LABEL", "ユーザ" );
define( "_MD_XOONIPS_EVENTLOG_NEW_ITEM_LABEL", "アイテム" );
define( "_MD_XOONIPS_EVENTLOG_DAYS_LABEL", "日" );
define( "_MD_XOONIPS_EVENTLOG_MONTHS_LABEL", "月" );
define( "_MD_XOONIPS_EVENTLOG_TOTAL_LABEL", "累計" );
define( "_MD_XOONIPS_EVENTLOG_DOMAINS_LABEL", "ドメイン" );
define( "_MD_XOONIPS_EVENTLOG_PER_ITEM_LABEL", "アイテム別" );
define( "_MD_XOONIPS_EVENTLOG_PER_USER_LABEL", "ユーザ別" );
define( "_MD_XOONIPS_EVENTLOG_PER_FILE_LABEL", "ファイル別" );
define( "_MD_XOONIPS_EVENTLOG_LIST_LABEL", "リスト表示" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_TITLE", "登録状況確認" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_DESCRIPTION", "ユーザおよびアイテムの登録状況を確認するには，ダウンロードまたはリスト表示をクリックしてください" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_LIST_TITLE", "ユーザ及びアイテム一覧" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_USER_TITLE", "登録ユーザ一覧" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_USER_PER_PAGE_LABEL", "User per page" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_ITEM_TITLE", "登録アイテム一覧" );
define( "_MD_XOONIPS_EVENTLOG_VIEW_ITEM_PER_PAGE_LABEL", "Item per page" );
define( '_MD_XOONIPS_EVENTLOG_EVENT_TYPES','dummy,Login Failure,Login Success,Logout,Insert Item,Update Item,Delete Item,View Item,Download File,Request To Certify Item,Insert Index,Update Index,Delete Index,Certify Item,Reject Item,Request To Insert Account,Certify Account,Insert Group,Update Group,Delete Group,Insert Group Member,Delete Group Member,View Top Page,Quick Search,Advanced Search,Start SU,End SU' );
define( '_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS','Event Type,Timestamp,Exec UID,Remote Host,Index ID,Item ID,File ID,UID,GID,Search Keyword,Login Name,Additional Information' );
// - for CSV files
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DATE", "Date,Count" );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DOMAINS", "Remote host,Count" );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DL_PER_ITEM", "Item id,Title,Contributor,Item type," );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DL_PER_FILE", "File id,File name,Title,Contributor,Item type," );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_DL_PER_USER", "User," );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_ACCESS_ITEM", "Item id,Title,Contributor,Item type," );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_ACCESS_USER", "User,Title,Item type," );
define( "_MD_XOONIPS_EVENTLOG_EVENT_COLUMNS_TOTAL", "Total" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DAYS_LABEL", "Access to top page (Days)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_MONTHS_LABEL", "Access to top page (Months)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_TOTAL_LABEL", "Access to top page (Total)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DOMAINS_LABEL", "Access to top page (Domains)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DAYS_LABEL", "Access to items (Days)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_MONTHS_LABEL", "Access to items (Months)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_TOTAL_LABEL", "Access to items (Total)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DOMAINS_LABEL", "Access to items (Domains)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_PER_ITEM_LABEL", "Access to items (per item)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_PER_USER_LABEL", "Access to items (per user)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_DAYS_LABEL", "Download items (Days)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_MONTHS_LABEL", "Download items (Months)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_TOTAL_LABEL", "Download items (Total)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_DOMAINS_LABEL", "Download items (Domains)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_PER_ITEM_LABEL", "Download items (per item)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_PER_FILE_LABEL", "Download items (per file)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_PER_USER_LABEL", "Download items (per user)" );
define( "_MD_XOONIPS_EVENTLOG_NEW_USERS_LABEL", "New users (Months)" );
define( "_MD_XOONIPS_EVENTLOG_NEW_ITEMS_LABEL", "New items (Months)" );
// - for graphs
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DAYS_TITLE", "トップページへのアクセス回数 (日計)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DAYS_TITLE", "アイテムへのアクセス回数 (日計)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_DAYS_TITLE", "アイテムダウンロード数 (日計)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_MONTHS_TITLE", "トップページへのアクセス回数 (月別)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_MONTHS_TITLE", "アイテムへのアクセス回数 (月別)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_MONTHS_TITLE", "アイテムダウンロード数 (月別)" );
define( "_MD_XOONIPS_EVENTLOG_NEW_USER_MONTHS_TITLE", "新規登録ユーザ数 (月別)" );
define( "_MD_XOONIPS_EVENTLOG_NEW_ITEM_MONTHS_TITLE", "新規登録アイテム数 (月別)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DAYS_TOTAL_TITLE", "トップページへのアクセス回数 (累計)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DAYS_TOTAL_TITLE", "アイテムへのアクセス回数 (累計)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_DAYS_TOTAL_TITLE", "アイテムダウンロード数 (累計)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_TOP_DOMAINS_TITLE", "トップページへのアクセス回数 (ドメイン別)" );
define( "_MD_XOONIPS_EVENTLOG_ACCESS_ITEM_DOMAINS_TITLE", "アイテムへのアクセス回数 (ドメイン別)" );
define( "_MD_XOONIPS_EVENTLOG_DL_ITEM_DOMAINS_TITLE", "アイテムダウンロード数 (ドメイン別)" );

//pankuzu
define( '_MI_XOONIPS_ACCOUNT_PANKUZU_PLATFORM_USER', 'ユーザ管理' );
define( '_MI_XOONIPS_ACCOUNT_PANKUZU_GROUP_ADMINISTRATOR', 'グループ管理' );
define( '_MI_XOONIPS_ACCOUNT_PANKUZU_MODERATOR', 'モデレータ' );
define( '_MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR', '&nbsp;&raquo;&raquo;&nbsp;' );
define( '_MI_XOONIPS_ITEM_PANKUZU_CERTIFY_PUBLIC_ITEMS', '公開アイテム承認' );
define( '_MI_XOONIPS_ITEM_PANKUZU_CERTIFY_GROUP_ITEMS', 'グループ公開アイテム承認' );
define( '_MI_XOONIPS_ITEM_PANKUZU_EDIT_ACCOUNT', 'プロフィールの編集' );
define( '_MI_XOONIPS_ITEM_PANKUZU_VIEW_ACCOUNT', 'アカウント情報' );
define( '_MI_XOONIPS_ITEM_PANKUZU_EDIT_CURRICULUM_VITAE', '略歴の編集' );

//export/import
define( '_MD_XOONIPS_EXPORT_PANKUZU_EXPORT', 'エクスポート' );
define( '_MD_XOONIPS_EXPORT_PANKUZU_EXPORT_CONFIG', 'エクスポート設定' );
define( '_MD_XOONIPS_EXPORT_PANKUZU_EXPORT_LICENSE', '利用規約(ライセンス)' );
define( '_MD_XOONIPS_EXPORT_PANKUZU_EXPORT_INDEX', 'インデックスをエクスポート' );
define( '_MD_XOONIPS_EXPORT_CONFIG_TITLE', 'エクスポート設定' );
define( '_MD_XOONIPS_EXPORT_CONFIG_SUBMIT', '次へ' );
define( '_MD_XOONIPS_EXPORT_RECURSIVE', 'インデックスを再帰的にエクスポートする' );
define( '_MD_XOONIPS_EXPORT_ATTACHMENT', '添付ファイルをエクスポートする' );
define( '_MD_XOONIPS_EXPORT_BUTTON_LABEL', 'エクスポート' );
define( '_MD_XOONIPS_EXPORT_EXPORT_LICENSE', '利用規約(ライセンス)' );
define( '_MD_XOONIPS_EXPORT_LICENSE', 'ライセンス' );
define( '_MD_XOONIPS_EXPORT_ACCEPT', '合意する' );
define( '_MD_XOONIPS_EXPORT_CANNOT_BE_EXPORTED_ITEMS', '以下のアイテムはエクスポートできません' );
define( '_MD_XOONIPS_EXPORT_NO_ITEMS_FOUND', '該当するアイテムはありません．' );
define( '_MD_XOONIPS_EXPORT_ACCEPT_ALL', 'すべてのライセンスに合意する' );
define( '_MD_XOONIPS_EXPORT_EXPORT_ITEMS_EMPTY', 'Exportするアイテムが選択されていません．' );
define( '_MD_XOONIPS_EXPORT_LICENSE_AGREEMENT_SUBMIT', 'ダウンロード' );
define( '_MD_XOONIPS_EXPORT_EXPORT_INDEX', '以下の設定でインデックスをエクスポートします' );
define( '_MD_XOONIPS_EXPORT_TYPE_ITEM', 'アイテムをエクスポートする' );
define( '_MD_XOONIPS_EXPORT_TYPE_INDEX', 'インデックスツリーをエクスポートする' );
define( '_MD_XOONIPS_IMPORT_TITLE', 'インポート' );
define( '_MD_XOONIPS_IMPORT_FILE', 'Importするファイル' );
define( '_MD_XOONIPS_IMPORT_INDEX', 'Import先インデックス' );
define( '_MD_XOONIPS_IMPORT_INDEX_TEXT', 'Importしたいインデックスをインデックスツリーから選択してください' );
define( '_MD_XOONIPS_IMPORT_REQUIRED', '(必須)' );
define( '_MD_XOONIPS_IMPORT_PANKUZU_IMPORT', 'インポート' );
define( '_MD_XOONIPS_IMPORT_PANKUZU_RESOLVE_CONFLICT', '衝突の解決' );
define( '_MD_XOONIPS_IMPORT_TITLE_RESOLVE_CONFLICT', '衝突の解決' );
define( '_MD_XOONIPS_IMPORT_IMPORT_ALL', '全てインポート' );
define( '_MD_XOONIPS_IMPORT_IMPORT_ITEM', 'インポートするアイテム' );
define( '_MD_XOONIPS_IMPORT_PANKUZU_UPLOAD_FILE', 'ファイルアップロード' );
define( '_MD_XOONIPS_IMPORT_IMPORT_SUCCESSFULLY', 'インポートを完了しました．' );
define( '_MD_XOONIPS_IMPORT_NO_ITEMS_IMPORTED', 'インポートするアイテムがありません．' );
define( '_MD_XOONIPS_IMPORT_INDEX_NUMBER_LIMIT_OVER_FLOW', 'これ以上インデックスをインポートできません．サイト管理者に連絡して下さい．' );
define( '_MD_XOONIPS_IMPORT_ITEM_NUMBER_LIMIT_OVER_FLOW', 'これ以上アイテムをインポートできません．サイト管理者に連絡して下さい．' );
define( '_MD_XOONIPS_IMPORT_RESOLVE_CONFLICT_SUBMIT', '次へ' );
define( '_MD_XOONIPS_IMPORT_UPLOAD_SUBMIT', '次へ' );
define( '_MD_XOONIPS_IMPORT_PANKUZU_CHECK_LENGTH', '文字数超過のチェック' );
define( '_MD_XOONIPS_IMPORT_TITLE_CHECK_LENGTH', '文字数超過のチェック' );
define( '_MD_XOONIPS_IMPORT_CHECK_LENGTH_SUBMIT', 'アップロード' );
define( '_MD_XOONIPS_IMPORT_CHECK_LENGTH_WARNING', '以下のアイテムは、文字数超過のため一部切り捨てられます(赤字の部分)．' );
define( '_MD_XOONIPS_IMPORT_CHECK_LENGTH_NO_WARNING', '文字数が超過するアイテムはありません．' );
define( '_MD_XOONIPS_IMPORT_INDEX_CANNOT_WRITE', '以下のインデックスは無視されます．インポートできるインデックスはあなたのプライベートインデックスのみです．' );
define( '_MD_XOONIPS_IMPORT_IGNORE_CHECK', '衝突と文字数超過をチェックしない' );
define( '_MD_XOONIPS_IMPORT_NO_STRINGS_ARE_TRIMMED', '文字数制限を越える文字列はありませんでした．' );
define( '_MD_XOONIPS_IMPORT_NO_CONFLICT_ITEMS', '衝突するアイテムはありませんでした．' );
define( '_MD_XOONIPS_IMPORT_NUMBER_OF_CONFLICT_ITEMS', '衝突するアイテムの数：' );
define( '_MD_XOONIPS_IMPORT_FOLLOWING_ITEM_CONFLICT', '以下のアイテムが重複しています' );
define( '_MD_XOONIPS_IMPORT_IMPORT_ALL_AS_NEW', "衝突する全てのアイテムを新しいアイテムとしてインポートする\n（上書きチェックボックスの指定を無視します）．" );
define( '_MD_XOONIPS_IMPORT_IMPORT_MODIFY', 'インポート先インデックスにある以下の衝突アイテムを上書きする' );
define( '_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_IN_OTHER_INDEXES', '別のインデックスに以下の衝突アイテムがあります(上書きしません)' );
define( '_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_IN_THE_SAME_FILE', 'インポートファイル内に以下の衝突アイテムがあります' );
define( '_MD_XOONIPS_IMPORT_IMPORT_CAN_NOT_MODIFY', '複数のアイテムと衝突するのでインポートできません' );
define( '_MD_XOONIPS_IMPORT_LOGGING', 'ログを出力する' );
define( '_MD_XOONIPS_IMPORT_ERROR', 'インポート処理中にエラーが発生しました．' );
define( '_MD_XOONIPS_IMPORT_READY', 'インポートできます．' );
define( '_MD_XOONIPS_IMPORT_NO_ERROR', 'エラーはありません．' );
define( '_MD_XOONIPS_IMPORT_REVIEW_LOG', 'ログを確認してください．' );
define( '_MD_XOONIPS_IMPORT_LOCAL_FILE', 'ローカルファイルをインポートする' );
define( '_MD_XOONIPS_IMPORT_REMOTE_FILE', 'サーバ上のファイルをインポートする' );
define( '_MD_XOONIPS_IMPORT_ERROR_CHECK_ONLY', 'エラーチェックだけを行う' );
define( '_MD_XOONIPS_IMPORT_CONTRIBUTOR_SELECT', '指定ユーザの権限でインポートする' );
define( '_MD_XOONIPS_IMPORT_ERROR_CKECK_DONE', 'エラーチェックを完了しました．' );
define( '_MD_XOONIPS_IMPORT_INDEX_TREE_CREATED', '以下のインデックスツリーをインポートしました（リスト中の既存の同名インデックスの内容は変更されていません）．' );
define( '_MD_XOONIPS_IMPORT_INDEX_TREE_FAILED', 'インデックスツリーのインポートに失敗しました' );
define( '_MD_XOONIPS_IMPORT_FILE_NOT_FOUND', 'インポートファイルが見つかりません．' );
define( '_MD_XOONIPS_IMPORT_FILE_NOT_SPECIFIED', 'インポートファイルが指定されていません．' );
define( '_MD_XOONIPS_IMPORT_CERTIFY_AUTO', '公開インデックスに登録するアイテムを自動承認する' );
define( '_MD_XOONIPS_IMPORT_NO_ITEMS_ARE_FOUND', 'インポートするアイテムが見つかりませんでした．インポートファイルの内容を確認してください．' );
define( '_MD_XOONIPS_IMPORT_FOLLOWING_INDEX', '以下のインデックスをインポートします．' );
define( '_MD_XOONIPS_IMPORT_FOLLOWING_INDEX_TEST', '以下のインデックスをインポートできます．' );
define( '_MD_XOONIPS_IMPORT_CIRCULAR_INDEX', 'インデックスが循環構造を持っているため、インポートできません．' );

define( '_MD_XOONIPS_EVENT_ITEM_IS_SHOWN_IN', 'アイテムが以下のインデックスに公開されました' );
define( '_MD_XOONIPS_EVENT_NEW_GROUP', '新しいグループが作成されました' );

define( '_MD_XOONIPS_ITEM_LANG_LABEL', '言語' );
define( '_MD_XOONIPS_ITEM_LANG_OPTION_IDS', 'eng,jpn,fra,deu,esl,ita,dut,sve,nor,dan,fin,por,chi,kor' );
define( '_MD_XOONIPS_ITEM_LANG_OPTION_NAMES', '英語,日本語,フランス語,ドイツ語,スペイン語,イタリア語,オランダ語,スウェーデン語,ノルウェー語,デンマーク語,フィンランド語,ポルトガル語,中国語,韓国語' );


define( '_MD_XOONIPS_DOWNLOAD_LIMITATION_OPTION_LABEL', 'ダウンロード制限' );
define( '_MD_XOONIPS_DOWNLOAD_NOTIFICATION_OPTION_LABEL', 'ダウンロード通知' );
define( '_MD_XOONIPS_DOWNLOAD_ABNORMAL_CONFIGURATION' , 'ダウンロードファイルオプション設定の異常' );

define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_LABEL', 'ログインユーザ' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL', '全てのユーザ' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_ONLY_LABEL', 'ログインユーザのみ' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_DO_LABEL', 'する' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_DONT_LABEL', 'しない' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_EXPLANATION', 'この設定は、ダウンロード制限が「ログインユーザ」の場合のみ有効です。通知を受け取るには、イベントの「アイテムがダウンロードされたときに通知する」をONにする必要があります。' );

define( '_MD_XOONIPS_ITEM_ATTACHMENT_FILE_INFO_TITLE_LABEL', 'ダウンロードするファイルの情報' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_TITLE_LABEL', 'ダウンロードの通知' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_QUERY_LABEL', 'あなたがこのファイルをダウンロードしたことが、アイテムの登録者に通知されます。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_YES_LABEL', '通知されることに合意します。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DL_NOTIFY_NO_LABEL', '通知されることに合意しません。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_TITLE_LABEL', 'ファイルのライセンス' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_QUERY_LABEL', 'このファイルには下記のライセンスが設定されています。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_YES_LABEL', 'ライセンスに合意します。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_LICENSE_NO_LABEL', 'ライセンスに合意しません。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_NEED_AGREE_LABEL', 'ダウンロードするには、合意しますを選択する必要があります。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_NEED_AGREE_BOTH_LABEL', 'ダウンロードするには、両方で合意しますを選択する必要があります。' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_DOWNLOAD_LABEL', 'ダウンロード' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_CANCEL_LABEL', 'キャンセル' );
define( '_MD_XOONIPS_ITEM_ATTACHMENT_BAD_TOKEN_LABEL', '既にダウンロード済みのファイルです。<br />ページ再読込後に再ダウンロードを試してください。' );
define( '_MD_XOONIPS_ITEM_DOWNLOAD_NOSCRIPT_LABEL', 'ファイルをダウンロードするには、ブラウザのJavascriptを有効にする必要があります。' );

// harvest.php
define( '_MD_XOONIPS_OAIPMH_HARVEST_RESULT', 'ハーベスト結果' );
define( '_MD_XOONIPS_BACK_TO_OAIPMH_CONFIGURATION', 'OAI-PMH のメンテナンスに戻る' );

define( '_MD_XOONIPS_METADATA_SEARCH_LABEL', 'メタデータ検索' );

// labels for item_show (edit)
define( '_MD_XOONIPS_ITEMSHOW_CURRICULUM_VITAE', '略歴' );
define( '_MD_XOONIPS_ITEM_SHOW_EDIT_TITLE', '業績アイテム選択' );
define( '_MD_XOONIPS_ITEM_SHOW_ITEMLIST_PREV', '前へ' );
define( '_MD_XOONIPS_ITEM_SHOW_ITEMLIST_NEXT', '次へ' );
define( '_MD_XOONIPS_ITEM_SHOW_ITEMLIST_CHECK', 'チェック' );
define( '_MD_XOONIPS_ITEM_SHOW_ITEMLIST_ITEMS', 'アイテム' );
define( '_MD_XOONIPS_ITEM_SHOW_ITEMLIST_SUBMIT', '変更' );
define( '_MD_XOONIPS_NEED_LOGIN', 'ログインすると業績の閲覧ができます' );

// labels of userlists, showusers
define( '_MD_XOONIPS_USERLIST_TITLE', 'ユーザ一覧' );
define( '_MD_XOONIPS_USERLIST_EXPLANATION', 'ユーザ名をクリックすると各ユーザの情報を表示します' );

define( '_MD_XOONIPS_SHOW_USER_TITLE', 'ユーザ情報' );
define( '_MD_XOONIPS_SEND_MESSAGE', 'メッセージ送信' );
define( '_MD_XOONIPS_SHOW_CV_LABEL', '略歴' );
define( '_MD_XOONIPS_SHOW_PUBILICATION_LIST', '業績リスト' );
define( '_MD_XOONIPS_SHOW_BACKTOLIST_LABEL', '戻る' );
define( '_MD_XOONIPS_VIEW_USER_ACCOUNT', 'アカウント確認' );
define( '_MD_XOONIPS_EDIT_LISTS', '編集' );
define( '_MD_XOONIPS_ORDER_CHANGE', '表示順変更' );

define( '_MD_XOONIPS_UPLOAD_MAX_FILESIZE', '最大ファイルサイズ:' );
define( '_MD_XOONIPS_UPLOAD_ERR_OK', 'アップロード成功' );
define( '_MD_XOONIPS_UPLOAD_ERR_INI_SIZE', 'ファイルサイズが大きすぎます( upload_max_filesize )' );
define( '_MD_XOONIPS_UPLOAD_ERR_FORM_SIZE', 'ファイルサイズが大きすぎます( MAX_FILE_SIZE )' );
define( '_MD_XOONIPS_UPLOAD_ERR_PARTIAL', 'ファイルの一部しかアップされませんでした' );
define( '_MD_XOONIPS_UPLOAD_ERR_NO_FILE', 'ファイルはアップロードされませんでした' );
define( '_MD_XOONIPS_UPLOAD_ERR_NO_TMP_DIR', 'テンポラリフォルダが見付かりません' );
define( '_MD_XOONIPS_UPLOAD_ERR_CANT_WRITE', 'ディスクに書き込み出来ませんでした' );

// labels for edit curriculum vitae, publication list
define( '_MD_XOONIPS_EDIT_CV_TITLE', '略歴の編集' );
define( '_MD_XOONIPS_EDIT_CURRICULUM_VITAE', '略歴編集' );
define( '_MD_XOONIPS_ADD_CURRICULUM_VITAE_LABEL', '略歴追加' );
define( '_MD_XOONIPS_ADD_CURRICULUM_VITAE_WARNING', '項目を入力してください' );
define( '_MD_XOONIPS_CURRICULUM_VITAE_FROM', 'From' );
define( '_MD_XOONIPS_CURRICULUM_VITAE_TO', 'To' );
define( '_MD_XOONIPS_CURRICULUM_VITAE_TITLE', '項目' );
define( '_MD_XOONIPS_ADD_CURRICULUM_VITAE', '追加' );
define( '_MD_XOONIPS_MODIFY_CURRICULUM_VITAE_LABEL', '略歴編集' );
define( '_MD_XOONIPS_NO_CURRICULUM_VITAE_DATA', '略歴データは登録されていません' );
define( "_MD_XOONIPS_CURRICULUM_VITAE_BUTTON_EDIT", "変更");
define( '_MD_XOONIPS_CURRICULUM_VITAE_CHECK_INFO', 'ユーザ情報へ戻る' );
define( '_MD_XOONIPS_CURRICULUM_VITAE_INSERT', '略歴データを追加します' );
define( '_MD_XOONIPS_NO_PUBLICATION_ITEM_DATA', '業績リストにアイテムが登録されていません．' );
define( '_MD_XOONIPS_PUBLICATION_ITEM_CHANGE', '業績表示順変更' );
define( '_MD_XOONIPS_PUBLICATION_ITEM_INSERT', '業績リストを編集しています' );

define("_MD_XOONIPS_SU_TITLE", "アカウントの切り替え");
define("_MD_XOONIPS_SU_TARGET_USER", "アカウントの切り替え先");
define("_MD_XOONIPS_SU_ADMIN_PASSWORD", "あなたのパスワード");
define("_MD_XOONIPS_SU_OK", "OK");
define("_MD_XOONIPS_SU_CANNOT_LOGOUT", "ログアウトする前にアカウントの切り替えを終了してください．");

define("_MD_XOONIPS_SU_START", "アカウントを切り替えています");
define("_MD_XOONIPS_SU_FAIL", "パスワードが異なります");
define("_MD_XOONIPS_SU_END", "管理者に戻ります");
define("_MD_XOONIPS_SU_EXPLAIN", "一時的に他ユーザのアカウントで作業することができます．");

// doi( sort id )
define('_MD_XOONIPS_ITEM_DOI_DUPLICATE_ID', 'IDが重複しています．'); 
define('_MD_XOONIPS_ITEM_DOI_NOT_FOUND',    '該当するIDが見つかりません．');
define('_MD_XOONIPS_ITEM_DOI_INVALID_ID',   'IDが不正です．1-%d桁の英数字の必要があります'); 

define( '_MD_XOONIPS_SEARCH_ALL', '全て' );
define( '_MD_XOONIPS_SEARCH_METADATA', 'メタデータ' );
define( '_MD_XOONIPS_SEARCH_TITLE_AND_KEYWORD', 'タイトル & キーワード' );

define( '_MD_XOONIPS_PAGENAVI_NEXT', 'NEXT' );
define( '_MD_XOONIPS_PAGENAVI_PREV', 'PREV' );

define( '_MD_XOONIPS_ADD_FROM_ITEM_LIST_BUTTON_LABEL', 'アイテム一覧' );
define( '_MD_XOONIPS_ADD_FROM_COLUMN_LABEL', "次からアイテムを追加 : " );
define( '_MD_XOONIPS_ADD_FROM_INDEX_BUTTON_LABEL', "インデックスキーワード" );
define( '_MD_XOONIPS_ADD_FROM_SEARCH_BUTTON_LABEL', "検索" );

define( "_MD_XOONIPS_ERROR_CANNOT_EDIT_LOCKED_ITEM", "アイテムが%sのため編集できません" );
define( "_MD_XOONIPS_ERROR_CANNOT_DELETE_LOCKED_ITEM", "アイテムが%sのため削除できません" );
define( "_MD_XOONIPS_ERROR_CANNOT_WITHDRAW_LOCKED_ITEM", "アイテムが%sのため公開取り下げできません" );
define( "_MD_XOONIPS_WARNING_CANNOT_EDIT_LOCKED_ITEM", "このアイテムは%sのため編集できません" );
define( "_MD_XOONIPS_WARNING_CANNOT_EDIT_LOCKED_INDEX", "このインデックスは%sのアイテムがあるため編集できません" );
define( "_MD_XOONIPS_ERROR_CANNOT_EDIT_LOCKED_INDEX", "%sのアイテムがあるためインデックスを編集できません" );
define( "_MD_XOONIPS_WARNING_CANNOT_EDIT_LOCKED_GROUP", "このグループは%sのアイテムがあるため編集できません" );
define( "_MD_XOONIPS_ERROR_CANNOT_EDIT_LOCKED_GROUP", "%sのアイテムがあるため編集できません" );
define( "_MD_XOONIPS_ERROR_CANNOT_DELETE_LOCKED_GROUP", "%sのアイテムがあるため削除できません" );
define( "_MD_XOONIPS_ERROR_CANNOT_REMOVE_MEMBER_WHO_SHARE_ITEMS", "ユーザー「%s」はグループ共有・グループ共有要求中アイテムを持つため、グループから外せません" );
define( "_MD_XOONIPS_ERROR_CANNOT_OVERWRITE_LOCKED_ITEM", "「%s」は%sのため上書きできません" );
define( "_MD_XOONIPS_LOCK_TYPE_STRING_NOT_LOCKED", "非ロック中" );
define( "_MD_XOONIPS_LOCK_TYPE_STRING_CERTIFY_REQUEST", "公開要求中" );
define( "_MD_XOONIPS_LOCK_TYPE_STRING_TRANSFER_REQUEST", "移譲要求中" );
define( "_MD_XOONIPS_LOCK_TYPE_STRING_PUBLICATION_GROUP_INDEX", "公開要求中" );
define( "_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_LOCKED_CERTIFY_REQUEST", "同じインデックスに以下の衝突アイテムがあります("._MD_XOONIPS_LOCK_TYPE_STRING_CERTIFY_REQUEST."のため、上書きしません)" );
define( "_MD_XOONIPS_IMPORT_CONFLICT_ITEMS_LOCKED_TRANSFER_REQUEST", "同じインデックスに以下の衝突アイテムがあります("._MD_XOONIPS_LOCK_TYPE_STRING_TRANSFER_REQUEST."のため、上書きしません)" );

define( "_MD_XOONIPS_ITEM_TRANSFER_NOTIFYSBJ", "アイテムが移譲されました" );
define( "_MD_XOONIPS_ACCOUNT_CERTIFY_REQUEST_NOTIFYSBJ", "新規アカウントが登録されました" );
define( "_MD_XOONIPS_ACCOUNT_CERTIFIED_NOTIFYSBJ", "アカウントが承認されました" );
define( "_MD_XOONIPS_ITEM_CERTIFY_REQUEST_NOTIFYSBJ", "承認待ちのアイテムがあります" );
define( "_MD_XOONIPS_ITEM_CERTIFIED_AUTO_NOTIFYSBJ", "アイテムが自動承認されました" );
define( "_MD_XOONIPS_ITEM_CERTIFIED_NOTIFYSBJ", "アイテムが承認されました" );
define( "_MD_XOONIPS_ITEM_REJECTED_NOTIFYSBJ", "アイテムが承認拒否されました" );
define( "_MD_XOONIPS_USER_ITEM_TRANSFER_REQUEST_NOTIFYSBJ", "アイテムの移譲要求があります" );
define( "_MD_XOONIPS_USER_ITEM_TRANSFER_ACCEPTED_NOTIFYSBJ", "アイテムの移譲要求が許可されました" );
define( "_MD_XOONIPS_USER_ITEM_TRANSFER_REJECTED_NOTIFYSBJ", "アイテムの移譲要求を拒否されました" );
define( "_MD_XOONIPS_USER_INDEX_RENAMED_NOTIFYSBJ", "インデックスの名前が変更されました" );
define( "_MD_XOONIPS_USER_INDEX_MOVED_NOTIFYSBJ", "インデックスが移動されました" );
define( "_MD_XOONIPS_USER_INDEX_DELETED_NOTIFYSBJ", "インデックスが削除されました" );
define( "_MD_XOONIPS_USER_ITEM_CERTIFIED_NOTIFYSBJ", "あなたのアイテムは承認されました" );
define( "_MD_XOONIPS_USER_ITEM_REJECTED_NOTIFYSBJ", "あなたのアイテムは承認されませんでした" );
define( "_MD_XOONIPS_USER_FILE_DOWNLOADED_NOTIFYSBJ", "ファイルがダウンロードされました" );

define( "_MD_XOONIPS_PUSH_BUTTON_TO_ACTIVATE", "アカウントをアクティベートするには、アクティベートボタンを押してください。" );
define( "_MD_XOONIPS_ACTIVATE", "アクティベート" );

define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_PAGE_TITLE", "アイテムの移譲" );             
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_ITEM_ID", "ID" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_ITEM_TYPE", "アイテムタイプ" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_TITLE", "タイトル" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_UNSELECT", "選択解除" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_SUBMIT", "次へ" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_TO", "移譲先ユーザ：" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_LOCK_TYPE_CERTIFY_REQUEST_EXPLANATION", "公開要求中のため、このアイテムを移譲できません" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_LOCK_TYPE_TRANSFER_REQUEST_EXPLANATION", "移譲要求中のため、このアイテムを移譲できません" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_CAN_NOT_TRANSFER_THIS_ITEM_HAVE_ANOTHER_PARENT", "このアイテムは他のアイテムからも参照されているため移譲できません" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_NO_TRANSFER_ITEMS", "アイテムが選択されていません．" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_LIST_PAGE_DESCRIPTION", "移譲するアイテムと移譲先ユーザを選択してください．" );

define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_PAGE_TITLE", "アイテムの移譲" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_ITEM_ID", "ID" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_ITEM_TYPE", "アイテムタイプ" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_TITLE", "タイトル" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_BACK", "前画面に戻る" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_SUBMIT", "移譲の実行" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_USER_IS_NOT_SUBSCRIBED_TO_GROUPS", '移譲先ユーザ%sがグループ%sに所属していないため移譲できません' );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_TO", "移譲先ユーザ：" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_PAGE_DESCRIPTION", "以下のアイテムの移譲を行います．よろしいですか？" );
define( "_MD_XOONIPS_TRANSFER_USER_ITEM_CONFIRM_NO_TRANSFER_ITEMS", "移譲するアイテムが選択されていません" );

define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_PAGE_TITLE", "アイテムの移譲の確認" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_LIMIT_CHECK_OUT_OF_BOUNDS", "アイテム数またはファイル容量制限を超えるため移譲できません" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_ITEM_ID", "ID" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_ITEM_TYPE", "アイテムタイプ" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_OWNER", "所有者" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_TITLE", "タイトル" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_TO_INDEX", "移譲先インデックス：" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_ACCEPT", "移譲許可" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_REJECT", "移譲拒否" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_BACK_TO_TOP", "トップページへ戻る" );
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_CONFIRM_NO_TRANSFER_ITEMS", "移譲要求はありません" );

define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_DETAIL_PAGE_TITLE", "移譲アイテム詳細");
define( "_MD_XOONIPS_TRANSFER_USER_REQUESTED_ITEM_DETAIL_CLOSE", "閉じる");

define( "_MD_XOONIPS_TRANSFER_NOTIFICATION_ITEM_TITLE", "タイトル：" );
define( "_MD_XOONIPS_TRANSFER_NOTIFICATION_ITEM_DETAIL", "詳細：" );
define( "_MD_XOONIPS_TRANSFER_NOTIFICATION_ITEM_DETAIL_FORBIDDEN", "（プライベートアイテムのため閲覧できません）" );

define( "_MD_XOONIPS_TRANSFER_CHANGE_LOG_AUTOFILL_TEXT", "所有者を %s から %s に変更" );

define( "_MD_XOONIPS_TRANSFER_USER_ACCEPT_COMPLETE", "アイテムの移譲を完了しました");
define( "_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR", "アイテムの移譲に失敗しました");
define( "_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR_BAD_SUBSCRIBE_GROUP", "移譲先ユーザがグループに登録されていません。");
define( "_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR_NUMBER_OR_STORAGE_EXCEED", "移譲後のアイテム数またはファイル容量が設定された最大値を超えるため移譲できません");
define( "_MD_XOONIPS_TRANSFER_USER_ACCEPT_ERROR_NO_ITEM", "移譲要求はありません");
define( "_MD_XOONIPS_TRANSFER_USER_REJECT_COMPLETE", "アイテムの移譲を拒否しました");
define( "_MD_XOONIPS_TRANSFER_USER_REJECT_ERROR", "アイテムの移譲拒否に失敗しました");
define( "_MD_XOONIPS_TRANSFER_USER_REJECT_ERROR_NO_ITEM", "移譲要求はありません");
define( "_MD_XOONIPS_TRANSFER_USER_REQUEST_COMPLETE", "アイテムの移譲を要求しました。アイテムの移譲を完了するには、移譲先ユーザの承認が必要です。");
define( "_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR", "アイテムの移譲要求に失敗しました");
define( "_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR_BAD_SUBSCRIBE_GROUP", "移譲先ユーザがグループに登録されていません。");
define( "_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR_NO_TRANSFEREE_USER", "ユーザが1人しかいないので移譲できません");
define( "_MD_XOONIPS_TRANSFER_USER_REQUEST_ERROR_NO_ITEMTYPE", "アイテムタイプモジュールがインストールされていません");
define( "_MD_XOONIPS_TRANSFER_USER_LIST_ITEM_ERROR_BAD_SUBSCRIBE_GROUP_NAME", "グループ%sに所属していないのでアイテムを移譲できません" );
define( "_MD_XOONIPS_TRANSFER_USER_CAN_NOT_TRANSFER_ITEM" , "選択されたアイテムは移譲できません" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_JPN", "日本語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_ENG", "英語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_FRA", "フランス語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_DEU", "ドイツ語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_ESL", "スペイン語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_ITA", "イタリア語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_DUT", "オランダ語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_SVE", "スウェーデン語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_NOR", "ノルウェー語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_DAN", "デンマーク語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_FIN", "フィンランド語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_POR", "ポルトガル語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_CHI", "中国語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG_KOR", "韓国語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_ITEM_ID"            , "アイテムID" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_ITEMTYPE"           , "アイテムタイプID" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_USERNAME"           , "登録者" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_TITLES"             , "タイトル" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_KEYWORDS"           , "フリーキーワード" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_DESCRIPTION"        , "概要" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_EXT_ID"             , "ID" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LAST_MODIFIED_DATE" , "最終更新日" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_REGISTRATION_DATE"  , "作成日" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_CREATION_YEAR"      , "日付(年)" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_CREATION_MONTH"     , "日付(月)" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_CREATION_MDAY"      , "日付(日)" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_LANG"               , "言語" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_URL"                , "URL" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_INDEXES"            , "インデックス" );
define( "_MD_XOONIPS_XMLRPC_DISPLAY_NAME_RELATED_TO"         , "関連アイテム" );

define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_PAGE_TITLE', 'メタデータ検索' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_REPOSITORY_COUNT', '検索対象リポジトリ数： ' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_METADATA_COUNT', '検索対象メタデータ数： ' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_REPOSITORY_NAME', 'リポジトリ名' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_REPOSITORY_NOT_SPECIFIED', '（指定しない）' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_KEYWORD', 'キーワード' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_SUBMIT', '検索' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_DEFAULT_ILLEGAL_CONDITION', 'リポジトリ名またはキーワードを指定してください' );

define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_PAGE_TITLE', 'メタデータ検索結果' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_TITLE', 'タイトル' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_REPOSITORY_NAME', 'リポジトリ名' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_ID', 'ID' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_LAST_UPDATE_DATE', '最終更新日' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_CREATION_DATE', '作成日' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_DATE', '日付' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_LINK', 'リソースへのリンク' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_ORDER_BY', '並び順 : ' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_TITLE_LABEL', 'タイトル' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_IDENTIFIER_LABEL', 'ID' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_LAST_UPDATE_DATE_LABEL', '最終更新日' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_CREATION_DATE_LABEL', '作成日' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_DATE_LABEL', '日付' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_ASC_LABEL', '昇順' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_DESC_LABEL', '降順' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_NUM_OF_METADATA_PER_PAGE', '表示メタデータ数：' );
define( '_MD_XOONIPS_OAIPMH_SEARCH_RESULT_BACK', '検索条件を変更する' );
define( '_MD_XOONIPS_OAMPMH_SEARCH_RESULT_PAGENAVI_PREV', 'PREV' );
define( '_MD_XOONIPS_OAMPMH_SEARCH_RESULT_PAGENAVI_NEXT', 'NEXT' );


define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_PAGE_TITLE', 'メタデータ詳細' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_TITLE', 'タイトル' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_REPOSITORY_NAME', 'リポジトリ名' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_ID', 'ID' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_LAST_UPDATE_DATE', '最終更新日' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_CREATION_DATE', '作成日' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_DATE', '日付' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_CREATOR', '作成者' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_RESOURCE_LINK', 'リソースへのリンク' );
define( '_MD_XOONIPS_OAIPMH_METADATA_DETAIL_BACK', '戻る' );

// breadcrumbs
define( '_MD_XOONIPS_BREADCRUMBS_USER', 'ユーザ' );
define( '_MD_XOONIPS_BREADCRUMBS_GROUPADMIN', 'グループ管理' );
define( '_MD_XOONIPS_BREADCRUMBS_MODERATOR', 'モデレータ' );
// - event_log.php
define( '_MD_XOONIPS_BREADCRUMBS_EVENTLOG', 'イベントログ' );
define( '_MD_XOONIPS_BREADCRUMBS_EVENTLOG_GRAPH', '統計グラフ' );
define( '_MD_XOONIPS_BREADCRUMBS_EVENTLOG_LIST', '登録状況一覧' );

//// 200801 add ////
define( "_MD_XOONIPS_ITEM_GROUP_CERTIFY_ITEM_TITLE", "グループアイテム承認" );
define( "_MD_XOONIPS_HEADER_GROUP_CERTIFY_ITEMS", "以下のグループアイテムを承認して下さい．" );
define( "_MD_XOONIPS_ITEM_GROUP_INDEX_LABEL", "グループ<BR>インデックス" );
define( "_MD_XOONIPS_ITEM_NO_GROUP_CERTIFY_ITEMS", "新規登録グループアイテムはありません．" );
define( '_MI_XOONIPS_ITEM_PANKUZU_CERTIFY_GROUP_PUBLIC_ITEMS', '公開グループアイテム承認' );
define( '_MD_XOONIPS_CREATE_GROUP_TREE_TO_PUBLIC_INDEX_TREE_FAILED', 'グループアイテム公開のときパブリックインデックスツリー下へのインデックス作成に失敗しました' );
define( "_MD_XOONIPS_ITEM_GROUP_INDEX_TO_PUBLIC", "グループアイテム公開" );
define( '_MD_XOONIPS_GROUP_TREE_TO_PUBLIC_INDEX_TREE_FAILED', 'グループアイテム公開申請のときデータベースアクセスに失敗しました' );

define( "_MD_XOONIPS_MULTIPLE_FIELD_ADD_LABEL",  "追加" );
?>
