<?php
// $Revision: 1.4.2.1.2.3 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
define( 'WVTEXT_FAILED', 'wvText failed.' );

class XoonipsWord extends XoonipsSearchTextExtractor {
  var $_tmpfile = '';

  function XoonipsWord() {
  }
  
  function openNowin( $filename ) {
    // for antiword
    // - set ANTIWORDHOME environment variable for map file detection
    // putenv( 'ANTIWORDHOME=C:\\usr\\local\\antiword' );
    // $cmd = sprintf( 'antiword -t -m UTF-8.txt %s', $filename );
    $this->_tmpfile = tempnam( '/tmp', 'XooNIpsWord' );
    $cmd = sprintf( 'wvText %s %s', escapeshellarg( $filename ), escapeshellarg( $this->_tmpfile ) );
    // set LANG to UTF-8 for wvText(elinks)
    $lang = getenv( 'LANG' );
    putenv( 'LANG=en_US.UTF-8' );
    // execute wvText command
    @system( $cmd );
    // restore original lang
    putenv( 'LANG='.( ( $lang === false ) ? '' : $lang ) );
    $this->handle = @fopen( $this->_tmpfile, 'rb' );
  }
  
  function close() {
    // for antiword
    // pclose( $this->handle );
    // putenv( 'ANTWORDHOME=' );
    @fclose( $this->handle );
    @unlink( $this->_tmpfile );
    $this->_tmpfile = '';
    $this->handle = false;
  }
  
  function fetch() {
    return $this->fetchFromText();
  }
};

?>
