<?php
// $Revision: 1.7.4.1.2.10 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
   
   op='list' or undefined .... list of groups
     
 */

include 'include/common.inc.php';

xoonips_deny_guest_access();

$formdata =& xoonips_getutility( 'formdata' );
$op = $formdata->getValue( 'both', 'op', 's', false, 'list' );

if ( $op == 'list' ) {

  $breadcrumbs = array(
    array( 'name' => _MD_XOONIPS_BREADCRUMBS_USER ),
    array( 'name' => _MD_XOONIPS_BREADCRUMBS_GROUPS_LIST, 'url' => 'groups.php' ),
  );

  $xg_handler =& xoonips_gethandler( 'xoonips', 'group' );
  $u_handler =& xoonips_getormhandler( 'xoonips', 'xoops_users' );
  $textutil =& xoonips_getutility( 'text' );

  $groups = array();

  // get all groups
  $xg_objs =& $xg_handler->getGroupObjects();

  foreach ( $xg_objs as $xg_obj ) {
    $group = array();
    $group['gid'] = $xg_obj->getVar( 'gid', 's' );
    $group['gname'] = $xg_obj->getVar( 'gname', 's' );
    $group['gdesc'] = $xg_obj->getVar( 'gdesc', 's' );
    // get each group admins
    $group['gadmin'] = array();
    $gadmin_uids = $xg_handler->getUserIds( $group['gid'], true );
    foreach ( $gadmin_uids as $uid ) {
      $uobj =& $u_handler->get( $uid );
      $uname = $uobj->getVar( 'uname', 's' );
      $name = $uobj->getVar( 'name', 's' );
      $email = $uobj->getVar( 'email', 's' );
      $email_js = $textutil->mail_to( ( !empty( $name ) ? $name : $uname ), $email );
      $group['gadmin'][] = array(
        'uid' => $uid,
        'uname' => $uname,
        'name' => $name,
        'email' => $email,
        'email_js' => $email_js,
      );
    }
    $groups[] =& $group;
    unset( $group );
  }

  $xoopsOption['template_main'] = 'xoonips_group_list.html';
  include XOOPS_ROOT_PATH.'/header.php';
  $xoopsTpl->assign( 'groups', $groups );
  $xoopsTpl->assign( 'xoops_breadcrumbs', $breadcrumbs );
  include XOOPS_ROOT_PATH.'/footer.php';

}

?>
