<?php
// $Revision: 1.1.4.1.2.4 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
if ( ! defined( 'XOOPS_ROOT_PATH' ) ) {
  exit();
}

// check token ticket
require_once( '../class/base/gtickets.php' );
$ticket_area = 'xoonips_admin_maintenance_filesearch';
if ( ! $xoopsGTicket->check( true, $ticket_area, false ) ) {
  redirect_header( $xoonips_admin['mypage_url'], 3, $xoopsGTicket->getErrors() );
  exit();
}

// load xoonips abstract layer for xnpExtranceText()
include_once '../include/lib.php';

$modules = xnpGetFileSearchModules();
$file_handler =& xoonips_getormhandler( 'xoonips', 'file' );
$criteria = new CriteriaCompo();
// avoid 'file_type_id' confict
$criteria->add( new Criteria( $xoopsDB->prefix( 'xoonips_file' ).'.file_type_id', '4', '>' ) );
$criteria->add( new Criteria( 'item_id', 'NULL', '!=' ) );
$criteria->add( new Criteria( 'is_deleted', '0', '=' ) );
$file_objs =& $file_handler->getObjects( $criteria, false, 'file_id' );
foreach ( $file_objs as $file_obj ) {
  $file_id = intval( $file_obj->getVar( 'file_id', 'n' ) );
  list( $result, $errmes ) = xnpExtractText( $file_id, $modules );
}

redirect_header( $xoonips_admin['mypage_url'], 3, _AM_XOONIPS_MSG_DBUPDATED );

?>
