package jp.sourceforge.libconcierge;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
	
	// shared variables.
	private static final int EOF = -1;

	/**
	 * Copy a source file to destination path. 
	 * @param src
	 * @param dest
	 * @throws IOException
	 */
	public static void copy(String src, String dest) throws IOException
	{
		FileInputStream in = null;
		FileOutputStream out = null;
		try {
			in = new FileInputStream(src);
			out = new FileOutputStream(dest);
			FileChannel cIn = in.getChannel();
			FileChannel cOut = out.getChannel();
 			cIn.transferTo(0, cIn.size(), cOut);
		}
		finally {
			try {
				if(in != null)	in.close();
				if(out != null)	out.close();
			} catch(IOException e) {}
		}
	}

	public static String getFilename(String filepath) {
		String[] components = filepath.split("\\"+File.separator);  
		String filename = components[components.length-1];
		return filename;
	}
	
	public static String getDirectory(String filepath) {
		String separator = File.separator;
		String[] names = filepath.split("\\"+separator);
		String directory = "";
		if (System.getProperty("os.name").contains("Win")) {
			directory = names[0];
			for (int i=1; i<names.length-1; i++) {
				directory += separator+names[i];
			}
		} else {
			for (int i=1; i<names.length-1; i++) {
				directory += separator+names[i];
			}
		}
		return directory+separator;
	}

	public static String makeZipFile(String tgtdir, String tmpdir) {
		String message = "";
		
		// create zip file & stream.
       ZipOutputStream zos = null;
		try {
	        File zipFile = new File(tgtdir);
	        zos = new ZipOutputStream(new FileOutputStream(zipFile));
		} catch (FileNotFoundException e) {
			message += "Failed to create an output stream for zip files.\n";
		}

        // zip xml files.
		ArrayList<ZipData> xmls = getZipDataFromFolder(tmpdir, "");
		for (int i=0; i<xmls.size(); i++) {
			addTargetFile(zos, xmls.get(i));
		}
		
		// attachment files.
        try {
        	String attachdir = tmpdir + "files" + File.separator;
        	String prefix = "files" + File.separator;
            xmls = getZipDataFromFolder(attachdir, prefix);
            for (int i=0; i<xmls.size(); i++) {
            	System.out.println("target : [" +xmls.get(i)+"]");
            	addTargetFile(zos, xmls.get(i));
            }
			zos.close();
		} catch (IOException e) {
			message += "Failed to close the zip output stream for attachment files.\n";
		}
		
		return message;
	}
	
	public static ArrayList<ZipData> getZipDataFromFolder(String dirname, String prefix) {
		ArrayList<ZipData> list = new ArrayList<ZipData>();
		File dir = new File(dirname);
		if (dir.isDirectory()) {
			String[] files = dir.list();
			for(int i=0; i<files.length; i++) {
				String fpath = dirname + files[i];
				File f = new File(fpath);
				if (f.isFile()) {
					String entry = prefix + files[i];
					ZipData zd = new ZipData(fpath, entry);
					list.add(zd);
				}
			}
		}
		return list;	
	}
	
	private static void addTargetFile(final ZipOutputStream zos, final ZipData zd) {
		try {
			File file = new File(zd.filepath);
			final BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
			final ZipEntry target = new ZipEntry(zd.zipentry);
			zos.putNextEntry(target);
			final byte buf[] = new byte[1024];
			int count;
			while ((count = bis.read(buf, 0, 1024)) != EOF) {
				zos.write(buf, 0, count);
			}
			bis.close();
			zos.closeEntry(); 
		} catch (final Exception e){
			e.printStackTrace();
		}
	}

	public static void deleteAll(String path) {
		File fs = new File(path);
		if (fs.isDirectory()) {
			File[] files = fs.listFiles();
			for (int i=0; i<files.length; i++) {
				if (files[i].isFile())	files[i].delete();
				else FileUtil.deleteAll(files[i].getAbsolutePath());
			}
			fs.delete();
		}
	}
	
}

class ZipData {
	public String filepath;
	public String zipentry;
	
	public ZipData(String path, String entry) {
		this.filepath = path;
		String revisedentry = entry.replaceAll("\\"+File.separator, "/"); // File separator must be appropriate for XooNIps environment.
		System.out.println(revisedentry);
		this.zipentry = revisedentry;
	}
}