package jp.sourceforge.libconcierge;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class DataLoader {

	// constants.
	private static final String RETURNCODE = "\n";
	
	// field values.
	private String csvfile = null;
	private String log = null;
	
	/**
	 * The constructor.
	 */
	public DataLoader(String filename) {
		csvfile = filename;
		log = "";
	}
	
	/**
	 * Load metadata from a CSV file.
	 * @param file CSV file
	 * @throws IOException 
	 */
	public ArrayList<LibraryData> run() {
		ArrayList<LibraryData>ret = new ArrayList<LibraryData>();
		try {
			InputStreamReader isr = new InputStreamReader(new FileInputStream(csvfile), "UTF-8");			
			BufferedReader reader = new BufferedReader(isr);
			int count = 0;
			while(true) {
				String line = reader.readLine();
				if (line == null) break;
				line = line.replaceAll("<br>", RETURNCODE); // return code.
				LibraryData ld = new LibraryData();
				if (ld.setMetadata(line) == false) {
					log += "line "+count+" may be inadequate data.\n";
				}
				count++;
				ret.add(ld);
			}
			reader.close();
		} catch(FileNotFoundException e) {
			log = csvfile + "does not exist.";
		} catch(IOException e) {
			log = "Faild to open bufferereader.";
		}
		
		return ret;
	}
	
	/**
	 * Get log.
	 */
	public String getLog() {
		return log;
	}
}