package jp.sourceforge.libconcierge;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.*;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;

public class DataConverterView extends ViewPart
{
	public static final String ID = "LibConcierge.view";

	// Constants.
	private final static String[] ITEMTYPES = {
		"xnparticle", "xnpbook", "xnpphoto", "xnpwebsite",
		"xnpdata", "xnpsound", "xnpvideo", "xnpbulletin"};
	
	// Field variables.
	private String importdir = null;
	private ArrayList<LibraryData> metadata = null;
	private Text MessageArea = null;
	private String log = "";

	/**
	 * The constructor.
	 */
	public DataConverterView() {
		metadata = new ArrayList<LibraryData>();
	}

	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(final Composite parent) {
		// create root composites.
		parent.setLayout(new GridLayout(1, false));
		Composite upper = new Composite(parent, SWT.NONE);
		upper.setLayout(new GridLayout(3, false));
		upper.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Composite lower = new Composite(parent, SWT.NONE);
		lower.setLayout(new GridLayout(1, false));
		lower.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		// set load button.
		Button LoadBtn = new Button(upper, SWT.OPEN);
		LoadBtn.setText("Load");
		LoadBtn.addMouseListener(new MouseListener(){
			// do notihing.
			public void mouseDoubleClick(MouseEvent e) {
			}
			public void mouseDown(MouseEvent e) {
			}
			// load metadata from the csv file.
			public void mouseUp(MouseEvent e) {
				FileDialog fd = new FileDialog(parent.getShell(), SWT.OPEN);
				String csvfile = fd.open();
				importdir = FileUtil.getDirectory(csvfile);
				DataLoader loader = new DataLoader(csvfile);
				metadata = loader.run();
				if (loader.getLog() == "") {
					showMessage("Metadata was successfully loaded from "+csvfile+".\n");					
				} else {
					showMessage(loader.getLog());
				}
			}});
		
		// set drop down list as type chooser.
		final Combo TypeChooser = new Combo(upper, SWT.READ_ONLY);
		for (int i=0; i<ITEMTYPES.length; i++) {
			TypeChooser.add(ITEMTYPES[i]);
		}
		TypeChooser.select(0);
		TypeChooser.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		// set export button.
		Button ExportBtn = new Button(upper, SWT.OPEN);
		ExportBtn.setText("Export");
		ExportBtn.addMouseListener(new MouseListener(){
			// do notihing.
			public void mouseDoubleClick(MouseEvent e) {
			}
			public void mouseDown(MouseEvent e) {
			}
			// load metadata from the csv file.
			public void mouseUp(MouseEvent e) {
				DirectoryDialog dd = new DirectoryDialog(parent.getShell());
				String exportdir = dd.open();
				DataExporter exporter = new DataExporter(importdir, exportdir, metadata, TypeChooser.getText());
				exporter.run();
				String message = exporter.getLog();
				if (message == "") 
					showMessage("Convert process seemed to be complete.");
				else
					showMessage(message);
			}
		});
		
		// set message area.
		MessageArea  = new Text(lower, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL);
		MessageArea.setLayoutData(new GridData(GridData.FILL_BOTH));
	}

	/**
	 * Short-cut to the message dialog.
	 * @param message
	 */
	public void showMessage(String message) {
		log = log+message+"\n";
		MessageArea.setText(log);
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		// do nothing.
	}
}