/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.libconcierge;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.libconcierge.FileUtil;
import jp.sourceforge.libconcierge.LibraryData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataExporter {
    private static final String EXPORTDIR = "xoonips_tmp";
    private static final String ZIPFILE = "XooNIpsData.zip";
    private DocumentBuilder db;
    private String importdir;
    private String zipfile;
    private String exportdir;
    private String attachdir;
    private String itemtype;
    private ArrayList<LibraryData> metadata;
    private int fileid = 1;
    private String sepa;
    private String log;

    public DataExporter(String idir, String edir, ArrayList<LibraryData> data, String type) {
        this.metadata = data;
        this.itemtype = type;
        this.importdir = idir;
        this.sepa = File.separator;
        this.zipfile = String.valueOf(edir) + this.sepa + ZIPFILE;
        this.exportdir = String.valueOf(edir) + this.sepa + EXPORTDIR + this.sepa;
        this.attachdir = String.valueOf(this.exportdir) + "files" + this.sepa;
        this.log = "";
        File expdir = new File(this.exportdir);
        expdir.mkdir();
        File atcdir = new File(this.attachdir);
        atcdir.mkdir();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.log = String.valueOf(this.log) + "Failed to creat DocumentBuilder\n";
        }
    }

    public String getLog() {
        return this.log;
    }

    public void run() {
        int i = 1;
        while (i <= this.metadata.size()) {
            LibraryData ld = this.metadata.get(i - 1);
            Document doc = this.data2xml(i, ld);
            try {
                TransformerFactory tff = TransformerFactory.newInstance();
                Transformer tf = tff.newTransformer();
                tf.setOutputProperty("encoding", "UTF-8");
                tf.transform(new DOMSource(doc), new StreamResult(String.valueOf(this.exportdir) + i + ".xml"));
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                this.log = String.valueOf(this.log) + "Failed to save the XML file of no." + Integer.toString(i) + " data";
            }
            catch (TransformerException e) {
                e.printStackTrace();
                this.log = String.valueOf(this.log) + "Failed to save the XML file of no." + Integer.toString(i) + " data";
            }
            ++i;
        }
        FileUtil.makeZipFile(this.zipfile, this.exportdir);
        FileUtil.deleteAll(this.exportdir);
    }

    private Document data2xml(int num, LibraryData ld) {
        String path;
        Element child;
        Element child2;
        Document doc = this.db.newDocument();
        Element root = doc.createElement("item");
        root.setAttribute("version", "1.00");
        doc.appendChild(root);
        Element basic = doc.createElement("basic");
        basic.setAttribute("id", Integer.toString(num));
        root.appendChild(basic);
        Element detail = doc.createElement("detail");
        detail.setAttribute("id", Integer.toString(num));
        root.appendChild(detail);
        Element element = doc.createElement("itemtype");
        Text text = doc.createTextNode(this.itemtype);
        basic.appendChild(element);
        element.appendChild(text);
        element = doc.createElement("titles");
        basic.appendChild(element);
        ArrayList ret = ld.getMetadata("title");
        if (ret.size() > 0) {
            child2 = doc.createElement("title");
            text = doc.createTextNode((String)ret.get(0));
            child2.appendChild(text);
            element.appendChild(child2);
        }
        if ((ret = ld.getMetadata("title_kana")).size() > 0) {
            child2 = doc.createElement("title");
            text = doc.createTextNode((String)ret.get(0));
            child2.appendChild(text);
            element.appendChild(child2);
        }
        if ((ret = ld.getMetadata("title_rome")).size() > 0) {
            child2 = doc.createElement("title");
            text = doc.createTextNode((String)ret.get(0));
            child2.appendChild(text);
            element.appendChild(child2);
        }
        element = doc.createElement("keywords");
        basic.appendChild(element);
        ret = ld.getMetadata("keyword");
        int i = 0;
        while (i < ret.size()) {
            Element child3 = doc.createElement("keyword");
            text = doc.createTextNode((String)ret.get(i));
            child3.appendChild(text);
            element.appendChild(child3);
            ++i;
        }
        element = doc.createElement("description");
        basic.appendChild(element);
        ret = ld.getMetadata("note");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("doi");
        basic.appendChild(element);
        ret = ld.getMetadata("sortid");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("contributor");
        basic.appendChild(element);
        element = doc.createElement("publication_year");
        basic.appendChild(element);
        element = doc.createElement("publication_month");
        basic.appendChild(element);
        element = doc.createElement("publication_mday");
        basic.appendChild(element);
        element = doc.createElement("lang");
        basic.appendChild(element);
        element = doc.createElement("url");
        basic.appendChild(element);
        element = doc.createElement("index");
        basic.appendChild(element);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date currentTime = new Date();
        String dateString = formatter.format(currentTime);
        element = doc.createElement("last_update_date");
        basic.appendChild(element);
        text = doc.createTextNode(dateString);
        element.appendChild(text);
        element = doc.createElement("creation_date");
        basic.appendChild(element);
        text = doc.createTextNode(dateString);
        element.appendChild(text);
        element = doc.createElement("title");
        detail.appendChild(element);
        ret = ld.getMetadata("title");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("title_kana");
        detail.appendChild(element);
        ret = ld.getMetadata("title_kana");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("title_romaji");
        detail.appendChild(element);
        ret = ld.getMetadata("title_rome");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        ArrayList names = ld.getMetadata("atitle");
        ArrayList kanas = ld.getMetadata("atitle_kana");
        ArrayList romes = ld.getMetadata("atitle_rome");
        int maxnum = names.size();
        if (kanas.size() > maxnum) {
            maxnum = kanas.size();
        }
        if (romes.size() > maxnum) {
            maxnum = romes.size();
        }
        int i2 = 0;
        while (i2 < maxnum) {
            element = doc.createElement("sub_title");
            detail.appendChild(element);
            Element name = doc.createElement("sub_title_name");
            String data = "";
            if (names.size() > i2) {
                data = (String)names.get(i2);
            }
            name.appendChild(doc.createTextNode(data));
            element.appendChild(name);
            Element kana = doc.createElement("sub_title_kana");
            data = "";
            if (kanas.size() > i2) {
                data = (String)kanas.get(i2);
            }
            kana.appendChild(doc.createTextNode(data));
            element.appendChild(kana);
            Element rome = doc.createElement("sub_title_romaji");
            data = "";
            if (romes.size() > i2) {
                data = (String)romes.get(i2);
            }
            rome.appendChild(doc.createTextNode(data));
            element.appendChild(rome);
            ++i2;
        }
        ArrayList a_i = ld.getMetadata("author_id");
        ArrayList a_n = ld.getMetadata("author");
        ArrayList a_k = ld.getMetadata("author_kana");
        ArrayList a_r = ld.getMetadata("author_rome");
        ArrayList a_a = ld.getMetadata("author_afl");
        ArrayList a_t = ld.getMetadata("author_transafl");
        ArrayList a_o = ld.getMetadata("author_role");
        ArrayList a_l = ld.getMetadata("author_link");
        maxnum = a_i.size();
        if (a_n.size() > maxnum) {
            maxnum = a_n.size();
        }
        if (a_k.size() > maxnum) {
            maxnum = a_k.size();
        }
        if (a_r.size() > maxnum) {
            maxnum = a_r.size();
        }
        if (a_a.size() > maxnum) {
            maxnum = a_a.size();
        }
        if (a_t.size() > maxnum) {
            maxnum = a_t.size();
        }
        if (a_o.size() > maxnum) {
            maxnum = a_o.size();
        }
        if (a_l.size() > maxnum) {
            maxnum = a_l.size();
        }
        int i3 = 0;
        while (i3 < maxnum) {
            Element parent = doc.createElement("author");
            detail.appendChild(parent);
            Element child4 = doc.createElement("author_id");
            String data = "";
            if (a_i.size() > i3) {
                data = (String)a_i.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_name");
            data = "";
            if (a_n.size() > i3) {
                data = (String)a_n.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_kana");
            data = "";
            if (a_k.size() > i3) {
                data = (String)a_k.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_romaji");
            data = "";
            if (a_r.size() > i3) {
                data = (String)a_r.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_affiliation");
            data = "";
            if (a_a.size() > i3) {
                data = (String)a_a.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_affiliation_translation");
            data = "";
            if (a_t.size() > i3) {
                data = (String)a_t.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_role");
            data = "";
            if (a_o.size() > i3) {
                data = (String)a_o.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            child4 = doc.createElement("author_link");
            data = "";
            if (a_l.size() > i3) {
                data = (String)a_l.get(i3);
            }
            child4.appendChild(doc.createTextNode(data));
            parent.appendChild(child4);
            ++i3;
        }
        element = doc.createElement("edition");
        detail.appendChild(element);
        ret = ld.getMetadata("edition");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("publish_place");
        detail.appendChild(element);
        ret = ld.getMetadata("pub_place");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("publisher");
        detail.appendChild(element);
        ret = ld.getMetadata("pub_name");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("publisher_kana");
        detail.appendChild(element);
        ret = ld.getMetadata("pub_kana");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("publisher_romaji");
        detail.appendChild(element);
        ret = ld.getMetadata("pub_rome");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("year_f");
        detail.appendChild(element);
        ret = ld.getMetadata("pub_yearF");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("year_t");
        detail.appendChild(element);
        ret = ld.getMetadata("pub_yearT");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("date_create");
        detail.appendChild(element);
        ret = ld.getMetadata("date_create");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("date_update");
        detail.appendChild(element);
        ret = ld.getMetadata("date_modify");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("date_record");
        detail.appendChild(element);
        ret = ld.getMetadata("date_record");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_translation");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_trans");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_volume");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_vol");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_issue");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_num");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_year");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_year");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_month");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_month");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_spage");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_spage");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("jtitle_epage");
        detail.appendChild(element);
        ret = ld.getMetadata("stitle_epage");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("keywords");
        detail.appendChild(element);
        ret = ld.getMetadata("keyword");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("keyword");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("ndc_classifications");
        detail.appendChild(element);
        ret = ld.getMetadata("category");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("ndc_classification");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("physical_descriptions");
        detail.appendChild(element);
        ret = ld.getMetadata("format");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("physical_description");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("langs");
        detail.appendChild(element);
        ret = ld.getMetadata("lang");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("lang");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("id_issns");
        detail.appendChild(element);
        ret = ld.getMetadata("id_issn");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("id_issn");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("id_isbns");
        detail.appendChild(element);
        ret = ld.getMetadata("id_isbn");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("id_isbn");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("id_dois");
        detail.appendChild(element);
        ret = ld.getMetadata("id_doi");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("id_doi");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("id_uris");
        detail.appendChild(element);
        ret = ld.getMetadata("id_uri");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("id_uri");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("id_locals");
        detail.appendChild(element);
        ret = ld.getMetadata("id_other");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("id_local");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("uris");
        detail.appendChild(element);
        ret = ld.getMetadata("uri");
        i3 = 0;
        while (i3 < ret.size()) {
            child = doc.createElement("uri");
            text = doc.createTextNode((String)ret.get(i3));
            child.appendChild(text);
            element.appendChild(child);
            ++i3;
        }
        element = doc.createElement("abstract");
        detail.appendChild(element);
        ret = ld.getMetadata("abst");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("table_of_contents");
        detail.appendChild(element);
        ret = ld.getMetadata("toc");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("type_of_resource");
        detail.appendChild(element);
        ret = ld.getMetadata("type");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("genre");
        detail.appendChild(element);
        ret = ld.getMetadata("genre");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        element = doc.createElement("access_condition");
        detail.appendChild(element);
        ret = ld.getMetadata("condition");
        if (ret.size() > 0) {
            text = doc.createTextNode((String)ret.get(0));
            element.appendChild(text);
        }
        if ((ret = ld.getMetadata("path2body")).size() > 0 && !(path = (String)ret.get(0)).equals("")) {
            String src = String.valueOf(this.importdir) + path;
            String dst = String.valueOf(this.attachdir) + this.fileid;
            try {
                FileUtil.copy(src, dst);
            }
            catch (IOException iOException) {
                this.log = String.valueOf(this.log) + "Failed to make a copy of a preview file.\n";
                this.log = String.valueOf(this.log) + "\tsource: " + src + "\n";
                this.log = String.valueOf(this.log) + "\tdestination: " + dst + "\n";
            }
            String typename = "article_attachment";
            String idnumber = Integer.toString(num);
            String orgfname = FileUtil.getFilename(path);
            String cpyfname = "files/" + this.fileid;
            String mimetype = URLConnection.getFileNameMap().getContentTypeFor(src);
            String filesize = String.valueOf(new File(src).length());
            element = doc.createElement("file");
            detail.appendChild(element);
            element.setAttribute("file_type_name", typename);
            element.setAttribute("item_id", idnumber);
            element.setAttribute("original_file_name", orgfname);
            element.setAttribute("file_name", cpyfname);
            element.setAttribute("mime_type", mimetype);
            element.setAttribute("file_size", filesize);
            ++this.fileid;
            Element child5 = doc.createElement("caption");
            element.appendChild(child5);
        }
        ret = ld.getMetadata("path2image");
        i = 0;
        while (i < ret.size()) {
            String path2 = (String)ret.get(i);
            if (!path2.equals("")) {
                String src = String.valueOf(this.importdir) + path2;
                String dst = String.valueOf(this.attachdir) + this.fileid;
                try {
                    FileUtil.copy(src, dst);
                }
                catch (IOException iOException) {
                    this.log = String.valueOf(this.log) + "Failed to make a copy of a preview file.\n";
                    this.log = String.valueOf(this.log) + "\tsource: " + src + "\n";
                    this.log = String.valueOf(this.log) + "\tdestination: " + dst + "\n";
                }
                String typename = "preview";
                String idnumber = Integer.toString(num);
                String orgfname = FileUtil.getFilename(path2);
                String cpyfname = "files/" + this.fileid;
                String mimetype = URLConnection.getFileNameMap().getContentTypeFor(src);
                String filesize = String.valueOf(new File(src).length());
                element = doc.createElement("file");
                detail.appendChild(element);
                element.setAttribute("file_type_name", typename);
                element.setAttribute("item_id", idnumber);
                element.setAttribute("original_file_name", orgfname);
                element.setAttribute("file_name", cpyfname);
                element.setAttribute("mime_type", mimetype);
                element.setAttribute("file_size", filesize);
                ++this.fileid;
                Element child6 = doc.createElement("caption");
                element.appendChild(child6);
                child6 = doc.createElement("thumbnail");
                element.appendChild(child6);
            }
            ++i;
        }
        return doc;
    }
}

