/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.libconcierge;

import java.util.ArrayList;
import jp.sourceforge.libconcierge.DataExporter;
import jp.sourceforge.libconcierge.DataLoader;
import jp.sourceforge.libconcierge.FileUtil;
import jp.sourceforge.libconcierge.LibraryData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class DataConverterView
extends ViewPart {
    public static final String ID = "LibConcierge.view";
    private static final String[] ITEMTYPES = new String[]{"xnparticle", "xnpbook", "xnpphoto", "xnpwebsite", "xnpdata", "xnpsound", "xnpvideo", "xnpbulletin"};
    private String importdir = null;
    private ArrayList<LibraryData> metadata = new ArrayList();
    private Text MessageArea = null;
    private String log = "";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite upper = new Composite(parent, 0);
        upper.setLayout((Layout)new GridLayout(3, false));
        upper.setLayoutData((Object)new GridData(768));
        Composite lower = new Composite(parent, 0);
        lower.setLayout((Layout)new GridLayout(1, false));
        lower.setLayoutData((Object)new GridData(1808));
        Button LoadBtn = new Button(upper, 4096);
        LoadBtn.setText("Load");
        LoadBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                FileDialog fd = new FileDialog(parent.getShell(), 4096);
                String csvfile = fd.open();
                DataConverterView.this.importdir = FileUtil.getDirectory(csvfile);
                DataLoader loader = new DataLoader(csvfile);
                DataConverterView.this.metadata = loader.run();
                if (loader.getLog() == "") {
                    DataConverterView.this.showMessage("Metadata was successfully loaded from " + csvfile + ".\n");
                } else {
                    DataConverterView.this.showMessage(loader.getLog());
                }
            }
        });
        Combo TypeChooser = new Combo(upper, 8);
        int i = 0;
        while (i < ITEMTYPES.length) {
            TypeChooser.add(ITEMTYPES[i]);
            ++i;
        }
        TypeChooser.select(0);
        TypeChooser.setLayoutData((Object)new GridData(768));
        Button ExportBtn = new Button(upper, 4096);
        ExportBtn.setText("Export");
        ExportBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                DirectoryDialog dd = new DirectoryDialog(parent.getShell());
                String exportdir = dd.open();
                DataExporter exporter = new DataExporter(DataConverterView.this.importdir, exportdir, DataConverterView.this.metadata, TypeChooser.getText());
                exporter.run();
                String message = exporter.getLog();
                if (message == "") {
                    DataConverterView.this.showMessage("Convert process seemed to be complete.");
                } else {
                    DataConverterView.this.showMessage(message);
                }
            }
        });
        this.MessageArea = new Text(lower, 2562);
        this.MessageArea.setLayoutData((Object)new GridData(1808));
    }

    public void showMessage(String message) {
        this.log = String.valueOf(this.log) + message + "\n";
        this.MessageArea.setText(this.log);
    }

    public void setFocus() {
    }
}

