/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.wakhok.tomoharu.csv;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CSVTokenizer
implements Enumeration {
    public static final String copyright = "Copyright 1997 TAMURA Kent\nCopyright 1999 ANDOH Tomoharu";
    private String source;
    private int currentPosition;
    private int maxPosition;

    public CSVTokenizer(String line) {
        this.source = line;
        this.currentPosition = 0;
        this.maxPosition = line.length();
    }

    private int nextComma(int ind) {
        boolean inquote = false;
        while (ind < this.maxPosition) {
            char ch = this.source.charAt(ind);
            if (!inquote && ch == ',') break;
            if ('\"' == ch) {
                inquote = !inquote;
            }
            ++ind;
        }
        return ind;
    }

    public int countTokens() {
        int i = 0;
        int ret = 1;
        while ((i = this.nextComma(i)) < this.maxPosition) {
            ++i;
            ++ret;
        }
        return ret;
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException(String.valueOf(this.toString()) + "#nextToken");
        }
        int st = this.currentPosition;
        this.currentPosition = this.nextComma(this.currentPosition);
        StringBuffer strb = new StringBuffer();
        while (st < this.currentPosition) {
            char ch;
            if ((ch = this.source.charAt(st++)) == '\"') {
                if (st >= this.currentPosition || this.source.charAt(st) != '\"') continue;
                strb.append(ch);
                ++st;
                continue;
            }
            strb.append(ch);
        }
        ++this.currentPosition;
        return new String(strb);
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasMoreTokens() {
        return this.nextComma(this.currentPosition) <= this.maxPosition;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public String toString() {
        return "CSVTokenizer(\"" + this.source + "\")";
    }
}

