// $Id$
//
// Copyright (C) 2006 BEE Co.,Ltd.
//
// Author : Fukasawa Mitsuo
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//

#ifndef XML_SCHEMA_HXX_
#define XML_SCHEMA_HXX_

#include <string>
//#include "boost/pimpl_ptr.hpp"

namespace xml_schema
{

//
// Base
//
class base
{
public:
	base(): base_("") {}
	base(const base& rhs): base_(rhs.base_) {}
	~base() {}

    base& operator=(const base& rhs)
    {
    	base tmp(rhs);
    	base_ = tmp.base_;
    	return *this;
    }
    
    // Get/Set
    const std::string& name() const { return base_; }
    void  name(const std::string& name) { base_ = name; }
    
private:
    std::string base_;
};

//
// Language
//
class lang
{
public:
    lang() : lang_("") {}
    lang(const char * lang) : lang_(lang) {}
    lang(const std::string& lang) : lang_(lang) {}
  	lang(const lang& rhs) : lang_(rhs.lang_) {}
    ~lang() {}
    
    lang& operator=(const lang& rhs)
    {
    	lang tmp(rhs);
    	lang_ = tmp.lang_;
    	return *this;
    }

    // Get/Set
    const std::string& name() const { return lang_; } 
    void  name(const std::string& lang) { lang_ = lang; } 
    	
private:
  	std::string lang_;
};

//
// Space
//
class space
{
	space(): space_("") {}
	space(const space& rhs): space_(rhs.space_) {}
	~space() {}

    space& operator=(const space& rhs)
    {
    	space tmp(rhs);
    	space_ = tmp.space_;
    	return *this;
    }
    // Get/Set
    const std::string& name() const { return space_; } 
    void  name(const std::string& space) { space_ = space; } 

private:
    std::string space_;
};

//
// URI
//
class uri
{
public:
    uri();
    uri(const char * uri);
    uri(const std::string& lang);
  	uri(const uri& rhs);
    ~uri();
    
    uri& operator=(const uri& rhs);

    // Get/Set
    const std::string& name() const { return name_; } 
    const std::string& path() const { return path_; } 
    const std::string& fragment() const { return fragment_; } 
    void  name(const std::string& uri); 
    	
private:
    std::string name_;
    std::string path_;
    std::string fragment_;
    
    class URI * uri_;
    //boost::pimpl_ptr<URI> uri_; 
};


}  // namespace

#endif /*XML_SCHEMA_HXX_*/
