// $Id$
//
// Copyright (C) 2006 BEE Co.,Ltd.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//

#ifndef XML_SCHEMA_PARSER_HXX_
#define XML_SCHEMA_PARSER_HXX_

#include "srgs/xml.hxx"
#include "srgs/xml_schema.hxx"

namespace xml_schema { namespace parser
{

//
// Language
//
struct lang: ::namespace_::lang<xml_schema::lang>
{
	typedef namespace_::lang<xml_schema::lang> base_type;
	
    virtual void pre() {}
    virtual void _any_characters(const ::xsd::cxx::parser::ro_string< char >& v)
    {
        //TRACE_FUNCTION("xml_schema::parser::lang::_any_characters");
        //TRACE_DEBUG_FMT("%1%", v);
        lang_.name(v);
    }
    
    virtual xml_schema::lang post() { return lang_; }

private:
    xml_schema::lang lang_;
};

//
// Space
//
#if 0
class space: namespace_::space<xml_schema::space>
{
public:
	typedef namespace_::space<xml_schema::space> base_type;
	
    virtual void pre() {}
    virtual xml_schema::space post() { return space_; }

private:
    xml_schema::space space_;
};
#endif

} }  // namespace

#endif /*XML_SCHEMA_PARSER_HXX_*/
