// $Id$
//
// Copyright (C) 2006 BEE Co.,Ltd.
//
// Author : Fukasawa Mitsuo
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//

#include "srgs/srgs.hxx"

namespace srgs
{

//-----------------------------------------------------------------------------
//  element
//
char * element::type_names[] =
{
    "<unknown>", "<rule>", "<item>", "<one-of>", "<ruleref>", "<tag>",
    "<token>", "<start>", "<end>", "<head>", "<tail>"
};

//-----------------------------------------------------------------------------
// 'rulrref' element
//
static ruleref_manager _ruleref_manager;

ruleref_manager * ruleref_manager::instance()
{
    return &_ruleref_manager;
}

//-----------------------------------------------------------------------------
void ruleref::uri(const std::string& uri)
{
    TRACE_FUNCTION("srgs::ruleref::special");
    if (! special_.empty())
    {
        TRACE_ERROR_FMT("illegal to provide both uri(%1%) and special(%2%)",
                        uri % special_);
        available_ = false;
    }
    uri_.name(uri);  // parse uri
    if ((uri_.path().empty()) &&
        (! ruleref_manager::instance()->grammar().empty()))
    {
        std::string tmp = ruleref_manager::instance()->grammar();
        tmp += "#";
        tmp += uri_.fragment();
        this->str(tmp);
    }
    else if (uri_.path().empty())
    {
        this->str(uri_.fragment());
    }
    else
    {
        this->str(uri_.name());
    }
    ruleref_manager::instance()->insert(this);
}

//-----------------------------------------------------------------------------
// 'one-of' element
//
void one_of::clear()
{
   	this->element::clear();
    lang_ = "";
    for (size_t i = 0; i < items_.size(); i++)
    {
       	items_[i]->clear();
    }
   	items_.clear();
}

void one_of::add(const srgs::item_ptr& item)
{
    TRACE_FUNCTION("srgs::one_of::add");
    if (! item.get()->available())
    {
        TRACE_DEBUG("ignore item tag (probabbly, empty)");
        return ;
    }
    items_.push_back(item.shared());
}

void one_of::dump(std::ostream& out, int indent) const
{
    std::string space(indent * 2, ' ');
    out << space << "one_of: " << "\n";
    for (size_t i = 0; i < items_.size(); i++)
    {
    	if (items_[i]->terminate())
    	{
    		out << space << "  item: "
    		    << items_[i]->str() << "(" << items_[i]->tag_string() << ")\n";
    	}
   	    else
   	        items_[i]->dump(out, indent + 1);
    }
}

//-----------------------------------------------------------------------------
// 'item' element
//
srgs::item item::Null;

item::item() : srgs::element(element::ITEM), tag_(),
    weight_(""), repeat_(), repeat_prob_(0.0), lang_(),
    terminate_(false)
{
} 

item::item(const item& rhs) : srgs::element(rhs), tag_(rhs.tag_),
    weight_(rhs.weight_), repeat_(rhs.repeat_),
    repeat_prob_(rhs.repeat_prob_), lang_(rhs.lang_),
    expantions_(rhs.expantions_), terminate_(rhs.terminate_)
{
} 

}  // namespace
