

#include "srgs/srgs.hxx"
#include<boost/tokenizer.hpp>


namespace srgs
{

const srgs::rule * search_rule(const xml_schema::uri& uri)
{
    TRACE_FUNCTION("srgs::search_rule");
    const srgs::rule * result = NULL;
    std::string pathname = uri.path();
    if (pathname.empty())
    {
        pathname = getopt_infile();
    }
    const srgs::grammar * gram = grammar_manager::instance()->get(pathname);
    if (gram == NULL)
    {
        TRACE_ERROR_FMT("Error, grammar is not found(%1%)", pathname);
        throw srgs::exception("grammar not found");
    }
    result = gram->find(uri.fragment());
    if (result == NULL)
    {
        TRACE_ERROR_FMT("Error, rule is not found(%1%)", uri.name());
        throw srgs::exception("rule not found");
    }
    return result;   
}

  
} // namespace
