/* $Id$ */

//=============================================================================
/**
 *  @file    repeat.hpp
 *
 *  @author Fukasawa Mitsuo
 *
 *    Copyright (C) 2006 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef SRGS_REPEAT_HPP
#define SRGS_REPEAT_HPP

namespace srgs
{
//
// reperat attribute class
//
struct repeat
{
    repeat() : min_(1), max_(1) {}
    repeat(const std::string& range) : min_(1), max_(1) { this->set(range); }
    repeat(const repeat& rhs) : min_(rhs.min_), max_(rhs.max_) {}
    ~repeat() {}
        
    repeat& operator=(const repeat& rhs)
    {
        if (this != &rhs)
        {
            min_ = rhs.min_;
            max_ = rhs.max_;
        }
        return *this;
    }
        
    int set(const std::string& range)
    {
        if (range.empty())
        {
            min_ = 1;
            max_ = 1;
            return -1;
        }
        size_t p = range.find('-');
        if (p == 0)
        {   // "-" or "-m"
            return -1;
        }
        min_ = strtol(range.c_str(), NULL, 10);
        if (p == std::string::npos)
        {   // "n"
            if (min_ == 0)
                min_ = -1;
            max_ = min_;
        }
        else if (p == (range.size() - 1))
        {   // "n-"
            max_ = 0;   // 0 is unlimited
        }
        else
        {   // "n-m"
            max_ = strtol(range.substr(p+1).c_str(), NULL, 10);
            if (min_ > max_)
                std::swap(min_, max_);
            if (min_ == 0 && min_ == max_)
                min_ = max_ = -1;
        }
        return 0;
    }

    inline int  min() const       { return min_; }
    inline int  max() const       { return max_; }
    inline bool option() const    { return (min_ == 0); }
    inline bool unlimited() const { return (max_ == 0); }
    inline bool once() const      { return (min_ == 1 && min_ == max_); }
    inline bool range() const     { return (min_ != max_); }
    inline bool none() const      { return (min_ == -1 && min_ == max_); }

    void dump(std::ostream& out) const
    {
        if (once())
            return ;
        if (option() && unlimited())
            out << "[+]"; 
        else if (option())
            out << "[*]"; 
        else if (unlimited())
            out << "[" << min_ << "+]"; 
        else if (range())
            out << "[" << min_ << ".." << max_ << "]"; 
        else 
            out << "[" << min_ << "]"; 
    }
        
    int min_;
    int max_;
};

}
#endif /* SRGS_REPEAT_HPP */
