/* $Id$ */

//=============================================================================
/**
 *  @file    grammar_visitor.hpp
 *
 *  @author Fukasawa Mitsuo
 *
 *    Copyright (C) 2006 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "bee/booster.hpp"
#include "srgs/srgs-parser.hxx"
#include "srgs/xml_schema-parser.hxx"
#include "srgs/grammar_visitor.hpp"
#include <boost/graph/graphviz.hpp>

namespace srgs
{

void grammar_graph::make_graphviz(std::ostream& out, const std::string& grfname)
{
    using namespace boost;
    
    GraphvizDigraph g;
    typedef property<edge_name_t, std::string> EdgeProperty;

    std::vector<int>         node_types;
    std::vector<std::string> node_names;
    std::vector<std::string> edge_values;
    graph_traits<graph_t>::vertex_iterator vi;
    for (vi = vertices(graph_).first; vi != vertices(graph_).second; ++vi)
    {
        node_types.push_back(node_map_[*vi].type());
        node_names.push_back(node_map_[*vi].name());
    }
    graph_traits<graph_t>::edge_iterator ei, ei_end;
    for (tie(ei, ei_end) = edges(graph_); ei != ei_end; ++ei)
    {
        boost::add_edge(get(node_map_, source(*ei, graph_)).number(),
                        get(node_map_, target(*ei, graph_)).number(),
                        g);
        //edge_values.push_back(get(node_map_, target(*ei, graph_)).str());
        edge_values.push_back(arc_map_[*ei].value());
    }

    // graphviz's graph
    property_map<GraphvizDigraph, vertex_attribute_t>::type vattr_map =
        get(vertex_attribute, g);
    property_map<GraphvizDigraph, edge_attribute_t>::type eattr_map =
        get(edge_attribute, g);
    graph_traits<GraphvizDigraph>::vertex_iterator i, i_end;
    for (tie(i, i_end) = vertices(g); i != i_end; ++i)
    {
        if (node_types[*i] == element::START || node_types[*i] == element::END)
        {
            vattr_map[*i]["shape"] = "doublecircle";
        }
        vattr_map[*i]["label"] = node_names[*i];
    }

    property_map<GraphvizDigraph, edge_index_t>::type idxmap = get(edge_index, g);
    graph_traits<GraphvizDigraph>::edge_iterator j, j_end;
    for (tie(j, j_end) = edges(g); j != j_end; ++j)
    {
        int idx = idxmap[*j];
        eattr_map[*j]["label"] = edge_values[idx];
    }

    // set header of graphviz
    get_property(g, graph_graph_attribute)["rankdir"] = "LR";
    get_property(g, graph_graph_attribute)["size"] = "18,12";
    get_property(g, graph_graph_attribute)["ratio"] = "fill";
    get_property(g, graph_vertex_attribute)["shape"] = "circle";
    get_property(g, graph_edge_attribute)["fontname"] = "sazanami-mincyo.ttf";

    write_graphviz(out, g, make_vertex_attributes_writer(g),
                           make_edge_attributes_writer(g),
                           make_graph_attributes_writer(g));
    
}

} // namespace
