// $Id$

//=============================================================================
/**
 *  @file    booster.hpp
 *
 *  @author Fukasawa Mitsuo
 *
  *    Copyright (C) 2004-2006 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BEE_BOOSTER_H
#define BEE_BOOSTER_H

#ifdef _MSC_VER
#pragma warning( disable: 4244 )
#endif

#include <boost/config.hpp>
#include <boost/cstdint.hpp>
#include <boost/cstdlib.hpp>
#include <boost/any.hpp>
#include <boost/format.hpp>
//#include <boost/filesystem.hpp>
#include <boost/filesystem/operations.hpp>   // includes path.hpp
#include <boost/filesystem/convenience.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/shared_ptr.hpp>
//#include <boost/algorithm/string.hpp>  // error in xsd

//
// Definition of Boost
//
#define FORMATSTR(f,p)    (boost::str(boost::format(f) % p))

namespace bee
{

class pathname: public boost::filesystem::path
{
public:
    typedef boost::filesystem::path base_type;

    pathname() : base_type() {}
    pathname(const std::string& name) : base_type(name)
    {
        name_ = this->base_type::leaf();
        name_ = name_.substr(0, name_.rfind('.'));
    }
    
    pathname& operator=(const pathname& rhs)
    {
        if (this != &rhs)
        {
            this->base_type::operator=(rhs);
            name_ = rhs.name_;
        }
        return *this;
    }
    pathname& operator=(const base_type& rhs)
    {
        if (this != &rhs)
        {
            this->base_type::operator=(rhs);
            name_ = this->base_type::leaf();
            name_ = name_.substr(0, name_.rfind('.'));
        }
        return *this;
    }
    pathname& operator=(const char * rhs)
    {
        this->base_type::operator=(rhs);
        name_ = this->base_type::leaf();
        name_ = name_.substr(0, name_.rfind('.'));
        return *this;
    }
    
    // Get/Set
    const std::string& name() const { return name_; }
    
private:
    std::string name_;
};

}  // namespace

#endif
