/* $Id$ */

//=============================================================================
/**
 *  @file    beeconf.hpp
 *
 *  @author Fukasawa Mitsuo
 *
 *virtual
 *    Copyright (C) 1998-2006 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BEE_BEECONF_H
#define BEE_BEECONF_H

/*---------------------------------------------------------------------------*/
/*  system header files                                                      */
/*---------------------------------------------------------------------------*/
#include <cstdlib>
#include <climits>
#include <cstdarg>
#include <cstring>
#include <ctime>
#include <cwchar>
#include <cwctype>
#include <cerrno>

#ifdef _MSC_VER
#include <tchar.h>
#else
typedef char   TCHAR;
#define _T(x)  x

#define BCHAR   TCHAR
#define _TX     _T

#endif

#ifdef __GNUC__
/* disable warning for undefined cuserid(); */
#ifndef __USE_XOPEN
#define __USE_XOPEN
#endif
#include <unistd.h>
#endif

#include <iostream>
#include <streambuf>
#include <sstream>
#include <typeinfo>
#include <string>
#include <vector>
#include <map>
#include <set>
#include <stdexcept>

#include "bee/BEE_Export.h"

/*****************************************************************************/
/*                                                                           */
/*  Symbol                                                                   */
/*                                                                           */
/*****************************************************************************/

namespace bee
{

/*---------------------------------------------------------------------------*/
/*  Define data types                                                        */
/*---------------------------------------------------------------------------*/
#ifndef NULL
#define NULL    0
#endif

#ifndef UCHAR
typedef unsigned char   UCHAR;
#endif
#ifndef BYTE
typedef unsigned char   BYTE;
#endif
#ifndef WORD
typedef unsigned short  WORD;
#endif
#ifndef PTR
typedef void *          PTR;
#endif
#ifndef USHORT
typedef unsigned short  USHORT;
#endif
#if defined(__GNUC__) && !defined(UINT)
typedef unsigned int    UINT;
#endif
#ifndef ULONG
typedef unsigned long   ULONG;
#endif

#ifndef uchar
typedef unsigned char   uchar;
#endif
#ifndef byte
typedef unsigned char   byte;
#endif
#ifndef word
typedef unsigned short  word;
#endif
#ifndef ushort
typedef unsigned short  ushort;
#endif
#ifndef uint
typedef unsigned int    uint;
#endif
#ifndef ulong
typedef unsigned long   ulong;
#endif

#if _MSC_VER
typedef __int64             LONGLONG;
typedef unsigned __int64    ULONGLONG;
#elif __GNUC__
typedef long long           LONGLONG;
typedef unsigned long long  ULONGLONG;
#else
#error no support 64 bit data type; // LongLong ?
#endif

/*----------------------------------------------------------------------------*/
/*  limit values                                                              */
/*----------------------------------------------------------------------------*/
#define MAX_INT         2147483647
#define MAX_UINT        0xFFFFFFFF
#define MAX_INTSTR      "2147483647"
#define MAX_UINTSTR     "4294967295"

#define MAX_SHORT       32767
#define MAX_LONG        2147483647
#define MAX_USHORT      0xFFFF
#define MAX_ULONG       0xFFFFFFFF
#define MAX_SHORTCARD   0xFFFF
#define MAX_LONGCARD    0xFFFFFFFF
#define MAX_SHORTSTR    "32767"
#define MAX_LONGSTR     "2147483647"
#define MAX_USHORTSTR   "65535"
#define MAX_ULONGSTR    "4294967295"
#define MIN_REAL        ((REAL)1.40129846432481707e-45)
#define MAX_REAL        ((REAL)3.40282346638528860e+38)
#define MIN_LONGREAL    4.94065645841246544e-324
#define MAX_LONGREAL    1.79769313486231470e+308
#define MAX_LLSTR       "9223372036854775807"

/*****************************************************************************/
/*  Define ASCII codes                                                       */
/*****************************************************************************/
#ifdef WIN32
#define DIR_SEPARATOR_STRING  _TX("\\")
#define DIR_SEPARATOR_CHAR    '\\'
#else
#define DIR_SEPARATOR_STRING  _TX("/")
#define DIR_SEPARATOR_CHAR    '/'
#endif

#define TAB         '\t'        /* C definition of ASCII tab                 */
#define NEWLINE     '\n'        /* C definition of ASCII newline             */
#define BACKSPACE   '\b'        /* C definition of ASCII backspace           */
#define SPACE       ' '         /* white space character                     */

#define C_ESC       0x1B        /* Standard definition ASCII escape          */
#define C_BS        0x08        /* Standard definition ASCII backspace       */
#define C_CR        0x0D        /* Standard definition ASCII carriage return */
#define C_FF        0x0C        /* Standard definition ASCII form feed       */
#define C_BEL       0x07        /* Standard definition ASCII bell            */
#define C_HT        0x09        /* Standard definition ASCII horizontal tab  */
#define C_LF        0x0A        /* Standard definition ASCII line feed       */
#define C_VT        0x0B        /* Standard definition ASCII virtical tab    */
#define C_SUB       0x1A
#define C_RS        0x1E

/*****************************************************************************/
/*                                                                           */
/*  function macros                                                          */
/*                                                                           */
/*****************************************************************************/
#ifndef MAX
#define MAX(a, b)              ((a) >= (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a, b)              ((a) <= (b) ? (a) : (b))
#endif
#ifndef ABS
#define ABS(n)                 ((n) > 0 ? (n) : -(n))
#endif

/* check even and odd  */
#define EVEN(x)                (!((x) & 1))
#define ODD(x)                 (((x) & 1))

#define EQUALSTR(s, c)         ((*s == *c) && (_tcscmp(s, c) == 0))

/*---------------------------------------------------------------------------*/
/*  define boolean                                                           */
/*---------------------------------------------------------------------------*/
#ifndef TRUE
#define TRUE         1
#endif
#ifndef FALSE
#define FALSE        0
#endif
#ifndef SUCCESS
#define SUCCESS      0
#endif
#ifndef FAIL
#define FAIL        (-1)
#endif

#ifndef OK
#define OK           0
#endif
#ifndef NG
#define NG           1
#endif

#ifndef YES
#define YES          1
#endif
#ifndef NO
#define NO           0
#endif

#ifndef ON
#define ON           1
#endif
#ifndef OFF
#define OFF          0
#endif

#define BEE_SUCCESS  0
#define BEE_ERROR    (-1)

#ifndef LOOP
#define LOOP    for(;;)
#endif

#ifndef BIG_ENDIAN
#define BIG_ENDIAN     1234
#define LITTLE_ENDIAN  4321
#endif
#if defined(_M_IX86) || defined(__386__) || defined(i386)
#define ENDIAN         LITTLE_ENDIAN
#else
#define ENDIAN         BIG_ENDIAN
#endif


} // *namespace* - bee


#endif  /* BEE_BEECONF_H */
