package org.torikiri.xlsapi.style;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.torikiri.xlsapi.XlsContext;

public class StringDataFormat extends DataFormat {

	private String format;

	public StringDataFormat(String format) {
		this.format = format;
	}

	public void build(XlsContext ctx, HSSFCellStyle style) {
		short fmt = HSSFDataFormat.getBuiltinFormat(format);
		if (fmt > 0) {
			style.setDataFormat(fmt);
		} else {
			style.setDataFormat(ctx.getCurrentBook().createDataFormat().getFormat(format));
		}		
	}
}
