package org.torikiri.xlsapi.sheet;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.torikiri.xlsapi.DefaultProperty;
import org.torikiri.xlsapi.XlsContext;

public class ColumnGroupCollapsed extends DefaultProperty<HSSFSheet> {

	private short columnNumber;

	private boolean collapsed;

	public ColumnGroupCollapsed(short columnNumber, boolean collapsed) {
		this.columnNumber = columnNumber;
		this.collapsed = collapsed;
	}

	public void build(XlsContext ctx, HSSFSheet sheet) {
		sheet.setColumnGroupCollapsed(columnNumber, collapsed);
	}
}
