package org.torikiri.xlsapi;

import java.util.Calendar;
import java.util.Date;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.torikiri.xlsapi.cell.AsActive;
import org.torikiri.xlsapi.cell.BooleanCellValue;
import org.torikiri.xlsapi.cell.CalendarCellValue;
import org.torikiri.xlsapi.cell.CellType;
import org.torikiri.xlsapi.cell.DateCellValue;
import org.torikiri.xlsapi.cell.DoubleCellValue;
import org.torikiri.xlsapi.cell.StringCellValue;

public class Cell extends AbstractStyle<Cell> {

	private int index;

	private Style style;

	private PropertySet<HSSFCell, Property<HSSFCell>> properties = new PropertySet<HSSFCell, Property<HSSFCell>>();

	public Cell() {}

	public Cell(int index) {
		this.index = index;
	}

	public Cell(boolean value) {
		this(-1, value);
	}

	public Cell(Calendar value) {
		this(-1, value);
	}

	public Cell(Date value) {
		this(-1, value);
	}

	public Cell(double value) {
		this(-1, value);
	}

	public Cell(String value) {
		this(-1, value);
	}

	public Cell(int index, boolean value) {
		this(index, value, null);
	}

	public Cell(int index, Calendar value) {
		this(index, value, null);
	}

	public Cell(int index, Date value) {
		this(index, value, null);
	}

	public Cell(int index, double value) {
		this(index, value, null);
	}

	public Cell(int index, String value) {
		this(index, value, null);
	}

	public Cell(int index, boolean value, Style style) {
		this(index, new BooleanCellValue(value), style);
	}

	public Cell(int index, Calendar value, Style style) {
		this(index, new CalendarCellValue(value), style);
	}

	public Cell(int index, Date value, Style style) {
		this(index, new DateCellValue(value), style);
	}

	public Cell(int index, double value, Style style) {
		this(index, new DoubleCellValue(value), style);
	}

	public Cell(int index, String value, Style style) {
		this(index, new StringCellValue(value), style);
	}

	private Cell(int index, Property<HSSFCell> value, Style style) {
		this.index = index;
		this.style = style;
		add(value);
	}

	public Cell active(boolean active) {
		return add(new AsActive());
	}

	public Cell style(Style style) {
		this.style = style;
		return this;
	}

	public Cell cellType(int cellType) {
		return add(new CellType(cellType));
	}

	protected int getIndex() {
		return index;
	}

	public void build(XlsContext ctx, HSSFCell cell) {
		properties.build(ctx, cell);
		if (style != null) {
			HSSFCellStyle cellStyle = ctx.getCurrentBook().createCellStyle();
			style.build(ctx, cellStyle);
			cell.setCellStyle(cellStyle);
		}
		// TODO
//		cell.setCellErrorValue((byte)0);
//		cell.setCellComment(comment)
//		cell.setCellErrorValue(value)
//		cell.setCellFormula(formula)
//		cell.setCellType(cellType)
//		cell.setHyperlink(link)
	}

	protected Cell add(Property<HSSFCell> property) {
		properties.add(property);
		return this;
	}

	protected Cell add(StyleProperty a) {
		if (style == null) style = new Style();
		style.add(a);
		return this;
	}
}
