package org.torikiri.xlsapi;

import org.torikiri.xlsapi.style.Alignment;
import org.torikiri.xlsapi.style.BorderBottom;
import org.torikiri.xlsapi.style.BorderLeft;
import org.torikiri.xlsapi.style.BorderRight;
import org.torikiri.xlsapi.style.BorderTop;
import org.torikiri.xlsapi.style.BottomBorderColor;
import org.torikiri.xlsapi.style.FillBackgroundColor;
import org.torikiri.xlsapi.style.FillForegroundColor;
import org.torikiri.xlsapi.style.FillPattern;
import org.torikiri.xlsapi.style.Hidden;
import org.torikiri.xlsapi.style.Indention;
import org.torikiri.xlsapi.style.LeftBorderColor;
import org.torikiri.xlsapi.style.Locked;
import org.torikiri.xlsapi.style.RightBorderColor;
import org.torikiri.xlsapi.style.Rotation;
import org.torikiri.xlsapi.style.ShortDataFormat;
import org.torikiri.xlsapi.style.StringDataFormat;
import org.torikiri.xlsapi.style.TopBorderColor;
import org.torikiri.xlsapi.style.VerticalAlign;
import org.torikiri.xlsapi.style.WrapText;

public abstract class AbstractStyle<T> {

	public T alignment(short align) {
		return add(new Alignment(align));
	}

	public T borderBottom(short border) {
		return add(new BorderBottom(border));
	}

	public T borderLeft(short border) {
		return add(new BorderLeft(border));
	}

	public T borderRight(short border) {
		return add(new BorderRight(border));
	}

	public T borderTop(short border) {
		return add(new BorderTop(border));
	}

	public T bottomBorderColor(short color) {
		return add(new BottomBorderColor(color));
	}

	public T dataFormat(short dataFormat) {
		return add(new ShortDataFormat(dataFormat));
	}

	public T dataFormat(String format) {
		return add(new StringDataFormat(format));
	}

	public T fillBackgroundColor(short color) {
		return add(new FillBackgroundColor(color));
	}

	public T fillForegroundColor(short color) {
		return add(new FillForegroundColor(color));
	}

	public T fillPattern(short fillPattern) {
		return add(new FillPattern(fillPattern));
	}

	public T hidden(boolean hidden) {
		return add(new Hidden(hidden));
	}

	public T indention(short indent) {
		return add(new Indention(indent));
	}

	public T leftBorderColor(short border) {
		return add(new LeftBorderColor(border));
	}

	public T locked(boolean locked) {
		return add(new Locked(locked));
	}

	public T rightBorderColor(short color) {
		return add(new RightBorderColor(color));
	}

	public T rotation(short rotation) {
		return add(new Rotation(rotation));
	}

	public T topBorderColor(short color) {
		return add(new TopBorderColor(color));
	}

	public T verticalAlign(short align) {
		return add(new VerticalAlign(align));
	}

	public T wrapText(boolean wrapped) {
		return add(new WrapText(wrapped));
	}

	protected abstract T add(StyleProperty property);

}
