package org.torikiri.xlsapi;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractElement<E, C> implements Element<E, C> {

	protected List<C> children = new ArrayList<C>();

	public final E add(C... children) {
		return add(true, children);
	};

	public final E add(boolean condition, C... children) {
		if (condition) for (C c : children) this.children.add(c);;
		return getThis();
	};

	public abstract E getThis();
}
