/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.poi.POIDocument;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.eventmodel.EventRecordFactory;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSSFWorkbook
extends POIDocument {
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = 3;
    private Workbook workbook;
    protected List _sheets;
    private ArrayList names;
    private boolean preserveNodes;
    private HSSFDataFormat formatter;
    private HSSFRow.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$usermodel$HSSFWorkbook == null ? (class$org$apache$poi$hssf$usermodel$HSSFWorkbook = HSSFWorkbook.class$("org.apache.poi.hssf.usermodel.HSSFWorkbook")) : class$org$apache$poi$hssf$usermodel$HSSFWorkbook);
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};
    public static final byte ENCODING_COMPRESSED_UNICODE = 0;
    public static final byte ENCODING_UTF_16 = 1;
    static /* synthetic */ Class class$org$apache$poi$hssf$usermodel$HSSFWorkbook;

    public HSSFWorkbook() {
        this(Workbook.createWorkbook());
    }

    protected HSSFWorkbook(Workbook book) {
        super(null, null);
        this.workbook = book;
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem fs) throws IOException {
        this(fs, true);
    }

    public HSSFWorkbook(POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this(fs.getRoot(), fs, preserveNodes);
    }

    private static String getWorkbookDirEntryName(DirectoryNode directory) {
        String[] potentialNames = WORKBOOK_DIR_ENTRY_NAMES;
        for (int i = 0; i < potentialNames.length; ++i) {
            String wbName = potentialNames[i];
            try {
                directory.getEntry(wbName);
                return wbName;
            }
            catch (FileNotFoundException e) {
                continue;
            }
        }
        try {
            directory.getEntry("Book");
            throw new IllegalArgumentException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    public HSSFWorkbook(DirectoryNode directory, POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        super(directory, fs);
        Sheet sheet;
        String workbookName = HSSFWorkbook.getWorkbookDirEntryName(directory);
        this.preserveNodes = preserveNodes;
        if (!preserveNodes) {
            this.filesystem = null;
            this.directory = null;
        }
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
        DocumentInputStream stream = directory.createDocumentInputStream(workbookName);
        EventRecordFactory factory = new EventRecordFactory();
        List records = RecordFactory.createRecords(stream);
        this.workbook = Workbook.createWorkbook(records);
        this.setPropertiesFromWorkbook(this.workbook);
        int recOffset = this.workbook.getNumRecords();
        int sheetNum = 0;
        this.convertLabelRecords(records, recOffset);
        while (recOffset < records.size() && (recOffset = (sheet = Sheet.createSheet(records, sheetNum++, recOffset)).getEofLoc() + 1) != 1) {
            HSSFSheet hsheet = new HSSFSheet(this, sheet);
            this._sheets.add(hsheet);
        }
        for (int i = 0; i < this.workbook.getNumNames(); ++i) {
            HSSFName name = new HSSFName(this, this.workbook.getNameRecord(i));
            this.names.add(name);
        }
    }

    public HSSFWorkbook(InputStream s) throws IOException {
        this(s, true);
    }

    public HSSFWorkbook(InputStream s, boolean preserveNodes) throws IOException {
        this(new POIFSFileSystem(s), preserveNodes);
    }

    private void setPropertiesFromWorkbook(Workbook book) {
        this.workbook = book;
    }

    private void convertLabelRecords(List records, int offset) {
        if (log.check(1)) {
            log.log(1, "convertLabelRecords called");
        }
        for (int k = offset; k < records.size(); ++k) {
            Record rec = (Record)records.get(k);
            if (rec.getSid() != 516) continue;
            LabelRecord oldrec = (LabelRecord)rec;
            records.remove(k);
            LabelSSTRecord newrec = new LabelSSTRecord();
            int stringid = this.workbook.addSSTString(new UnicodeString(oldrec.getValue()));
            newrec.setRow(oldrec.getRow());
            newrec.setColumn(oldrec.getColumn());
            newrec.setXFIndex(oldrec.getXFIndex());
            newrec.setSSTIndex(stringid);
            records.add(k, newrec);
        }
        if (log.check(1)) {
            log.log(1, "convertLabelRecords exit");
        }
    }

    public HSSFRow.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    public void setMissingCellPolicy(HSSFRow.MissingCellPolicy missingCellPolicy) {
        this.missingCellPolicy = missingCellPolicy;
    }

    public void setSheetOrder(String sheetname, int pos) {
        this._sheets.add(pos, this._sheets.remove(this.getSheetIndex(sheetname)));
        this.workbook.setSheetOrder(sheetname, pos);
    }

    private void validateSheetIndex(int index) {
        int lastSheetIx = this._sheets.size() - 1;
        if (index < 0 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range (0.." + lastSheetIx + ")");
        }
    }

    public void setSelectedTab(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        for (int i = 0; i < nSheets; ++i) {
            this.getSheetAt(i).setSelected(i == index);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)1);
    }

    public void setSelectedTab(short index) {
        this.setSelectedTab((int)index);
    }

    public void setSelectedTabs(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            this.validateSheetIndex(indexes[i]);
        }
        int nSheets = this._sheets.size();
        for (int i = 0; i < nSheets; ++i) {
            boolean bSelect = false;
            for (int j = 0; j < indexes.length; ++j) {
                if (indexes[j] != i) continue;
                bSelect = true;
                break;
            }
            this.getSheetAt(i).setSelected(bSelect);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)indexes.length);
    }

    public void setActiveSheet(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        for (int i = 0; i < nSheets; ++i) {
            this.getSheetAt(i).setActive(i == index);
        }
        this.workbook.getWindowOne().setActiveSheetIndex(index);
    }

    public int getActiveSheetIndex() {
        return this.workbook.getWindowOne().getActiveSheetIndex();
    }

    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    public void setFirstVisibleTab(int index) {
        this.workbook.getWindowOne().setFirstVisibleTab(index);
    }

    public void setDisplayedTab(short index) {
        this.setFirstVisibleTab(index);
    }

    public int getFirstVisibleTab() {
        return this.workbook.getWindowOne().getFirstVisibleTab();
    }

    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    public void setSheetName(int sheetIx, String name) {
        if (this.workbook.doesContainsSheetName(name, sheetIx)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetName(sheetIx, name);
    }

    public void setSheetName(int sheetIx, String name, short encoding) {
        if (this.workbook.doesContainsSheetName(name, sheetIx)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(sheetIx);
        switch (encoding) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported encoding");
            }
        }
        this.workbook.setSheetName(sheetIx, name, encoding);
    }

    public String getSheetName(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.getSheetName(sheetIx);
    }

    public boolean isSheetHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetHidden(sheetIx);
    }

    public void setSheetHidden(int sheetIx, boolean hidden) {
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    public int getSheetIndex(String name) {
        int retval = this.workbook.getSheetIndex(name);
        return retval;
    }

    public int getSheetIndex(HSSFSheet sheet) {
        for (int i = 0; i < this._sheets.size(); ++i) {
            if (this._sheets.get(i) != sheet) continue;
            return i;
        }
        return -1;
    }

    public short getExternalSheetIndex(int internalSheetIndex) {
        return this.workbook.checkExternSheet(internalSheetIndex);
    }

    public HSSFSheet createSheet() {
        HSSFSheet sheet = new HSSFSheet(this);
        this._sheets.add(sheet);
        this.workbook.setSheetName(this._sheets.size() - 1, "Sheet" + (this._sheets.size() - 1));
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    public HSSFSheet cloneSheet(int sheetNum) {
        String index;
        String name;
        this.validateSheetIndex(sheetNum);
        HSSFSheet srcSheet = (HSSFSheet)this._sheets.get(sheetNum);
        String srcName = this.workbook.getSheetName(sheetNum);
        HSSFSheet clonedSheet = srcSheet.cloneSheet(this);
        clonedSheet.setSelected(false);
        clonedSheet.setActive(false);
        this._sheets.add(clonedSheet);
        int i = 1;
        do {
            name = srcName;
            index = Integer.toString(i++);
        } while (this.workbook.getSheetIndex(name = name.length() + index.length() + 2 < 31 ? name + "(" + index + ")" : name.substring(0, 31 - index.length() - 2) + "(" + index + ")") != -1);
        this.workbook.setSheetName(this._sheets.size() - 1, name);
        return clonedSheet;
    }

    public HSSFSheet createSheet(String sheetname) {
        if (this.workbook.doesContainsSheetName(sheetname, this._sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet sheet = new HSSFSheet(this);
        this._sheets.add(sheet);
        this.workbook.setSheetName(this._sheets.size() - 1, sheetname);
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    private HSSFSheet[] getSheets() {
        HSSFSheet[] result = new HSSFSheet[this._sheets.size()];
        this._sheets.toArray(result);
        return result;
    }

    public HSSFSheet getSheetAt(int index) {
        return (HSSFSheet)this._sheets.get(index);
    }

    public HSSFSheet getSheet(String name) {
        HSSFSheet retval = null;
        for (int k = 0; k < this._sheets.size(); ++k) {
            String sheetname = this.workbook.getSheetName(k);
            if (!sheetname.equalsIgnoreCase(name)) continue;
            retval = (HSSFSheet)this._sheets.get(k);
        }
        return retval;
    }

    public SheetReferences getSheetReferences() {
        return this.workbook.getSheetReferences();
    }

    public void removeSheetAt(int index) {
        this.validateSheetIndex(index);
        boolean wasActive = this.getSheetAt(index).isActive();
        boolean wasSelected = this.getSheetAt(index).isSelected();
        this._sheets.remove(index);
        this.workbook.removeSheet(index);
        int nSheets = this._sheets.size();
        if (nSheets < 1) {
            return;
        }
        int newSheetIndex = index;
        if (newSheetIndex >= nSheets) {
            newSheetIndex = nSheets - 1;
        }
        if (wasActive) {
            this.setActiveSheet(newSheetIndex);
        }
        if (wasSelected) {
            boolean someOtherSheetIsStillSelected = false;
            for (int i = 0; i < nSheets; ++i) {
                if (!this.getSheetAt(i).isSelected()) continue;
                someOtherSheetIsStillSelected = true;
                break;
            }
            if (!someOtherSheetIsStillSelected) {
                this.setSelectedTab(newSheetIndex);
            }
        }
    }

    public void setBackupFlag(boolean backupValue) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(backupValue ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        if (startColumn == -1 && endColumn != -1) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow == -1 && endRow != -1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn < -1 || startColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (endColumn < -1 || endColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow < -1 || startRow > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (endRow < -1 || endRow > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn > endColumn) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow > endRow) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        HSSFSheet sheet = this.getSheetAt(sheetIndex);
        short externSheetIndex = this.getWorkbook().checkExternSheet(sheetIndex);
        boolean settingRowAndColumn = startColumn != -1 && endColumn != -1 && startRow != -1 && endRow != -1;
        boolean removingRange = startColumn == -1 && endColumn == -1 && startRow == -1 && endRow == -1;
        boolean isNewRecord = false;
        NameRecord nameRecord = this.findExistingRowColHeaderNameRecord(sheetIndex);
        if (removingRange) {
            if (nameRecord != null) {
                this.workbook.removeName(this.findExistingRowColHeaderNameRecordIdx(sheetIndex + 1));
            }
            return;
        }
        if (nameRecord == null) {
            nameRecord = this.workbook.createBuiltInName((byte)7, sheetIndex + 1);
            isNewRecord = true;
        }
        short definitionTextLength = settingRowAndColumn ? (short)26 : 11;
        nameRecord.setDefinitionTextLength(definitionTextLength);
        Stack<Ptg> ptgs = new Stack<Ptg>();
        if (settingRowAndColumn) {
            ptgs.add(new MemFuncPtg(23));
        }
        if (startColumn >= 0) {
            Area3DPtg area3DPtg1 = new Area3DPtg();
            area3DPtg1.setExternSheetIndex(externSheetIndex);
            area3DPtg1.setFirstColumn((short)startColumn);
            area3DPtg1.setLastColumn((short)endColumn);
            area3DPtg1.setFirstRow(0);
            area3DPtg1.setLastRow(-1);
            ptgs.add(area3DPtg1);
        }
        if (startRow >= 0) {
            Area3DPtg area3DPtg2 = new Area3DPtg();
            area3DPtg2.setExternSheetIndex(externSheetIndex);
            area3DPtg2.setFirstColumn((short)0);
            area3DPtg2.setLastColumn((short)255);
            area3DPtg2.setFirstRow((short)startRow);
            area3DPtg2.setLastRow((short)endRow);
            ptgs.add(area3DPtg2);
        }
        if (settingRowAndColumn) {
            ptgs.add(UnionPtg.instance);
        }
        nameRecord.setNameDefinition(ptgs);
        if (isNewRecord) {
            HSSFName newName = new HSSFName(this, nameRecord);
            this.names.add(newName);
        }
        HSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setValidSettings(false);
        sheet.setActive(true);
    }

    private NameRecord findExistingRowColHeaderNameRecord(int sheetIndex) {
        int index = this.findExistingRowColHeaderNameRecordIdx(sheetIndex);
        if (index == -1) {
            return null;
        }
        return (NameRecord)this.workbook.findNextRecordBySid((short)24, index);
    }

    private int findExistingRowColHeaderNameRecordIdx(int sheetIndex) {
        int index = 0;
        NameRecord r = null;
        while ((r = (NameRecord)this.workbook.findNextRecordBySid((short)24, index)) != null) {
            int indexToSheet = r.getEqualsToIndexToSheet() - 1;
            if (indexToSheet > -1) {
                int nameRecordSheetIndex = this.workbook.getSheetIndexFromExternSheetIndex(indexToSheet);
                if (this.isRowColHeaderRecord(r) && nameRecordSheetIndex == sheetIndex) {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }

    private boolean isRowColHeaderRecord(NameRecord r) {
        return r.getOptionFlag() == 32 && "\u0007".equals(r.getNameText());
    }

    public HSSFFont createFont() {
        FontRecord font = this.workbook.createNewFont();
        short fontindex = (short)(this.getNumberOfFonts() - 1);
        if (fontindex > 3) {
            fontindex = (short)(fontindex + 1);
        }
        if (fontindex == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of fonts was exceeded");
        }
        HSSFFont retval = new HSSFFont(fontindex, font);
        return retval;
    }

    public HSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (short i = 0; i < this.workbook.getNumberOfFontRecords(); i = (short)((short)(i + 1))) {
            FontRecord font;
            HSSFFont hssfFont;
            if (i == 4 || (hssfFont = new HSSFFont(i, font = this.workbook.getFontRecordAt(i))).getBoldweight() != boldWeight || hssfFont.getColor() != color || hssfFont.getFontHeight() != fontHeight || !hssfFont.getFontName().equals(name) || hssfFont.getItalic() != italic || hssfFont.getStrikeout() != strikeout || hssfFont.getTypeOffset() != typeOffset || hssfFont.getUnderline() != underline) continue;
            return hssfFont;
        }
        return null;
    }

    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    public HSSFFont getFontAt(short idx) {
        FontRecord font = this.workbook.getFontRecordAt(idx);
        HSSFFont retval = new HSSFFont(idx, font);
        return retval;
    }

    public HSSFCellStyle createCellStyle() {
        ExtendedFormatRecord xfr = this.workbook.createCellXF();
        short index = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle style = new HSSFCellStyle(index, xfr, this);
        return style;
    }

    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    public HSSFCellStyle getCellStyleAt(short idx) {
        ExtendedFormatRecord xfr = this.workbook.getExFormatAt(idx);
        HSSFCellStyle style = new HSSFCellStyle(idx, xfr, this);
        return style;
    }

    public void write(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        POIFSFileSystem fs = new POIFSFileSystem();
        ArrayList<String> excepts = new ArrayList<String>(1);
        fs.createDocument(new ByteArrayInputStream(bytes), "Workbook");
        this.writeProperties(fs, excepts);
        if (this.preserveNodes) {
            excepts.add("Workbook");
            excepts.add("WORKBOOK");
            this.copyNodes(this.filesystem, fs, excepts);
        }
        fs.writeFilesystem(stream);
    }

    public byte[] getBytes() {
        if (log.check(1)) {
            log.log(1, "HSSFWorkbook.getBytes()");
        }
        HSSFSheet[] sheets = this.getSheets();
        int nSheets = sheets.length;
        for (int i = 0; i < nSheets; ++i) {
            sheets[i].getSheet().preSerialize();
        }
        int totalsize = this.workbook.getSize();
        int[] estimatedSheetSizes = new int[nSheets];
        for (int k = 0; k < nSheets; ++k) {
            int sheetSize;
            this.workbook.setSheetBof(k, totalsize);
            estimatedSheetSizes[k] = sheetSize = sheets[k].getSheet().getSize();
            totalsize += sheetSize;
        }
        byte[] retval = new byte[totalsize];
        int pos = this.workbook.serialize(0, retval);
        for (int k = 0; k < nSheets; ++k) {
            int serializedSize = sheets[k].getSheet().serialize(pos, retval);
            if (serializedSize != estimatedSheetSizes[k]) {
                throw new IllegalStateException("Actual serialized sheet size (" + serializedSize + ") differs from pre-calculated size (" + estimatedSheetSizes[k] + ") for sheet (" + k + ")");
            }
            pos += serializedSize;
        }
        return retval;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    public String getSSTString(int index) {
        return this.workbook.getSSTString(index).getString();
    }

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    public int getNumberOfNames() {
        int result = this.names.size();
        return result;
    }

    public HSSFName getNameAt(int index) {
        HSSFName result = (HSSFName)this.names.get(index);
        return result;
    }

    public String getNameName(int index) {
        String result = this.getNameAt(index).getNameName();
        return result;
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        return this.workbook.resolveNameXText(refIndex, definedNameIndex);
    }

    public void setPrintArea(int sheetIndex, String reference) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            name = this.workbook.createBuiltInName((byte)6, sheetIndex + 1);
        }
        short externSheetIndex = this.getWorkbook().checkExternSheet(sheetIndex);
        name.setExternSheetNumber(externSheetIndex);
        name.setAreaReference(reference);
    }

    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        CellReference cell = new CellReference(startRow, startColumn, true, true);
        String reference = cell.formatAsString();
        cell = new CellReference(endRow, endColumn, true, true);
        reference = reference + ":" + cell.formatAsString();
        this.setPrintArea(sheetIndex, reference);
    }

    public String getPrintArea(int sheetIndex) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            return null;
        }
        return name.getAreaReference(this);
    }

    public void removePrintArea(int sheetIndex) {
        this.getWorkbook().removeBuiltinRecord((byte)6, sheetIndex + 1);
    }

    public HSSFName createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName newName = new HSSFName(this, nameRecord);
        this.names.add(newName);
        return newName;
    }

    public int getNameIndex(String name) {
        int retval = -1;
        for (int k = 0; k < this.names.size(); ++k) {
            String nameName = this.getNameName(k);
            if (!nameName.equalsIgnoreCase(name)) continue;
            retval = k;
            break;
        }
        return retval;
    }

    public void removeName(int index) {
        this.names.remove(index);
        this.workbook.removeName(index);
    }

    public HSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    public void removeName(String name) {
        int index = this.getNameIndex(name);
        this.removeName(index);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    public void insertChartRecord() {
        int loc = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] data = new byte[]{15, 0, 0, -16, 82, 0, 0, 0, 0, 0, 6, -16, 24, 0, 0, 0, 1, 8, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 51, 0, 11, -16, 18, 0, 0, 0, -65, 0, 8, 0, 8, 0, -127, 1, 9, 0, 0, 8, -64, 1, 64, 0, 0, 8, 64, 0, 30, -15, 16, 0, 0, 0, 13, 0, 0, 8, 12, 0, 0, 8, 23, 0, 0, 8, -9, 0, 0, 16};
        UnknownRecord r = new UnknownRecord(235, data);
        this.workbook.getRecords().add(loc, r);
    }

    public void dumpDrawingGroupRecords(boolean fat) {
        DrawingGroupRecord r = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        r.decode();
        List escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        Iterator iterator = escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    public int addPicture(byte[] pictureData, int format) {
        byte[] uid = this.newUID();
        EscherBitmapBlip blipRecord = new EscherBitmapBlip();
        blipRecord.setRecordId((short)(-4072 + format));
        switch (format) {
            case 2: {
                blipRecord.setOptions((short)15680);
                break;
            }
            case 3: {
                blipRecord.setOptions((short)8544);
                break;
            }
            case 4: {
                blipRecord.setOptions((short)21536);
                break;
            }
            case 6: {
                blipRecord.setOptions((short)28160);
                break;
            }
            case 5: {
                blipRecord.setOptions((short)18080);
                break;
            }
            case 7: {
                blipRecord.setOptions((short)31360);
            }
        }
        blipRecord.setUID(uid);
        blipRecord.setMarker((byte)-1);
        blipRecord.setPictureData(pictureData);
        EscherBSERecord r = new EscherBSERecord();
        r.setRecordId((short)-4089);
        r.setOptions((short)(2 | format << 4));
        r.setBlipTypeMacOS((byte)format);
        r.setBlipTypeWin32((byte)format);
        r.setUid(uid);
        r.setTag((short)255);
        r.setSize(pictureData.length + 25);
        r.setRef(1);
        r.setOffset(0);
        r.setBlipRecord(blipRecord);
        return this.workbook.addBSERecord(r);
    }

    public List getAllPictures() {
        ArrayList pictures = new ArrayList();
        Iterator recordIter = this.workbook.getRecords().iterator();
        while (recordIter.hasNext()) {
            Object obj = recordIter.next();
            if (!(obj instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)obj).decode();
            List escherRecords = ((AbstractEscherHolderRecord)obj).getEscherRecords();
            this.searchForPictures(escherRecords, pictures);
        }
        return pictures;
    }

    private void searchForPictures(List escherRecords, List pictures) {
        Iterator recordIter = escherRecords.iterator();
        while (recordIter.hasNext()) {
            EscherBlipRecord blip;
            Object obj = recordIter.next();
            if (!(obj instanceof EscherRecord)) continue;
            EscherRecord escherRecord = (EscherRecord)obj;
            if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                pictures.add(new HSSFPictureData(blip));
            }
            this.searchForPictures(escherRecord.getChildRecords(), pictures);
        }
    }

    public boolean isWriteProtected() {
        return this.workbook.isWriteProtected();
    }

    public void writeProtectWorkbook(String password, String username) {
        this.workbook.writeProtectWorkbook(password, username);
    }

    public void unwriteProtectWorkbook() {
        this.workbook.unwriteProtectWorkbook();
    }

    public List getAllEmbeddedObjects() {
        ArrayList objects = new ArrayList();
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            this.getAllEmbeddedObjects(this.getSheetAt(i).getSheet().getRecords(), objects);
        }
        return objects;
    }

    private void getAllEmbeddedObjects(List records, List objects) {
        Iterator recordIter = records.iterator();
        while (recordIter.hasNext()) {
            Object obj = recordIter.next();
            if (!(obj instanceof ObjRecord)) continue;
            Iterator subRecordIter = ((ObjRecord)obj).getSubRecords().iterator();
            while (subRecordIter.hasNext()) {
                Object sub = subRecordIter.next();
                if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
                objects.add(new HSSFObjectData((ObjRecord)obj, this.filesystem));
            }
        }
    }

    private byte[] newUID() {
        byte[] bytes = new byte[16];
        return bytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

