/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.LittleEndian;

public final class DeletedArea3DPtg
extends OperandPtg {
    public static final byte sid = 61;
    private final int field_1_index_extern_sheet;
    private final int unused1;
    private final int unused2;

    public DeletedArea3DPtg(RecordInputStream in) {
        this.field_1_index_extern_sheet = in.readUShort();
        this.unused1 = in.readInt();
        this.unused2 = in.readInt();
    }

    public String toFormulaString(HSSFWorkbook book) {
        return HSSFErrorConstants.getText(23);
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public int getSize() {
        return 11;
    }

    public void writeBytes(byte[] data, int offset) {
        LittleEndian.putByte(data, 0 + offset, 61 + this.getPtgClass());
        LittleEndian.putUShort(data, 1 + offset, this.field_1_index_extern_sheet);
        LittleEndian.putInt(data, 3 + offset, this.unused1);
        LittleEndian.putInt(data, 7 + offset, this.unused2);
    }
}

