/*
 * Decompiled with CFR 0.152.
 */
package org.torikiri.xlsapi;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.torikiri.xlsapi.AbstractElement;
import org.torikiri.xlsapi.Cell;
import org.torikiri.xlsapi.Property;
import org.torikiri.xlsapi.PropertySet;
import org.torikiri.xlsapi.XlsContext;
import org.torikiri.xlsapi.row.RowHeight;
import org.torikiri.xlsapi.row.RowHeightInPoints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row
extends AbstractElement<Row, Cell> {
    private int index = -1;
    private PropertySet<HSSFRow, Property<HSSFRow>> properties = new PropertySet();

    public Row(Cell ... cells) {
        this.add(cells);
    }

    public Row(int index, Cell ... cells) {
        this.index = index;
        this.add(cells);
    }

    public Row height(int height) {
        return this.add(new RowHeight((short)height));
    }

    public Row height(short height) {
        return this.add(new RowHeight(height));
    }

    public Row heightInPoints(int heightInPoints) {
        return this.add(new RowHeightInPoints(heightInPoints));
    }

    public Row heightInPoints(float heightInPoints) {
        return this.add(new RowHeightInPoints(heightInPoints));
    }

    private Row add(Property<HSSFRow> property) {
        this.properties.add(property);
        return this;
    }

    protected int getIndex() {
        return this.index;
    }

    protected void build(XlsContext ctx, HSSFRow row) {
        int i = 0;
        for (Cell c : this.children) {
            i = c.getIndex() < 0 ? i : c.getIndex();
            c.build(ctx, ctx.nextCell(i++));
        }
        this.properties.build(ctx, row);
    }

    @Override
    public Row getThis() {
        return this;
    }
}

