package org.torikiri.xlsapi.sheet;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.torikiri.xlsapi.DefaultProperty;
import org.torikiri.xlsapi.XlsContext;

public class Margin extends DefaultProperty<HSSFSheet> {

	private short margin;

	private double size;

	public Margin(short margin, double size) {
		this.margin = margin;
		this.size = size;
	}

	public void build(XlsContext ctx, HSSFSheet sheet) {
		sheet.setMargin(margin, size);
	}
}
