/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.HashSet;
import org.apache.poi.hwpf.model.FIBFieldHandler;
import org.apache.poi.hwpf.model.FIBLongHandler;
import org.apache.poi.hwpf.model.FIBShortHandler;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.model.types.FIBAbstractType;

public class FileInformationBlock
extends FIBAbstractType
implements Cloneable {
    FIBLongHandler _longHandler;
    FIBShortHandler _shortHandler;
    FIBFieldHandler _fieldHandler;

    public FileInformationBlock(byte[] mainDocument) {
        this.fillFields(mainDocument, 0);
    }

    public void fillVariableFields(byte[] mainDocument, byte[] tableStream) {
        HashSet<Integer> fieldSet = new HashSet<Integer>();
        fieldSet.add(new Integer(1));
        fieldSet.add(new Integer(33));
        fieldSet.add(new Integer(31));
        fieldSet.add(new Integer(12));
        fieldSet.add(new Integer(13));
        fieldSet.add(new Integer(6));
        fieldSet.add(new Integer(73));
        fieldSet.add(new Integer(74));
        fieldSet.add(new Integer(16));
        fieldSet.add(new Integer(15));
        fieldSet.add(new Integer(71));
        fieldSet.add(new Integer(87));
        this._shortHandler = new FIBShortHandler(mainDocument);
        this._longHandler = new FIBLongHandler(mainDocument, 32 + this._shortHandler.sizeInBytes());
        this._fieldHandler = new FIBFieldHandler(mainDocument, 32 + this._shortHandler.sizeInBytes() + this._longHandler.sizeInBytes(), tableStream, fieldSet, true);
    }

    public int getFcDop() {
        return this._fieldHandler.getFieldOffset(31);
    }

    public void setFcDop(int fcDop) {
        this._fieldHandler.setFieldOffset(31, fcDop);
    }

    public int getLcbDop() {
        return this._fieldHandler.getFieldSize(31);
    }

    public void setLcbDop(int lcbDop) {
        this._fieldHandler.setFieldSize(31, lcbDop);
    }

    public int getFcStshf() {
        return this._fieldHandler.getFieldOffset(1);
    }

    public int getLcbStshf() {
        return this._fieldHandler.getFieldSize(1);
    }

    public void setFcStshf(int fcStshf) {
        this._fieldHandler.setFieldOffset(1, fcStshf);
    }

    public void setLcbStshf(int lcbStshf) {
        this._fieldHandler.setFieldSize(1, lcbStshf);
    }

    public int getFcClx() {
        return this._fieldHandler.getFieldOffset(33);
    }

    public int getLcbClx() {
        return this._fieldHandler.getFieldSize(33);
    }

    public void setFcClx(int fcClx) {
        this._fieldHandler.setFieldOffset(33, fcClx);
    }

    public void setLcbClx(int lcbClx) {
        this._fieldHandler.setFieldSize(33, lcbClx);
    }

    public int getFcPlcfbteChpx() {
        return this._fieldHandler.getFieldOffset(12);
    }

    public int getLcbPlcfbteChpx() {
        return this._fieldHandler.getFieldSize(12);
    }

    public void setFcPlcfbteChpx(int fcPlcfBteChpx) {
        this._fieldHandler.setFieldOffset(12, fcPlcfBteChpx);
    }

    public void setLcbPlcfbteChpx(int lcbPlcfBteChpx) {
        this._fieldHandler.setFieldSize(12, lcbPlcfBteChpx);
    }

    public int getFcPlcfbtePapx() {
        return this._fieldHandler.getFieldOffset(13);
    }

    public int getLcbPlcfbtePapx() {
        return this._fieldHandler.getFieldSize(13);
    }

    public void setFcPlcfbtePapx(int fcPlcfBtePapx) {
        this._fieldHandler.setFieldOffset(13, fcPlcfBtePapx);
    }

    public void setLcbPlcfbtePapx(int lcbPlcfBtePapx) {
        this._fieldHandler.setFieldSize(13, lcbPlcfBtePapx);
    }

    public int getFcPlcfsed() {
        return this._fieldHandler.getFieldOffset(6);
    }

    public int getLcbPlcfsed() {
        return this._fieldHandler.getFieldSize(6);
    }

    public void setFcPlcfsed(int fcPlcfSed) {
        this._fieldHandler.setFieldOffset(6, fcPlcfSed);
    }

    public void setLcbPlcfsed(int lcbPlcfSed) {
        this._fieldHandler.setFieldSize(6, lcbPlcfSed);
    }

    public int getFcPlcfLst() {
        return this._fieldHandler.getFieldOffset(73);
    }

    public int getLcbPlcfLst() {
        return this._fieldHandler.getFieldSize(73);
    }

    public void setFcPlcfLst(int fcPlcfLst) {
        this._fieldHandler.setFieldOffset(73, fcPlcfLst);
    }

    public void setLcbPlcfLst(int lcbPlcfLst) {
        this._fieldHandler.setFieldSize(73, lcbPlcfLst);
    }

    public int getFcPlfLfo() {
        return this._fieldHandler.getFieldOffset(74);
    }

    public int getLcbPlfLfo() {
        return this._fieldHandler.getFieldSize(74);
    }

    public void setFcPlfLfo(int fcPlfLfo) {
        this._fieldHandler.setFieldOffset(74, fcPlfLfo);
    }

    public void setLcbPlfLfo(int lcbPlfLfo) {
        this._fieldHandler.setFieldSize(74, lcbPlfLfo);
    }

    public int getFcSttbfffn() {
        return this._fieldHandler.getFieldOffset(15);
    }

    public int getLcbSttbfffn() {
        return this._fieldHandler.getFieldSize(15);
    }

    public void setFcSttbfffn(int fcSttbFffn) {
        this._fieldHandler.setFieldOffset(15, fcSttbFffn);
    }

    public void setLcbSttbfffn(int lcbSttbFffn) {
        this._fieldHandler.setFieldSize(15, lcbSttbFffn);
    }

    public int getFcSttbSavedBy() {
        return this._fieldHandler.getFieldOffset(71);
    }

    public int getLcbSttbSavedBy() {
        return this._fieldHandler.getFieldSize(71);
    }

    public void setFcSttbSavedBy(int fcSttbSavedBy) {
        this._fieldHandler.setFieldOffset(71, fcSttbSavedBy);
    }

    public void setLcbSttbSavedBy(int fcSttbSavedBy) {
        this._fieldHandler.setFieldSize(71, fcSttbSavedBy);
    }

    public int getModifiedLow() {
        return this._fieldHandler.getFieldOffset(74);
    }

    public int getModifiedHigh() {
        return this._fieldHandler.getFieldSize(74);
    }

    public void setModifiedLow(int modifiedLow) {
        this._fieldHandler.setFieldOffset(74, modifiedLow);
    }

    public void setModifiedHigh(int modifiedHigh) {
        this._fieldHandler.setFieldSize(74, modifiedHigh);
    }

    public void setCbMac(int cbMac) {
        this._longHandler.setLong(0, cbMac);
    }

    public int getCcpText() {
        return this._longHandler.getLong(3);
    }

    public void setCcpText(int ccpText) {
        this._longHandler.setLong(3, ccpText);
    }

    public void clearOffsetsSizes() {
        this._fieldHandler.clearFields();
    }

    public int getFcPlcffldMom() {
        return this._fieldHandler.getFieldOffset(16);
    }

    public int getLcbPlcffldMom() {
        return this._fieldHandler.getFieldSize(16);
    }

    public int getFcPlcspaMom() {
        return this._fieldHandler.getFieldOffset(40);
    }

    public int getLcbPlcspaMom() {
        return this._fieldHandler.getFieldSize(40);
    }

    public int getFcDggInfo() {
        return this._fieldHandler.getFieldOffset(50);
    }

    public int getLcbDggInfo() {
        return this._fieldHandler.getFieldSize(50);
    }

    public void writeTo(byte[] mainStream, HWPFOutputStream tableStream) throws IOException {
        super.serialize(mainStream, 0);
        int size = super.getSize();
        this._shortHandler.serialize(mainStream);
        this._longHandler.serialize(mainStream, size + this._shortHandler.sizeInBytes());
        this._fieldHandler.writeTo(mainStream, super.getSize() + this._shortHandler.sizeInBytes() + this._longHandler.sizeInBytes(), tableStream);
    }

    public int getSize() {
        return super.getSize() + this._shortHandler.sizeInBytes() + this._longHandler.sizeInBytes() + this._fieldHandler.sizeInBytes();
    }
}

